﻿---
title: Multiple Elastic Defend Alerts from a Single Process Tree
description: Detects multiple Elastic Defend EDR alerts originating from the same process tree, indicating coordinated malicious activity. Analysts can use this to...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_edr_elastic_same_process_tree
products:
  - Elastic Security
---

# Multiple Elastic Defend Alerts from a Single Process Tree
Detects multiple Elastic Defend EDR alerts originating from the same process tree, indicating coordinated malicious activity.
Analysts can use this to prioritize triage and response, as these hosts are more likely to be compromised.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 8m
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/elastic/protections-artifacts/tree/main/yara/rules](https://github.com/elastic/protections-artifacts/tree/main/yara/rules)](https://github.com/elastic/protections-artifacts/tree/main/yara/rules)
- [[https://github.com/elastic/protections-artifacts/tree/main/behavior](https://github.com/elastic/protections-artifacts/tree/main/behavior)](https://github.com/elastic/protections-artifacts/tree/main/behavior)

**Tags**:
- Use Case: Threat Detection
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide
- Data Source: Elastic Defend

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Multiple Elastic Defend Alerts from a Single Process Tree

Detects multiple Elastic Defend EDR alerts originating from the same process tree, indicating coordinated malicious activity.

### Possible investigation steps

- Review the alert details to identify the specific host involved and the different alerts that triggered.
- Examine the timeline of the alerts to understand the sequence of events and determine the root cause.
- Correlate the alert data with other logs and telemetry from the host, such as process creation, network connections, and file modifications, to gather additional context.
- Check for any indicators of compromise (IOCs) associated with the alerts, such as suspicious IP addresses, domains, or file hashes, and search for these across the network.
- Assess the impact and scope of the potential compromise by determining if other hosts or systems have similar alerts or related activity.


### False positive analysis

- Security tools running on the host might generate multiple alerts from same process tree.
- Automated scripts or batch processes can mimic adversarial behavior. Analyze and whitelist these processes if they are verified as non-threatening.
- Frequent alerts from development or testing environments can be misleading. Consider excluding these environments from the rule or applying a different risk score.


### Response and remediation

- Isolate the affected host from the network immediately to prevent further lateral movement by the adversary.
- Conduct a thorough forensic analysis of the host to identify the specific vulnerabilities exploited and gather evidence of the attack phases involved.
- Remove any identified malicious software or unauthorized access tools from the host, ensuring all persistence mechanisms are eradicated.
- Apply security patches and updates to the host to address any exploited vulnerabilities and prevent similar attacks.
- Restore the host from a known good backup if necessary, ensuring that the backup is free from compromise.
- Monitor the host and network for any signs of re-infection or further suspicious activity, using enhanced logging and alerting based on the identified attack patterns.
- Escalate the incident to the appropriate internal or external cybersecurity teams for further investigation and potential legal action if the attack is part of a larger campaign.


## Rule Query

```esql
from logs-endpoint.alerts-*

// process.Ext.ancestry is an array of all unique process IDs ancestors of the alert actor process ID
| where event.code in ("malicious_file", "memory_signature", "shellcode_thread", "behavior") and
        agent.id is not null and not rule.name in ("Multi.EICAR.Not-a-virus") and process.Ext.ancestry is not null

// aggregate alerts by process.Ext.ancestry and agent.id
| stats Esql.alerts_count = COUNT(*),
        Esql.rule_name_distinct_count = COUNT_DISTINCT(rule.name),
        Esql.event_code_distinct_count = COUNT_DISTINCT(event.code),
        Esql.process_id_distinct_count = COUNT_DISTINCT(process.entity_id),
        Esql.message_values = VALUES(message),
        Esql.user_name_values = VALUES(user.name),
        Esql.threat_tactic_name_values = VALUES(threat.tactic.name),
        Esql.threat_technique_name_values = VALUES(threat.technique.name),
        Esql.process_command_line_values = VALUES(process.command_line),
        Esql.process_parent_executable_values = values(process.parent.executable),
        Esql.file_path_values = VALUES(file.path),
        Esql.file_hash_sha256_values = VALUES(file.hash.sha256),
        Esql.process_hash_sha256_values = VALUES(process.hash.sha256),
        Esql.dns_question_name_values = VALUES(dns.question.name) by process.Ext.ancestry, agent.id

// filter for at least 3 unique process IDs and 2 or more alert types or rule names.
| where Esql.process_id_distinct_count >= 3 and (Esql.rule_name_distinct_count >= 2 or Esql.event_code_distinct_count >= 2)

// keep unique values
| stats Esql.alert_names = values(Esql.message_values),
        Esql.alerts_process_cmdline_values = VALUES(Esql.process_command_line_values),
        Esql.alerts_user_names = VALUES(Esql.user_name_values),
        Esql.alerts_mitre_tactics = values(Esql.threat_tactic_name_values),
        Esql.alerts_mitre_techniques = VALUES(Esql.threat_technique_name_values),
        Esql.alerts_process_parent_executable = values(Esql.process_parent_executable_values),
        Esql.alerts_file_paths = VALUES(Esql.file_path_values),
        Esql.alerts_file_hash_sha256 = VALUES(Esql.file_hash_sha256_values),
        Esql.alerts_process_hash_sha256 = VALUES(Esql.process_hash_sha256_values),
        Esql.alerts_dns_question_names = VALUES(Esql.dns_question_name_values) by agent.id
| keep Esql.*, agent.id
```