﻿---
title: Lateral Movement Alerts from a Newly Observed User
description: This rule detects multiple lateral movement alerts from a user that was observed for the first time in the previous 5 days of alerts history. Analysts...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/lateral_movement_multi_alerts_new_userid
products:
  - Elastic Security
---

# Lateral Movement Alerts from a Newly Observed User
This rule detects multiple lateral movement alerts from a user that was observed for the first time in the previous 5 days
of alerts history. Analysts can use this high-order detection to prioritize triage and response.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 9m
**Searches indices from**: `now-7200m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/docs/solutions/security/detect-and-alert/about-detection-rules](https://www.elastic.co/docs/solutions/security/detect-and-alert/about-detection-rules)](https://www.elastic.co/docs/solutions/security/detect-and-alert/about-detection-rules)

**Tags**:
- OS: Windows
- Use Case: Threat Detection
- Rule Type: Higher-Order Rule
- Tactic: Lateral Movement
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Lateral Movement Alerts from a Newly Observed User

This rule surfaces newly observed, low-frequency source user triggering multiple lateral movement alerts.
Because the alert has not been seen previously for this rule and host, it should be prioritized for validation to determine
whether it represents a true compromise or rare benign activity.

### Investigation Steps

- Identify the source user, affected hosts and review the associated rule name to understand the behavior that triggered the alert.
- Validate the source address and user context under which the activity occurred and assess whether it aligns with normal behavior for that address.
- Refer to the specific rule investigation guide for further actions.


### False Positive Considerations

- Administrative scripts or automation tools can trigger behavior-based detections when first introduced.
- Security tooling, IT management agents, or EDR integrations may generate new behavior alerts during updates or configuration changes.
- Development or testing environments may produce one-off behaviors that resemble malicious techniques.


### Response and Remediation

- If the activity is confirmed malicious, isolate the affected host to prevent further execution or lateral movement.
- Terminate malicious processes and remove any dropped files or persistence mechanisms.
- Collect forensic artifacts to understand initial access and execution flow.
- Patch or remediate any vulnerabilities or misconfigurations that enabled the behavior.
- If benign, document the finding and consider tuning or exception handling to reduce future noise.
- Continue monitoring the host and environment for recurrence of the behavior or related alerts.


## Rule Query

```esql
FROM .alerts-security.* METADATA _index

// Lateral Movement related rules
| where kibana.alert.rule.threat.tactic.name is not null and user.id is not null and 
        (to_string(user.id) like "S-1-5-21*" or to_string(user.id) like "S-1-12-*") and
        host.id is not null and KQL("""kibana.alert.rule.threat.tactic.name : "Lateral Movement" """)

// aggregate stats by user.id
| stats  Esql.first_time_seen = MIN(@timestamp),
         Esql.alerts_count = count(*),
         Esql.unique_rules_count = COUNT_DISTINCT(kibana.alert.rule.name),
         Esql.unique_count_host_id = COUNT_DISTINCT(host.id),
         Esql.rule_name_values = VALUES(kibana.alert.rule.name),
         Esql.host_id_values = VALUES(host.id),
         Esql.host_ip_values = VALUES(host.ip),
         Esql.source_ip_values = VALUES(source.ip),
         Esql.process_cmd_line = VALUES(process.command_line),
         Esql.tactic_name_values = VALUES(kibana.alert.rule.threat.tactic.name) by user.id, user.name

// at least 2 unique lateral movement detection rules from same user.id and that was first seen in last 5 days
| eval Esql.date_diff = DATE_DIFF("minute", Esql.first_time_seen, now())
| where Esql.unique_rules_count >= 2 and
        // matches are within 10m of the rule execution time to avoid alert duplicates
        Esql.date_diff <= 10
| eval source.ip = MV_FIRST(Esql.source_ip_values),  host.id = MV_FIRST(Esql.host_id_values) 
| KEEP Esql.*, user.id, user.name, host.id, source.ip
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)