﻿---
title: Initial Access via File Upload Followed by GET Request
description: This rule detects potential initial access activity where an adversary uploads a web shell or malicious script to a web server via a file upload mechanism...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/initial_access_file_upload_followed_by_get_request
products:
  - Elastic Security
---

# Initial Access via File Upload Followed by GET Request
This rule detects potential initial access activity where an adversary uploads a web shell or malicious script
to a web server via a file upload mechanism (e.g., through a web form using multipart/form-data), followed by
a GET or POST request to access the uploaded file. By checking the body content of HTTP requests for file upload
indicators such as "Content-Disposition: form-data" and "filename=", the rule identifies suspicious upload
activities. This sequence of actions is commonly used by attackers to gain and maintain access to compromised web
servers.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*
- logs-network_traffic.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- Domain: Web
- Domain: Network
- OS: Linux
- OS: Windows
- OS: macOS
- Use Case: Threat Detection
- Tactic: Initial Access
- Tactic: Persistence
- Data Source: Elastic Defend
- Data Source: Network Traffic
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from both Elastic Defend (for file events) and Network Packet Capture integrations (for HTTP traffic analysis).

### Network Packet Capture Integration Setup

**IMPORTANT**: This rule requires HTTP request body capture to be enabled in order to detect the multipart/form-data content containing WebKitFormBoundary indicators. The network traffic integration must be configured to capture HTTP request bodies for POST requests with `multipart/form-data` content type.
To enable HTTP request body capture, follow these steps:
1. Navigate to the Fleet policy leveraging the Network Packet Capture integration in Kibana.
2. Locate and select the "Network Packet Capture" integration, and edit the integration.
3. Locate "Change Default", and scroll down to the "HTTP" section.
4. Enable the "HTTP" toggle to capture HTTP traffic, add the correct ports for your web application, and click "advanced options".
5. Edit the integration settings to enable HTTP request body capture for POST requests with `multipart/form-data` content type.
6. Save the integration configuration and wait for the policy to deploy to the agents.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Initial Access via File Upload Followed by GET Request

This rule flags a common initial-access pattern: a multipart/form-data upload that drops a dynamic web script on a server, followed shortly by a request to execute that file and establish a foothold. Attackers exploit a permissive upload form to plant shell.php or shell.jsp in an uploads or temp directory, then immediately request it to spawn a web shell, enumerate files, and run commands—often leveraging redirects or 2xx/3xx responses that indicate successful placement and access.

### Possible investigation steps

- Correlate the upload transaction with the server-side file creation and the subsequent access to the same resource, matching timestamps, source IP, and path, and follow any redirects to the final executed file.
- Retrieve the uploaded artifact from disk, verify it sits in a web-accessible location, inspect content for web shell traits (eval/system/exec, obfuscation, password gates), and record hashes.
- Examine server process telemetry immediately after the access for interpreter or shell spawns and unexpected outbound connections originating from web server workers.
- Review application logs and access context to determine whether the upload was authenticated, which account or session performed it, and whether user-agent, referer, or headers deviate from normal clients.
- Broaden the timeline to identify related uploads, file renames, or repeated requests from the same actor, including parameterized calls that suggest command execution or directory enumeration.


### False positive analysis

- An authenticated administrator installs a legitimate plugin or module via the application’s upload form, which unpacks or renames .php or .jsp files and then auto-loads a setup page, producing the multipart upload, file creation/rename, and immediate GET pattern.
- Automated deployment or QA routines upload and deploy a .war or server-side script through a web-based admin interface and then perform health-check or warm-up requests, resulting in the same multipart upload, server-side file creation, and follow-up GET sequence.


### Response and remediation

- Immediately block access to the uploaded script that was invoked via GET/POST (e.g., /uploads/shell.php) and the source IPs that executed it, restrict the site to allowlisted IPs or maintenance mode, and temporarily disable the upload endpoint.
- Quarantine and remove the uploaded web shell and any additional executable scripts or WARs in web-accessible directories (uploads, webroot, temp), terminate interpreter or shell processes spawned by the web server account (www-data/nginx/w3wp/tomcat), and revert malicious .htaccess/web.config rewrites.
- Hunt for persistence and lateral-movement artifacts created after the upload, including recent .php/.jsp/.cgi file creations or renames in static asset folders, cron/systemd tasks, startup scripts, unauthorized admin users or plugins, and remove them.
- Restore altered application files from known-good backups or redeploy a clean container/VM, rotate database and API credentials stored in config files or environment variables, invalidate active sessions, and only re-enable uploads after confirming execution is blocked in upload directories.
- Escalate to incident command and privacy/legal if you observe command execution parameters on the uploaded page (?cmd=, ?exec=), shells spawning (/bin/sh, powershell.exe), database dumps, or outbound callbacks from web server processes to external hosts.
- Harden by storing uploads outside the webroot, denying execution in upload paths (disable PHP/CGI handlers and set noexec permissions), enforcing strict extension/MIME allowlists and AV/sandbox scanning for multipart/form-data, enabling file-integrity alerts on new .php/.jsp in served paths, and deploying WAF rules to block direct requests to uploaded executables.


## Rule Query

```eql
sequence by agent.id with maxspan=5m
  [network where
   data_stream.dataset == "network_traffic.http" and
   http.request.method in ("POST", "PUT") and
   /* We can restrict to 200 in the future, but I prefer to broaden the scope and decrease it later if necessary */
   http.response.status_code in (200, 201, 204, 301, 302, 303, 409) and
   /* These should detect most common file upload activities, adhering to browser standards */
   http.request.body.content like "*Content-Disposition: form-data*" and
   http.request.body.content like "*filename=*"
   /* May add a lower/upper boundary limit to reduce FPs in the future, e.g.
   and http.request.body.bytes >= 500
   */
  ]
  [file where
   event.dataset == "endpoint.events.file" and
   event.action in ("creation", "rename") and
   file.extension in ("php", "phtml", "pht", "php5", "asp", "aspx", "jsp", "jspx", "war", "cgi")
   /* We can add file.path values here in the future, if telemetry is noisy */
  ]
  [network where
   data_stream.dataset == "network_traffic.http" and
   http.request.method in ("GET", "POST") and
   /* we may restrict to 200, but keeping it broader right now */
   http.response.status_code >= 200 and http.response.status_code < 600 and
   url.extension in ("php", "phtml", "pht", "php5", "asp", "aspx", "jsp", "jspx", "war", "cgi")
  ]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Server Software Component
- Id: T1505
- Reference URL: [[https://attack.mitre.org/techniques/T1505/](https://attack.mitre.org/techniques/T1505/)](https://attack.mitre.org/techniques/T1505/)
- Sub Technique:
  - Name: Web Shell
- Id: T1505.003
- Reference URL: [[https://attack.mitre.org/techniques/T1505/003/](https://attack.mitre.org/techniques/T1505/003/)](https://attack.mitre.org/techniques/T1505/003/)