﻿---
title: Hosts File Modified
description: The hosts file on endpoints is used to control manual IP address to hostname resolutions. The hosts file is the first point of lookup for DNS hostname...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/impact_hosts_file_modified
products:
  - Elastic Security
---

# Hosts File Modified
The hosts file on endpoints is used to control manual IP address to hostname resolutions. The hosts file is the first
point of lookup for DNS hostname resolution so if adversaries can modify the endpoint hosts file, they can route traffic
to malicious infrastructure. This rule detects modifications to the hosts file on Microsoft Windows, Linux (Ubuntu or
RHEL) and macOS systems.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- winlogbeat-*
- logs-endpoint.events.*
- logs-windows.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/beats/auditbeat/current/auditbeat-reference-yml.html](https://www.elastic.co/guide/en/beats/auditbeat/current/auditbeat-reference-yml.html)](https://www.elastic.co/guide/en/beats/auditbeat/current/auditbeat-reference-yml.html)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: Windows
- OS: macOS
- Use Case: Threat Detection
- Tactic: Impact
- Resources: Investigation Guide
- Data Source: Elastic Defend

**Version**: 214
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

For Windows systems using Auditbeat, this rule requires adding `C:/Windows/System32/drivers/etc` as an additional path in the 'file_integrity' module of auditbeat.yml.
If enabling an EQL rule on a non-elastic-agent index (such as beats) for versions <8.2,
events will not define `event.ingested` and default fallback for EQL rules was not added until version 8.2.
Hence for this rule to work effectively, users will need to add a custom ingest pipeline to populate
`event.ingested` to @timestamp.
For more details on adding a custom ingest pipeline refer - [https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html](https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html)

## Investigation guide


## Triage and analysis


### Investigating Hosts File Modified

Operating systems use the hosts file to map a connection between an IP address and domain names before going to domain name servers. Attackers can abuse this mechanism to route traffic to malicious infrastructure or disrupt security that depends on server communications. For example, Russian threat actors modified this file on a domain controller to redirect Duo MFA calls to localhost instead of the Duo server, which prevented the MFA service from contacting its server to validate MFA login. This effectively disabled MFA for active domain accounts because the default policy of Duo for Windows is to "Fail open" if the MFA server is unreachable. This can happen in any MFA implementation and is not exclusive to Duo. Find more details in this [CISA Alert](https://www.cisa.gov/uscert/ncas/alerts/aa22-074a).
This rule identifies modifications in the hosts file across multiple operating systems using process creation events for Linux and file events in Windows and macOS.

#### Possible investigation steps

- Identify the specifics of the involved assets, such as role, criticality, and associated users.
- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence, whether they are located in expected locations, and if they are signed with valid digital signatures.
- Identify the user account that performed the action and whether it should perform this kind of action.
- Contact the account owner and confirm whether they are aware of this activity.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Examine the changes to the hosts file by comparing it against file backups, volume shadow copies, and other restoration mechanisms.


### False positive analysis

- This mechanism can be used legitimately. Analysts can dismiss the alert if the administrator is aware of the activity and the configuration was justified.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Consider isolating the involved host to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Review the privileges of the administrator account that performed the action.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
any where process.executable != null and

  /* file events for creation; file change events are not captured by some of the included sources for linux and so may
     miss this, which is the purpose of the process + command line args logic below */
  (
   event.category == "file" and event.type in ("change", "creation") and event.action != "rename" and
     file.path : ("/private/etc/hosts", "/etc/hosts", "?:\\Windows\\System32\\drivers\\etc\\hosts") and 
     not process.name in ("dockerd", "rootlesskit", "podman", "crio") and
     not process.executable : ("C:\\Program Files\\Fortinet\\FortiClient\\FCDBLog.exe",
                               "C:\\Program Files\\Fortinet\\FortiClient\\FortiWF.exe",
                               "C:\\Program Files\\Fortinet\\FortiClient\\fmon.exe",
                               "C:\\Program Files\\Seqrite\\Seqrite\\SCANNER.EXE",
                               "C:\\Windows\\System32\\SearchProtocolHost.exe",
                               "C:\\Windows\\Temp\\*.ins\\inst.exe",
                               "C:\\Windows\\System32\\svchost.exe",
                               "C:\\Program Files\\NordVPN\\nordvpn-service.exe",
                               "C:\\Program Files\\Tailscale\\tailscaled.exe",
                               "C:\\Program Files\\Docker\\Docker\\com.docker.service",
                               "C:\\Program Files\\Docker\\Docker\\InstallerCli.exe",
                               "C:\\Program Files\\Quick Heal\\Quick Heal AntiVirus Pro\\scanner.exe",
                               "C:\\Program Files (x86)\\Quick Heal AntiVirus Pro\\SCANNER.EXE",
                               "C:\\Program Files\\Quick Heal\\Quick Heal Internet Security\\scanner.exe",
                               "C:\\Program Files (x86)\\Cisco\\Cisco AnyConnect Secure Mobility Client\\vpnagent.exe",
                               "/Applications/Parallels Desktop.app/Contents/MacOS/prl_naptd",
                               "/opt/IBM/InformationServer/Server/DSEngine/bin/uvsh",
                               "/usr/local/demisto/server", 
                               "/usr/local/bin/defender")
  )
  or

  /* process events for change targeting linux only */
  (
   event.category == "process" and event.type in ("start") and
     process.name in ("nano", "vim", "vi", "emacs", "echo", "sed") and
     (process.args : ("/etc/hosts") or (process.working_directory == "/etc" and process.args == "hosts")) and 
     not process.parent.name in ("dhclient-script", "google_set_hostname") and
     not process.command_line == "sed -i /Added by Google/d /etc/hosts"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Data Manipulation
- Id: T1565
- Reference URL: [[https://attack.mitre.org/techniques/T1565/](https://attack.mitre.org/techniques/T1565/)](https://attack.mitre.org/techniques/T1565/)
- Sub Technique:
  - Name: Stored Data Manipulation
- Id: T1565.001
- Reference URL: [[https://attack.mitre.org/techniques/T1565/001/](https://attack.mitre.org/techniques/T1565/001/)](https://attack.mitre.org/techniques/T1565/001/)