﻿---
title: Potential JAVA/JNDI Exploitation Attempt
description: Identifies an outbound network connection by JAVA to LDAP, RMI or DNS standard ports followed by a suspicious JAVA child processes. This may indicate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_suspicious_java_netcon_childproc
products:
  - Elastic Security
---

# Potential JAVA/JNDI Exploitation Attempt
Identifies an outbound network connection by JAVA to LDAP, RMI or DNS standard ports followed by a suspicious JAVA child
processes. This may indicate an attempt to exploit a JAVA/NDI (Java Naming and Directory Interface) injection
vulnerability.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- logs-endpoint.events.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.lunasec.io/docs/blog/log4j-zero-day/](https://www.lunasec.io/docs/blog/log4j-zero-day/)](https://www.lunasec.io/docs/blog/log4j-zero-day/)
- [[https://github.com/christophetd/log4shell-vulnerable-app](https://github.com/christophetd/log4shell-vulnerable-app)](https://github.com/christophetd/log4shell-vulnerable-app)
- [[https://www.blackhat.com/docs/us-16/materials/us-16-Munoz-A-Journey-From-JNDI-LDAP-Manipulation-To-RCE.pdf](https://www.blackhat.com/docs/us-16/materials/us-16-Munoz-A-Journey-From-JNDI-LDAP-Manipulation-To-RCE.pdf)](https://www.blackhat.com/docs/us-16/materials/us-16-Munoz-A-Journey-From-JNDI-LDAP-Manipulation-To-RCE.pdf)
- [[https://www.elastic.co/security-labs/detecting-log4j2-with-elastic-security](https://www.elastic.co/security-labs/detecting-log4j2-with-elastic-security)](https://www.elastic.co/security-labs/detecting-log4j2-with-elastic-security)
- [[https://www.elastic.co/security-labs/analysis-of-log4shell-cve-2021-45046](https://www.elastic.co/security-labs/analysis-of-log4shell-cve-2021-45046)](https://www.elastic.co/security-labs/analysis-of-log4shell-cve-2021-45046)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: macOS
- Use Case: Threat Detection
- Tactic: Execution
- Use Case: Vulnerability
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential JAVA/JNDI Exploitation Attempt

Java Naming and Directory Interface (JNDI) is a Java API that provides naming and directory functionality, allowing Java applications to discover and look up data and resources via a directory service. Adversaries exploit JNDI by injecting malicious payloads that trigger outbound connections to LDAP, RMI, or DNS services, potentially leading to remote code execution. The detection rule identifies such exploitation attempts by monitoring Java processes making suspicious outbound connections followed by the execution of potentially harmful child processes, such as shell scripts or scripting languages, indicating a possible compromise.

### Possible investigation steps

- Review the network logs to confirm the outbound connection attempt by the Java process to the specified ports (1389, 389, 1099, 53, 5353) and identify the destination IP addresses to determine if they are known malicious or suspicious entities.
- Examine the process tree to verify the parent-child relationship between the Java process and any suspicious child processes such as shell scripts or scripting languages (e.g., sh, bash, curl, python).
- Check the command line arguments and environment variables of the suspicious child processes to identify any potentially malicious payloads or commands being executed.
- Investigate the host's recent activity and logs for any other indicators of compromise or unusual behavior that might correlate with the suspected exploitation attempt.
- Assess the system for any unauthorized changes or new files that may have been introduced as a result of the exploitation attempt, focusing on directories commonly used by Java applications.


### False positive analysis

- Development and testing environments may trigger false positives when developers use Java applications to test connections to LDAP, RMI, or DNS services. To mitigate this, exclude known development servers or IP ranges from the detection rule.
- Automated scripts or maintenance tasks that involve Java applications making legitimate outbound connections to the specified ports can be mistaken for exploitation attempts. Identify and whitelist these scripts or tasks by their process names or hashes.
- Legitimate Java-based applications that require frequent updates or data retrieval from external services might generate similar network patterns. Monitor and document these applications, then create exceptions for their specific network behaviors.
- Security tools or monitoring solutions that use Java for network scanning or analysis might inadvertently match the rule's criteria. Ensure these tools are recognized and excluded by their process identifiers or network activity profiles.


### Response and remediation

- Immediately isolate the affected host from the network to prevent further outbound connections and potential lateral movement.
- Terminate any suspicious Java processes identified in the alert, especially those making outbound connections to LDAP, RMI, or DNS ports.
- Conduct a thorough review of the affected system for any unauthorized changes or additional malicious processes, focusing on child processes like shell scripts or scripting languages.
- Restore the affected system from a known good backup if unauthorized changes or malware are detected.
- Update and patch Java and any related applications to the latest versions to mitigate known vulnerabilities.
- Implement network-level controls to block outbound connections to suspicious or unauthorized LDAP, RMI, or DNS services from Java processes.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to assess the potential impact on other systems within the network.


## Rule Query

```eql
sequence by host.id with maxspan=1m
 [network where event.action == "connection_attempted" and
  process.name : "java" and
  /*
     outbound connection attempt to
     LDAP, RMI or DNS standard ports
     by JAVA process
   */
  destination.port in (1389, 389, 1099, 53, 5353)] by process.pid
 [process where event.type == "start" and

  /* Suspicious JAVA child process */
  process.parent.name : "java" and
   process.name : ("sh",
                   "bash",
                   "dash",
                   "ksh",
                   "tcsh",
                   "zsh",
                   "curl",
                   "perl*",
                   "python*",
                   "ruby*",
                   "php*",
                   "wget") and
    not process.command_line like~ (
      "bash -c ulimit -u",
      "bash /opt/flutter/bin/flutter*",
      "bash -c echo $$",
      "/bin/bash /opt/python3/bin/jira*",
      "/bin/sh -c env LC_ALL=C /usr/sbin/lpc status*"
    )] by process.parent.pid
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: JavaScript
- Id: T1059.007
- Reference URL: [[https://attack.mitre.org/techniques/T1059/007/](https://attack.mitre.org/techniques/T1059/007/)](https://attack.mitre.org/techniques/T1059/007/)
- Technique:
  - Name: Exploitation for Client Execution
- Id: T1203
- Reference URL: [[https://attack.mitre.org/techniques/T1203/](https://attack.mitre.org/techniques/T1203/)](https://attack.mitre.org/techniques/T1203/)