﻿---
title: Potential SAP NetWeaver Exploitation
description: Identifies suspicious processes spawned from the SAP NetWeaver application. This may indicate an attempt to execute commands via webshell. Rule type:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_sap_netweaver_webshell_exec
products:
  - Elastic Security
---

# Potential SAP NetWeaver Exploitation
Identifies suspicious processes spawned from the SAP NetWeaver application. This may indicate an attempt to execute commands via webshell.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- logs-endpoint.events.process*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://reliaquest.com/blog/threat-spotlight-reliaquest-uncovers-vulnerability-behind-sap-netweaver-compromise/](https://reliaquest.com/blog/threat-spotlight-reliaquest-uncovers-vulnerability-behind-sap-netweaver-compromise/)](https://reliaquest.com/blog/threat-spotlight-reliaquest-uncovers-vulnerability-behind-sap-netweaver-compromise/)
- [[https://onapsis.com/blog/active-exploitation-of-sap-vulnerability-cve-2025-31324/](https://onapsis.com/blog/active-exploitation-of-sap-vulnerability-cve-2025-31324/)](https://onapsis.com/blog/active-exploitation-of-sap-vulnerability-cve-2025-31324/)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Use Case: Vulnerability
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Potential SAP NetWeaver Exploitation


### Possible investigation steps

- Examine the process tree to verify the parent-child relationship between the Java process and any suspicious child processes such as shell scripts or scripting languages (e.g., sh, bash, curl, python).
- Check the command line arguments and environment variables of the suspicious child processes to identify any potentially malicious payloads or commands being executed.
- Investigate the host's recent activity and logs for any other indicators of compromise or unusual behavior that might correlate with the suspected exploitation attempt.
- Assess the system for any unauthorized changes or new files that may have been introduced as a result of the exploitation attempt, focusing on JSP files under the IRJ root directory.


### Response and remediation

- Immediately isolate the affected host from the network to prevent further outbound connections and potential lateral movement.
- Terminate any suspicious Java processes identified in the alert, especially those making outbound connections to LDAP, RMI, or DNS ports.
- Conduct a thorough review of the affected system for any unauthorized changes or additional malicious processes, focusing on child processes like shell scripts or scripting languages.
- Restore the affected system from a known good backup if unauthorized changes or malware are detected.
- Update and patch Java and any related applications to the latest versions to mitigate known vulnerabilities.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to assess the potential impact on other systems within the network.


## Rule Query

```eql
process where event.type == "start" and host.os.type in ("linux", "windows") and
   process.name : ("sh",
                   "bash",
                   "dash",
                   "ksh",
                   "tcsh",
                   "zsh",
                   "curl",
                   "perl*",
                   "python*",
                   "ruby*",
                   "php*",
                   "wget",
                   "cmd.exe",
                   "powershell.exe",
                   "rundll32.exe",
                   "msbuild.exe",
                   "curl.exe",
                   "certutil.exe") and
   (
    process.working_directory : ("/*/sap.com*/servlet_jsp/irj/*", "*\\sap.com*\\servlet_jsp\\irj\\*") or
    process.command_line : ("*/sap.com*/servlet_jsp/irj/*", "*\\sap.com*\\servlet_jsp\\irj\\*") or
    process.parent.command_line : ("*/sap.com*/servlet_jsp/irj/*", "*\\sap.com*\\servlet_jsp\\irj\\*")
   )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: JavaScript
- Id: T1059.007
- Reference URL: [[https://attack.mitre.org/techniques/T1059/007/](https://attack.mitre.org/techniques/T1059/007/)](https://attack.mitre.org/techniques/T1059/007/)
- Technique:
  - Name: Exploitation for Client Execution
- Id: T1203
- Reference URL: [[https://attack.mitre.org/techniques/T1203/](https://attack.mitre.org/techniques/T1203/)](https://attack.mitre.org/techniques/T1203/)