﻿---
title: Remote GitHub Actions Runner Registration
description: This rule detects the configuration of a GitHub Actions self-hosted runner using the Runner.Listener binary. When a machine is registered to a remote...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_register_github_actions_runner
products:
  - Elastic Security
---

# Remote GitHub Actions Runner Registration
This rule detects the configuration of a GitHub Actions self-hosted runner using the Runner.Listener binary.
When a machine is registered to a remote repository, its owner gains the ability to execute arbitrary workflow commands on that host.
Unexpected or unauthorized runner registration may indicate adversarial activity aimed at establishing remote code execution
via malicious GitHub workflows.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*
- auditbeat-*
- logs-auditd_manager.auditd-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/blog/shai-hulud-worm-npm-supply-chain-compromise](https://www.elastic.co/blog/shai-hulud-worm-npm-supply-chain-compromise)](https://www.elastic.co/blog/shai-hulud-worm-npm-supply-chain-compromise)
- [[https://socket.dev/blog/shai-hulud-strikes-again-v2](https://socket.dev/blog/shai-hulud-strikes-again-v2)](https://socket.dev/blog/shai-hulud-strikes-again-v2)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: Windows
- OS: macOS
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Initial Access
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Data Source: Auditd Manager
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Remote GitHub Actions Runner Registration

Unexpected or unauthorized Github actions runner registration may indicate adversarial activity aimed at establishing remote code execution via malicious GitHub workflows.

### Possible investigation steps

- Review the remote repository details and reputation.
- Examine the remote repository for any suspicious workflows run commands in the `.github/workflows` folder.
- Examine the execution context like process tree, associated network and file activities.
- Verify if there is adjascent any sensitive file access or collection.
- Correlate with other alerts and investiguate if this activity is related to a supply chain attack.


### False positive analysis

- Authorized configuration changes.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized command execution and potential lateral movement.
- Terminate any suspicious child processes that were initiated by the registered Github actions runner.
- Conduct a thorough review of the affected system's logs and configurations to identify any unauthorized changes or additional indicators of compromise.
- Restore the system from a known good backup if any unauthorized changes or malicious activities are confirmed.
- Implement application whitelisting to prevent unauthorized execution.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to assess the potential impact on the broader network.


## Rule Query

```eql
process where event.type == "start" and event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
 process.name in ("Runner.Listener", "Runner.Listener.exe") and
 process.args == "configure" and process.args == "--url" and process.args == "--token"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Supply Chain Compromise
- Id: T1195
- Reference URL: [[https://attack.mitre.org/techniques/T1195/](https://attack.mitre.org/techniques/T1195/)](https://attack.mitre.org/techniques/T1195/)
- Sub Technique:
  - Name: Compromise Software Supply Chain
- Id: T1195.002
- Reference URL: [[https://attack.mitre.org/techniques/T1195/002/](https://attack.mitre.org/techniques/T1195/002/)](https://attack.mitre.org/techniques/T1195/002/)