﻿---
title: Potential Widespread Malware Infection Across Multiple Hosts
description: This rule uses alert data to determine when a malware signature is triggered in multiple hosts. Analysts can use this to prioritize triage and response,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_potential_widespread_malware_infection
products:
  - Elastic Security
---

# Potential Widespread Malware Infection Across Multiple Hosts
This rule uses alert data to determine when a malware signature is triggered in multiple hosts. Analysts can use this to
prioritize triage and response, as this can potentially indicate a widespread malware infection.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/elastic/protections-artifacts/tree/main/yara/rules](https://github.com/elastic/protections-artifacts/tree/main/yara/rules)](https://github.com/elastic/protections-artifacts/tree/main/yara/rules)

**Tags**:
- Domain: Endpoint
- Data Source: Elastic Defend
- Use Case: Threat Detection
- Tactic: Execution
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Widespread Malware Infection Across Multiple Hosts

Endpoint security technologies monitor and analyze activities on devices to detect malicious behavior. Adversaries exploit these systems by deploying malware that triggers specific signatures across multiple hosts, indicating a coordinated attack. The detection rule identifies such threats by analyzing alert data for specific malware signatures across several hosts, flagging potential widespread infections for prioritized investigation.

### Possible investigation steps

- Review the alert details to identify the specific rule.name and event.code that triggered the alert, focusing on those with a high count of distinct host.id values.
- Correlate the identified rule.name with known malware signatures or recent threat intelligence reports to understand the potential impact and behavior of the malware.
- Examine the affected host.id entries to determine if there are any commonalities, such as shared network segments, user accounts, or software versions, that could indicate the initial infection vector.
- Investigate the timeline of events for each affected host to identify any suspicious activities or anomalies preceding the alert, such as unusual file downloads or execution of unknown processes.
- Check for any additional alerts or logs related to the same host.id entries to assess if there are other indicators of compromise or related malicious activities.
- Coordinate with IT and security teams to isolate affected hosts if necessary, and initiate containment and remediation procedures based on the findings.


### False positive analysis

- Legitimate software updates or installations may trigger malware signatures, especially if they involve new or uncommon software. Users can create exceptions for known software update processes to prevent these alerts from being flagged as potential threats.
- Security testing tools or penetration testing activities might mimic malware behavior, leading to false positives. Analysts should coordinate with IT and security teams to whitelist these activities during scheduled tests.
- Custom scripts or administrative tools that perform automated tasks across multiple hosts can be mistaken for malicious activity. Identifying and excluding these scripts from the rule can reduce unnecessary alerts.
- Frequent use of remote management tools that execute scripts or commands on multiple hosts may trigger alerts. Users should ensure these tools are recognized and excluded from the rule to avoid false positives.
- Known benign applications that use shellcode or memory manipulation techniques for legitimate purposes should be reviewed and added to an exception list to prevent them from being flagged.


### Response and remediation

- Isolate affected hosts immediately to prevent further spread of the malware across the network. This can be done by disconnecting them from the network or using network segmentation techniques.
- Conduct a thorough scan of the isolated hosts using updated antivirus or endpoint detection and response (EDR) tools to identify and remove the malicious files or processes associated with the detected signatures.
- Analyze the identified malware to understand its behavior and entry points. This will help in determining if additional hosts may be compromised and require similar remediation actions.
- Apply security patches and updates to all affected systems to close any vulnerabilities that the malware may have exploited.
- Restore affected systems from clean backups if the malware has caused significant damage or if the integrity of the system cannot be assured after cleaning.
- Monitor network traffic and endpoint activities closely for any signs of persistence or re-infection, using enhanced detection rules and updated threat intelligence feeds.
- Escalate the incident to the appropriate internal or external cybersecurity teams if the infection appears to be part of a larger coordinated attack, ensuring that all relevant data and findings are shared for further investigation and response.


## Rule Query

```esql
from logs-endpoint.alerts-*
| where event.code in ("malicious_file", "memory_signature", "shellcode_thread") and rule.name is not null
| keep host.id, rule.name, event.code
| stats Esql.host_id_count_distinct = count_distinct(host.id) by rule.name, event.code
| where Esql.host_id_count_distinct >= 3
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: User Execution
- Id: T1204
- Reference URL: [[https://attack.mitre.org/techniques/T1204/](https://attack.mitre.org/techniques/T1204/)](https://attack.mitre.org/techniques/T1204/)
- Sub Technique:
  - Name: Malicious File
- Id: T1204.002
- Reference URL: [[https://attack.mitre.org/techniques/T1204/002/](https://attack.mitre.org/techniques/T1204/002/)](https://attack.mitre.org/techniques/T1204/002/)