﻿---
title: Service Account Token or Certificate Access Followed by Kubernetes API Request
description: This rule leverages a combination of Defend for Containers and Kubernetes audit logs to detect the access to the service account token or certificate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_d4c_k8s_mda_service_account_token_access_followed_by_kubernetes_api_request
products:
  - Elastic Security
---

# Service Account Token or Certificate Access Followed by Kubernetes API Request
This rule leverages a combination of Defend for Containers and Kubernetes audit logs to detect the access to the service
account token or certificate followed by the execution of a direct interactive Kubernetes API request. An adversary may
need to access the service account token or certificate to gain access to the Kubernetes API server or other resources
within the cluster. These requests are often used to enumerate the Kubernetes API server or other resources within the
cluster, and may indicate an attempt to move laterally within the cluster.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.file*
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Data Source: Kubernetes
- Domain: Container
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Credential Access
- Tactic: Discovery
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Service Account Token or Certificate Access Followed by Kubernetes API Request

This rule correlates interactive access to a pod’s service account token or CA certificate with a near-immediate Kubernetes API request, signaling credential harvesting to query the cluster and potential lateral movement. An attacker execs into a container, reads /var/run/secrets/kubernetes.io/serviceaccount/token and ca.crt, then uses curl or kubectl with that token and CA to list pods, get secrets, or create a privileged pod to pivot across nodes.

### Possible investigation steps

- Attribute the activity by identifying the pod, container image, node, and interactive session initiator (e.g., kubectl exec) from Kubernetes events and cluster logs to determine whether a human or automation accessed the credentials.
- Retrieve the pod’s service account and enumerate its RBAC bindings to assess effective privileges, highlighting any ability to read secrets, create pods, or modify roles.
- Reconstruct the full sequence of audit log requests tied to that pod/user around the alert, noting resources, verbs, namespaces, response codes, and userAgent to distinguish legitimate controller behavior from reconnaissance.
- Examine the container for signs of token abuse or exfiltration by reviewing shell history and filesystem artifacts, and correlate with network egress from the pod to external destinations.
- Validate that the API request originated from the same pod by matching source IP, node, and TLS client identity, and check for concurrent suspicious activity on the node or other pods.


### False positive analysis

- A cluster operator troubleshooting an issue execs into a pod, inspects the service account token or CA certificate, and then uses the pod’s credentials to make a quick Kubernetes API request to verify permissions or list resources.
- A workload running with TTY/stdin enabled is marked as interactive, and the application legitimately reads the service account token (e.g., on startup or token refresh) to perform routine API operations such as leader election or informer watches, producing the observed file access followed by audit log activity.


### Response and remediation

- Immediately isolate the pod that read /var/run/secrets/kubernetes.io/serviceaccount/token or ca.crt by deleting the pod or scaling its deployment to zero, cordoning its node if similar behavior is seen on other pods, and applying a NetworkPolicy that blocks the pod’s access to the API server while you capture its filesystem.
- Revoke access by removing the implicated service account’s RBAC bindings, recreating the service account to invalidate tokens, restarting any workloads that mount /var/run/secrets/kubernetes.io/serviceaccount, and rotating the service-account signing key if compromise is suspected.
- Validate and recover by reviewing audit records for unauthorized actions (e.g., secrets reads, pod or role changes), rolling back or deleting any malicious resources, and redeploying affected workloads from trusted images with signed releases.
- Escalate to incident response immediately if you observe API requests from the pod that read secrets, create pods in other namespaces, alter Role or ClusterRoleBindings, or transmit the token/ca.crt via curl or similar tooling to external addresses.
- Harden by disabling automountServiceAccountToken on pods that don't require it, scoping service accounts to a single namespace with least‑privilege RBAC, enforcing Pod Security Admission to block privileged/interactive shells, and restricting exec/attach via RBAC or admission policies.


## Rule Query

```eql
sequence with maxspan=60s
  [file where host.os.type == "linux" and event.type == "change" and event.action == "open" and
   file.path in ("/var/run/secrets/kubernetes.io/serviceaccount/token", "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt") and
   process.interactive == true and container.id like "*"] by orchestrator.resource.name
  [any where event.dataset == "kubernetes.audit_logs" and kubernetes.audit.stage in ("ResponseComplete", "ResponseStarted")] by `kubernetes.audit.user.extra.authentication.kubernetes.io/pod-name`
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Unsecured Credentials
- Id: T1552
- Reference URL: [[https://attack.mitre.org/techniques/T1552/](https://attack.mitre.org/techniques/T1552/)](https://attack.mitre.org/techniques/T1552/)
- Sub Technique:
  - Name: Credentials In Files
- Id: T1552.001
- Reference URL: [[https://attack.mitre.org/techniques/T1552/001/](https://attack.mitre.org/techniques/T1552/001/)](https://attack.mitre.org/techniques/T1552/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)