﻿---
title: Direct Interactive Kubernetes API Request by Unusual Utilities
description: This rule leverages a combination of Defend for Containers and Kubernetes audit logs to detect the execution of direct interactive Kubernetes API requests...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_d4c_k8s_mda_kubernetes_api_activity_by_unusual_utilities
products:
  - Elastic Security
---

# Direct Interactive Kubernetes API Request by Unusual Utilities
This rule leverages a combination of Defend for Containers and Kubernetes audit logs to detect the execution of direct
interactive Kubernetes API requests via unusual utilities. An adversary may need to execute direct interactive Kubernetes
API requests to gain access to the Kubernetes API server or other resources within the cluster. These requests are often
used to enumerate the Kubernetes API server or other resources within the cluster, and may indicate an attempt to move
laterally within the cluster.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*
- logs-kubernetes.audit_logs-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Data Source: Kubernetes
- Domain: Container
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Discovery
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Direct Interactive Kubernetes API Request by Unusual Utilities

This rule detects interactive commands executed inside containers that use atypical utilities to hit the Kubernetes API, paired with near-simultaneous API activity on pods, secrets, service accounts, roles/bindings, or pod exec/attach/log/portforward. It surfaces hands-on-keyboard discovery and lateral movement using custom scripts that evade common tool allowlists; for example, an intruder opens a shell in a pod, uses Python to query the in-cluster API to list secrets, then triggers pods/exec to pivot into another workload.

### Possible investigation steps

- Identify the implicated pod, container image, and executing service account, then quickly review its RBAC bindings and effective permissions to determine blast radius.
- Inspect the container’s interactive session context by pulling recent command lines, shell history, environment variables, and mounted service account tokens, and look for custom scripts or binaries issuing HTTP requests.
- Correlate nearby Kubernetes audit entries tied to the same principal and pod to map accessed resources and verbs, noting any exec/attach/portforward or sensitive object interactions across namespaces.
- Review network activity from the pod to the API server and any in-pod proxies, including DNS lookups and outbound connections, to spot nonstandard clients or tunneling behavior.
- If suspicious, isolate the pod or node, capture runtime artifacts (e.g., process memory or HTTP client traffic), revoke and rotate the service account credentials, and verify image provenance and integrity.


### False positive analysis

- An operator interactively attaches to a pod and uses a Python REPL or bash with /dev/tcp to call the in-cluster API for routine troubleshooting (e.g., list pods, read ConfigMaps, or run selfsubjectaccessreviews), producing normal audit entries that match the rule signature.
- A correlation artifact arises when two namespaces have pods with the same name: one pod starts an interactive shell while another independently performs get/list/watch calls, and the 1-second sequence keyed only on pod-name links the unrelated events.


### Response and remediation

- Immediately isolate the implicated pod that issued direct API calls using a nonstandard utility by applying a deny-all egress NetworkPolicy in its namespace (including to kubernetes.default.svc:443), terminating the interactive session, and scaling its owning Deployment/Job/StatefulSet to zero replicas.
- Before teardown, capture a runtime snapshot of the container and node including the binary or script used to query the API (e.g., files under /tmp or /dev/tcp usage), shell history, environment, and the mounted service account token and CA bundle at /var/run/secrets/kubernetes.io/serviceaccount/.
- Revoke access by removing the service account’s RoleBindings/ClusterRoleBindings, deleting all pods that mount that service account to force token rotation, rotating any Secrets and ConfigMaps that were read or created during the window, and deleting any unauthorized Jobs, CronJobs, or Deployments created by the same principal.
- Restore workloads from a known-good image digest, re-enable the Deployment only after image scan and integrity checks pass, and monitor subsequent Kubernetes audit logs for pods/exec, portforward, and access to secrets across the affected namespaces.
- Escalate to incident response leadership and consider cluster-wide containment if audit logs show create/patch of ClusterRoleBindings, access to secrets outside the workload’s namespace, or use of pods/exec to pivot into other nodes or system namespaces such as kube-system.
- Harden access by enforcing least-privilege RBAC that denies pods/exec and attach for application service accounts, setting automountServiceAccountToken: false on workloads that do not need it, restricting egress to the API server with NetworkPolicies, and requiring just-in-time break-glass roles for interactive access.


## Rule Query

```eql
sequence with maxspan=1s
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and process.interactive == true and
  container.id like "*" and
  /* Covered by the rule "Direct Interactive Kubernetes API Request by Common Utilities" */
  not (
     process.name in ("wget", "curl", "openssl", "socat", "ncat", "kubectl") or
     (
       /* Account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
       process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
       process.args in (
         "wget", "/bin/wget", "/usr/bin/wget", "/usr/local/bin/wget",
         "ssl_client", "/bin/ssl_client", "/usr/bin/ssl_client", "/usr/local/bin/ssl_client",
         "curl", "/bin/curl", "/usr/bin/curl", "/usr/local/bin/curl",
         "openssl", "/bin/openssl", "/usr/bin/openssl", "/usr/local/bin/openssl",
         "socat", "/bin/socat", "/usr/bin/socat", "/usr/local/bin/socat",
         "ncat", "/bin/ncat", "/usr/bin/ncat", "/usr/local/bin/ncat",
         "kubectl", "/bin/kubectl", "/usr/bin/kubectl", "/usr/local/bin/kubectl"
       ) and
       /* default exclusion list to not FP on default multi-process commands */
       not process.args in (
         "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
         "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
         "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
         "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
       )
     ) or
     /* General exclusions for utilities that are not typically used for Kubernetes API requests */
     process.name in ("sleep", "head", "tail")
   )] by orchestrator.resource.name
  [any where
     event.dataset == "kubernetes.audit_logs" and
     kubernetes.audit.stage in ("ResponseStarted","ResponseComplete") and
     kubernetes.audit.verb in ("get", "list", "watch", "create", "patch", "update") and
     (
       kubernetes.audit.objectRef.resource in (
         "pods", "secrets", "serviceaccounts", "configmaps",
         "roles", "rolebindings", "clusterroles", "clusterrolebindings",
         "deployments", "daemonsets", "statefulsets", "jobs", "cronjobs",
         "nodes", "namespaces",
         "selfsubjectaccessreviews", "selfsubjectrulesreviews", "subjectaccessreviews"
       )
       or (
         kubernetes.audit.objectRef.resource == "pods" and
         kubernetes.audit.objectRef.subresource in ("exec", "attach", "portforward", "log")
       )
     )
  ] by `kubernetes.audit.user.extra.authentication.kubernetes.io/pod-name`
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)