﻿---
title: Forbidden Direct Interactive Kubernetes API Request
description: This rule leverages a combination of Defend for Containers and Kubernetes audit logs to detect the execution of forbidden interactive Kubernetes API requests...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_d4c_k8s_mda_forbidden_direct_interactive_kubernetes_api_request
products:
  - Elastic Security
---

# Forbidden Direct Interactive Kubernetes API Request
This rule leverages a combination of Defend for Containers and Kubernetes audit logs to detect the execution of forbidden
interactive Kubernetes API requests. An adversary may need to execute interactive Kubernetes API requests to gain access
to the Kubernetes API server or other resources within the cluster. These requests are often used to enumerate the
Kubernetes API server or other resources within the cluster, and may indicate an attempt to move laterally within the
cluster. Attackers may attempt to access resources that are forbidden by the authorization policy. Note that this rule may
not trigger if the authorization token of the request is expanded within the process argument list, as the length of the
"process.args" field may lead to the field being ignored.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Data Source: Kubernetes
- Domain: Container
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Discovery
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Forbidden Direct Interactive Kubernetes API Request

This rule correlates an interactive command execution inside a container with a Kubernetes API request that is explicitly forbidden, signaling hands-on-keyboard probing and unauthorized access attempts. It matters because attackers use live shells to enumerate cluster resources and test privileges for lateral movement or escalation. Example: after compromising a pod, an operator opens a shell and runs kubectl get secrets or curls the API server with the pod’s token, repeatedly receiving 403 Forbidden.

### Possible investigation steps

- Correlate the pod, container, namespace, node, and service account from the alert, then quickly pull the matching audit entries to see the verb, resource, requestURI, and userAgent for the forbidden calls.
- Determine whether the container image normally includes utilities like kubectl/curl/openssl or if they were dropped into the pod, and review recent file writes and package installs to differentiate admin debugging from hands-on-keyboard activity.
- Inspect the pod’s service account bindings and effective RBAC in the target namespace to confirm least privilege and understand why the request was denied, then check for other successful API requests from the same identity around the same timeframe.
- Review network connections from the pod to the API server (and any proxies) during the session to validate direct access paths, source IPs, and whether a mounted service account token from /var/run/secrets was used.
- Validate whether this was an authorized SRE/debug session by contacting the workload owner and checking for recent kubectl exec or ephemeral debug activity; if not expected, expand the search for similar forbidden attempts from other pods.


### False positive analysis

- An authorized kubectl exec or ephemeral debug session inside a pod where an engineer runs kubectl or curl to probe API resources and, because the pod’s service account is intentionally least‑privileged, the requests are forbidden as expected.
- Benign interactive troubleshooting that mistakenly uses the wrong namespace or queries cluster‑scoped endpoints from within the container (e.g., curl/openssl to the API server), causing the audit logs to show forbid decisions even though no malicious access was attempted.


### Response and remediation

- Immediately terminate the interactive shell (e.g., sh/bash) in the offending container and isolate the pod by applying a deny-egress NetworkPolicy in its namespace that blocks outbound connections to [https://kubernetes.default.svc](https://kubernetes.default.svc) and the API server IPs.
- Revoke and rotate credentials by deleting the pod and its ServiceAccount token Secret, temporarily setting automountServiceAccountToken: false on the workload, and redeploying with a new ServiceAccount after validating RBAC least privilege.
- Remove attacker tooling and persistence by rebuilding the container image to exclude kubectl/curl/openssl/socat/ncat, clearing writable volume mounts that contain dropped binaries or scripts, and redeploying from a trusted registry.
- Sweep for spread by identifying pods running the same image or on the same node and terminating any interactive processes issuing Kubernetes API requests from within containers, then restart those workloads cleanly.
- Escalate to incident response if you observe successful API operations (200/201) on secrets, configmaps, or RBAC objects, exec into other pods, or privileged container settings (privileged=true, hostNetwork, or hostPID), indicating lateral movement or credential compromise.
- Harden going forward by tightening RBAC on the new ServiceAccount, enforcing Gatekeeper/OPA policies to deny images that include kubectl/curl and block interactive shells, setting readOnlyRootFilesystem and dropping NET_ADMIN, and restricting API server access via egress controls.


## Rule Query

```eql
sequence with maxspan=1s
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
     process.name in ("wget", "curl", "openssl", "socat", "ncat", "kubectl") or
     (
       /* Account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
       process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
       process.args in (
         "wget", "/bin/wget", "/usr/bin/wget", "/usr/local/bin/wget",
         "ssl_client", "/bin/ssl_client", "/usr/bin/ssl_client", "/usr/local/bin/ssl_client",
         "curl", "/bin/curl", "/usr/bin/curl", "/usr/local/bin/curl",
         "openssl", "/bin/openssl", "/usr/bin/openssl", "/usr/local/bin/openssl",
         "socat", "/bin/socat", "/usr/bin/socat", "/usr/local/bin/socat",
         "ncat", "/bin/ncat", "/usr/bin/ncat", "/usr/local/bin/ncat",
         "kubectl", "/bin/kubectl", "/usr/bin/kubectl", "/usr/local/bin/kubectl"
       ) and
       /* default exclusion list to not FP on default multi-process commands */
       not process.args in (
         "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
         "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
         "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
         "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
       )
     )
   ) and process.interactive == true and container.id like "*"
  ] by orchestrator.resource.name
  [any where event.dataset == "kubernetes.audit_logs" and kubernetes.audit.stage in ("ResponseComplete", "ResponseStarted") and
  `kubernetes.audit.annotations.authorization_k8s_io/decision` == "forbid"
  ] by `kubernetes.audit.user.extra.authentication.kubernetes.io/pod-name` 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)