﻿---
title: Direct Interactive Kubernetes API Request by Common Utilities
description: This rule leverages a combination of Defend for Containers and Kubernetes audit logs to detect the execution of direct interactive Kubernetes API requests...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_d4c_k8s_mda_direct_interactive_kubernetes_api_request_by_usual_utilities
products:
  - Elastic Security
---

# Direct Interactive Kubernetes API Request by Common Utilities
This rule leverages a combination of Defend for Containers and Kubernetes audit logs to detect the execution of direct
interactive Kubernetes API requests. An adversary may need to execute direct interactive Kubernetes API requests to gain
access to the Kubernetes API server or other resources within the cluster. These requests are often used to enumerate
the Kubernetes API server or other resources within the cluster, and may indicate an attempt to move laterally within
the cluster. Note that this rule may not trigger if the authorization token of the request is expanded within the process
argument list, as the length of the "process.args" field may lead to the field being ignored.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*
- logs-kubernetes.audit_logs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Data Source: Kubernetes
- Domain: Container
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Discovery
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Direct Interactive Kubernetes API Request by Common Utilities

This detection links an interactive invocation of common networking utilities or kubectl inside a container to a near-simultaneous Kubernetes API response, indicating hands-on-keyboard access to the API server for discovery or lateral movement. A common attacker pattern is compromising a pod, reading its mounted service account token, then running curl or kubectl interactively to query /api or /apis endpoints to list pods and secrets and map cluster scope.

### Possible investigation steps

- From Kubernetes audit logs linked to the pod, capture the authenticated principal, namespace, verbs, and request URIs to determine whether the activity focused on discovery or sensitive resources like secrets or RBAC objects.
- Correlate the interactive container activity with kubelet exec/attach or terminal session telemetry to identify who initiated the session and through which source IP or control-plane endpoint.
- Inspect the pod’s service account by validating access to the mounted token path and enumerating its RoleBindings and ClusterRoleBindings to quantify effective privileges and decide on immediate revocation or rotation.
- Review the container image provenance and available shell history or command logs to confirm use of networking utilities or kubectl and identify any reads of secrets, kubeconfig files, or /api and /apis endpoints.
- Expand the time window to find prior or subsequent API calls from the same pod, namespace, or node, and quarantine or cordon the workload if you observe sustained enumeration or cross-namespace access.


### False positive analysis

- An operator uses kubectl exec -it to enter a pod and runs kubectl or curl to list resources or verify RBAC, producing interactive process starts and near-simultaneous Kubernetes audit responses that are expected during troubleshooting.
- During routine connectivity or certificate checks, an engineer attaches to a container that includes curl/openssl/socat/ncat and interactively tests the Kubernetes API server endpoint, generating correlated audit events without malicious intent.


### Response and remediation

- Immediately isolate the implicated pod by terminating the interactive shell and curl/kubectl processes, applying a deny-all NetworkPolicy in its namespace, and temporarily blocking pod egress to the kube-apiserver address.
- Revoke and rotate the service account credentials used by the pod, invalidate the token at /var/run/secrets/kubernetes.io/serviceaccount/token, and remove excess RoleBindings or ClusterRoleBindings tied to that identity.
- Delete and restore the workload from a trusted image that excludes curl/wget/openssl/socat/ncat, with automountServiceAccountToken disabled and least-privilege RBAC enforced.
- Escalate to incident response if the pod read Secrets or ConfigMaps, modified RBAC objects, attempted create/patch/delete on cluster-scoped resources, or originated from an unapproved operator workstation or bastion.
- Harden by restricting kubectl exec/attach to a small admin group with MFA, enabling admission controls (Pod Security Admission, Gatekeeper, or Kyverno) to block shells or kubectl/netcat in images, and applying egress NetworkPolicies so only approved namespaces can reach [https://kubernetes.default.svc](https://kubernetes.default.svc).


## Rule Query

```eql
sequence with maxspan=1s
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
     process.name in ("wget", "curl", "openssl", "socat", "ncat", "kubectl") or
     (
       /* Account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
       process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
       process.args in (
         "wget", "/bin/wget", "/usr/bin/wget", "/usr/local/bin/wget",
         "ssl_client", "/bin/ssl_client", "/usr/bin/ssl_client", "/usr/local/bin/ssl_client",
         "curl", "/bin/curl", "/usr/bin/curl", "/usr/local/bin/curl",
         "openssl", "/bin/openssl", "/usr/bin/openssl", "/usr/local/bin/openssl",
         "socat", "/bin/socat", "/usr/bin/socat", "/usr/local/bin/socat",
         "ncat", "/bin/ncat", "/usr/bin/ncat", "/usr/local/bin/ncat",
         "kubectl", "/bin/kubectl", "/usr/bin/kubectl", "/usr/local/bin/kubectl"
       ) and
       /* default exclusion list to not FP on default multi-process commands */
       not process.args in (
         "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
         "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
         "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
         "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
       )
     )
   ) and process.interactive == true and container.id like "*"
  ] by orchestrator.resource.name
  [any where event.dataset == "kubernetes.audit_logs" and kubernetes.audit.stage in ("ResponseComplete", "ResponseStarted")] by `kubernetes.audit.user.extra.authentication.kubernetes.io/pod-name` 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)