﻿---
title: Security Software Discovery via Grep
description: Identifies the use of the grep command to discover known third-party macOS and Linux security tools, such as Antivirus or Host Firewall details. Rule...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/discovery_security_software_grep
products:
  - Elastic Security
---

# Security Software Discovery via Grep
Identifies the use of the grep command to discover known third-party macOS and Linux security tools, such as Antivirus
or Host Firewall details.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*
- auditbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: macOS
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Resources: Investigation Guide
- Data Source: Elastic Defend

**Version**: 113
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

If enabling an EQL rule on a non-elastic-agent index (such as beats) for versions <8.2,
events will not define `event.ingested` and default fallback for EQL rules was not added until version 8.2.
Hence for this rule to work effectively, users will need to add a custom ingest pipeline to populate
`event.ingested` to @timestamp.
For more details on adding a custom ingest pipeline refer - [https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html](https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html)

## Investigation guide


## Triage and analysis


### Investigating Security Software Discovery via Grep

After successfully compromising an environment, attackers may try to gain situational awareness to plan their next steps. This can happen by running commands to enumerate network resources, users, connections, files, and installed security software.
This rule looks for the execution of the `grep` utility with arguments compatible to the enumeration of the security software installed on the host. Attackers can use this information to decide whether or not to infect a system, disable protections, use bypasses, etc.

#### Possible investigation steps

- Investigate the process execution chain (parent process tree) for unknown processes. Examine their executable files for prevalence and whether they are located in expected locations.
- Investigate other alerts associated with the user/host during the past 48 hours.
- Investigate any abnormal account behavior, such as command executions, file creations or modifications, and network connections.
- Investigate any abnormal behavior by the subject process such as network connections, file modifications, and any spawned child processes.
- Inspect the host for suspicious or abnormal behavior in the alert timeframe.
- Validate the activity is not related to planned patches, updates, network administrator activity, or legitimate software installations.


### False positive analysis

- Discovery activities are not inherently malicious if they occur in isolation. As long as the analyst did not identify suspicious activity related to the user or host, such alerts can be dismissed.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved hosts to prevent further post-compromise behavior.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection via the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```eql
process where event.type == "start" and
process.name : ("grep", "egrep", "pgrep") and user.id != "0" and
 not process.parent.executable : ("/Library/Application Support/*", "/opt/McAfee/agent/scripts/ma") and
   process.args :
         ("Little Snitch*",
          "Avast*",
          "Avira*",
          "ESET*",
          "BlockBlock*",
          "360Sec*",
          "LuLu*",
          "KnockKnock*",
          "kav",
          "KIS",
          "RTProtectionDaemon*",
          "Malware*",
          "VShieldScanner*",
          "WebProtection*",
          "webinspectord*",
          "McAfee*",
          "isecespd*",
          "macmnsvc*",
          "masvc*",
          "kesl*",
          "avscan*",
          "guard*",
          "rtvscand*",
          "symcfgd*",
          "scmdaemon*",
          "symantec*",
          "sophos*",
          "osquery*",
          "elastic-endpoint*",
          "falcond*",
          "SentinelOne*",
          "CbOsxSensorService*",
          "CbDefense*",
          "WhatsYourSign*",
          "reikey*",
          "OverSight*",
          "KextViewr*",
          "Netiquette*",
          "processmonitor*",
          "filemonitor*"
          ) and
   not (
     (process.args : "Avast" and process.args : "Passwords") or
     (process.args == "osquery.conf") or 
     (process.parent.args : "/opt/McAfee/agent/scripts/ma" and process.parent.args : "checkhealth") or
     (process.command_line : (
       "grep ESET Command-line scanner, version %s -A2",
       "grep -i McAfee Web Gateway Core version:",
       "grep --color=auto ESET Command-line scanner, version %s -A2"
       )
     ) or
     (process.parent.command_line : (
       """sh -c printf "command_start_%s"*; perl -pe 's/[^ -~]/\n/g' < /opt/eset/esets/sbin/esets_scan | grep 'ESET Command-line scanner, version %s' -A2 | tail -1; printf "command_done_%s*""",
       """bash -c perl -pe 's/[^ -~]/\n/g' < /opt/eset/esets/sbin/esets_scan | grep 'ESET Command-line scanner, version %s' -A2 | tail -1"""
       )
     )
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Software Discovery
- Id: T1518
- Reference URL: [[https://attack.mitre.org/techniques/T1518/](https://attack.mitre.org/techniques/T1518/)](https://attack.mitre.org/techniques/T1518/)
- Sub Technique:
  - Name: Security Software Discovery
- Id: T1518.001
- Reference URL: [[https://attack.mitre.org/techniques/T1518/001/](https://attack.mitre.org/techniques/T1518/001/)](https://attack.mitre.org/techniques/T1518/001/)