﻿---
title: GenAI Process Compiling or Generating Executables
description: Detects when GenAI tools spawn compilers or packaging tools to generate executables. Attackers leverage local LLMs to autonomously generate and compile...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_genai_process_compiling_executables
products:
  - Elastic Security
---

# GenAI Process Compiling or Generating Executables
Detects when GenAI tools spawn compilers or packaging tools to generate executables. Attackers leverage local LLMs to
autonomously generate and compile malware, droppers, or implants. Python packaging tools (pyinstaller, nuitka, pyarmor)
are particularly high-risk as they create standalone executables that can be deployed without dependencies. This rule
focuses on compilation activity that produces output binaries, filtering out inspection-only operations.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*
- logs-windows.sysmon_operational-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-auditd_manager.auditd-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://atlas.mitre.org/techniques/AML.T0053](https://atlas.mitre.org/techniques/AML.T0053)](https://atlas.mitre.org/techniques/AML.T0053)
- [[https://www.elastic.co/security-labs/elastic-advances-llm-security](https://www.elastic.co/security-labs/elastic-advances-llm-security)](https://www.elastic.co/security-labs/elastic-advances-llm-security)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: macOS
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: Auditd Manager
- Data Source: Microsoft Defender for Endpoint
- Data Source: SentinelOne
- Resources: Investigation Guide
- Domain: LLM
- Mitre Atlas: T0053

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating GenAI Process Compiling or Generating Executables

This rule detects GenAI tools spawning compilers or packaging tools. While developers may use GenAI to write code that they then compile, autonomous compilation by GenAI processes is unusual.

### Possible investigation steps

- Review the GenAI process that spawned the compiler to identify which tool is running and verify if it's an expected/authorized tool.
- Investigate the user account associated with the GenAI process to determine if this activity is expected for that user.
- Review the output files created by the compilation process to identify any malicious executables.
- Check for other alerts or suspicious activity on the same host around the same time.
- Verify if the GenAI tool is from a trusted source and if it's authorized for use in your environment.
- Identify whether the generated executables appear in temporary directories often used for malware staging (`%TEMP%`, `/tmp`, `.cache`).
- Inspect the compiled artifacts for networking imports, credential harvesting functionality, or persistence mechanisms.


### False positive analysis

- Legitimate development workflows that use GenAI tools for code generation may trigger this rule if they compile the generated code.
- Some GenAI-assisted coding IDEs (Cursor, Copilot Workspace) may run compilation tasks when testing code; confirm whether the behavior is tied to developer workflow.


### Response and remediation

- Terminate the GenAI process and any spawned compiler processes to stop the malicious activity.
- Investigate the compiled executables to determine if they are malicious.
- Review audit logs to determine the scope of compilation activity and identify any executables that may have been created.
- Quarantine any compiled binaries; submit suspicious artifacts to sandbox or malware analysis.


## Rule Query

```eql
process where event.type == "start" and

  // GenAI parent process
  (
    process.parent.name in (
      "ollama.exe", "ollama", "Ollama",
      "textgen.exe", "textgen", "text-generation-webui.exe", "oobabooga.exe",
      "lmstudio.exe", "lmstudio", "LM Studio",
      "claude.exe", "claude", "Claude",
      "cursor.exe", "cursor", "Cursor", "Cursor Helper", "Cursor Helper (Plugin)",
      "copilot.exe", "copilot", "Copilot",
      "codex.exe", "codex",
      "Jan", "jan.exe", "jan", "Jan Helper",
      "gpt4all.exe", "gpt4all", "GPT4All",
      "gemini-cli.exe", "gemini-cli",
      "genaiscript.exe", "genaiscript",
      "grok.exe", "grok",
      "qwen.exe", "qwen",
      "koboldcpp.exe", "koboldcpp", "KoboldCpp",
      "llama-server", "llama-cli"
    ) or
    
    // Node/Deno with GenAI frameworks
    (process.parent.name in ("node.exe", "node", "deno.exe", "deno") and
     process.parent.command_line like~ ("*mcp-server*", "*@modelcontextprotocol*", "*langchain*", "*autogpt*", "*babyagi*", "*agentgpt*", "*crewai*", "*semantic-kernel*", "*llama-index*", "*haystack*")) or
    
    // Python with GenAI frameworks
    (process.parent.name like~ "python*" and
     process.parent.command_line like~ ("*langchain*", "*autogpt*", "*babyagi*", "*agentgpt*", "*crewai*", "*semantic-kernel*", "*llama-index*", "*haystack*"))
  ) and

  // Compilation tools
  (
    // Python packaging
    process.name in ("pyinstaller", "py2exe", "cx_Freeze", "nuitka", "pyarmor", "pkg") or
    
    // C/C++ compilation with output
    (process.name in ("gcc", "g++", "clang", "clang++", "cl.exe") and
     process.command_line like~ "*-o *" and
     process.command_line like~ ("*.c *", "*.c", "*.cpp *", "*.cpp", "*.cc *", "*.cc", "*.m *", "*.m") and
     not process.command_line like~ "*git*") or
    
    // Go compilation
    (process.name == "go" and process.args == "build") or
    
    // Rust compilation
    (process.name == "cargo" and process.args == "build") or
    (process.name == "rustc" and process.command_line like~ "*-o *") or
    
    // .NET compilation
    process.name in ("csc.exe", "vbc.exe", "msbuild.exe") or
    (process.name == "dotnet" and process.args == "build") or
    
    // Java compilation
    process.name == "javac"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Obfuscated Files or Information
- Id: T1027
- Reference URL: [[https://attack.mitre.org/techniques/T1027/](https://attack.mitre.org/techniques/T1027/)](https://attack.mitre.org/techniques/T1027/)
- Sub Technique:
  - Name: Compile After Delivery
- Id: T1027.004
- Reference URL: [[https://attack.mitre.org/techniques/T1027/004/](https://attack.mitre.org/techniques/T1027/004/)](https://attack.mitre.org/techniques/T1027/004/)