﻿---
title: Unusual Process Modifying GenAI Configuration File
description: Detects unusual modification of GenAI tool configuration files. Adversaries may inject malicious MCP server configurations to hijack AI agents for persistence,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_genai_config_modification
products:
  - Elastic Security
---

# Unusual Process Modifying GenAI Configuration File
Detects unusual modification of GenAI tool configuration files. Adversaries may inject malicious MCP server
configurations to hijack AI agents for persistence, C2, or data exfiltration. Attack vectors include malware or scripts
directly poisoning config files, supply chain attacks via compromised dependencies, and prompt injection attacks that
abuse the GenAI tool itself to modify its own configuration. Unauthorized MCP servers added to these configs execute
arbitrary commands when the AI tool is next invoked.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.file*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://modelcontextprotocol.io/](https://modelcontextprotocol.io/)](https://modelcontextprotocol.io/)
- [[https://www.cybereason.com/blog/security-research/weaponized-ai-how-cybercriminals-exploit-mcp-for-account-takeover](https://www.cybereason.com/blog/security-research/weaponized-ai-how-cybercriminals-exploit-mcp-for-account-takeover)](https://www.cybereason.com/blog/security-research/weaponized-ai-how-cybercriminals-exploit-mcp-for-account-takeover)
- [[https://glama.ai/blog/2025-11-11-the-lethal-trifecta-securing-model-context-protocol-against-data-flow-attacks](https://glama.ai/blog/2025-11-11-the-lethal-trifecta-securing-model-context-protocol-against-data-flow-attacks)](https://glama.ai/blog/2025-11-11-the-lethal-trifecta-securing-model-context-protocol-against-data-flow-attacks)
- [[https://www.elastic.co/security-labs/elastic-advances-llm-security](https://www.elastic.co/security-labs/elastic-advances-llm-security)](https://www.elastic.co/security-labs/elastic-advances-llm-security)

**Tags**:
- Domain: Endpoint
- OS: macOS
- OS: Windows
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Persistence
- Data Source: Elastic Defend
- Resources: Investigation Guide
- Domain: LLM

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Unusual Process Modifying GenAI Configuration File

Configuration files for GenAI tools like Cursor, Claude, Copilot, and Ollama control which MCP servers, plugins, and extensions are loaded. Attackers target these files to inject malicious MCP servers that execute arbitrary commands, exfiltrate data, or establish persistence. Threats include external processes (malware, compromised scripts, supply chain attacks) directly modifying configs, as well as prompt injection attacks that abuse the AI tool's own file access capabilities.

### Possible investigation steps

- Identify the process that modified the configuration file and determine if it's expected (GenAI tool, installer, user action) or suspicious (unknown script, malware).
- If the modifying process is NOT a GenAI tool, investigate its origin, parent process tree, and whether it was downloaded or executed from a suspicious location.
- If a GenAI tool made the modification, check recent user prompts or agent activity that may have triggered the config change via prompt injection.
- Review the contents of the modified configuration file for suspicious MCP server URLs, unauthorized plugins, or unusual agent permissions.
- Examine the process command line and parent process tree to identify how the modifying process was invoked.
- Check for other file modifications by the same process around the same time, particularly to other GenAI configs or startup scripts.
- Investigate whether the GenAI tool subsequently connected to unknown domains or spawned unusual child processes after the config change.


### False positive analysis

- Novel but legitimate configuration changes will trigger this rule when the process hasn't been seen modifying these files within the configured history window. Review the modified file content to determine legitimacy.
- GenAI tool updates may modify config files in new ways; correlate with recent software updates.
- IDE extensions integrating with GenAI tools may modify configs as part of initial setup.
- Developer tools (git, go, npm) checking out or downloading projects containing `.gemini/` or `.claude/` directories may trigger alerts. These are project-level configs, not user configs - verify by checking if the path is within a project directory.


### Response and remediation

- Review the modified configuration file and revert any unauthorized changes to MCP servers, plugins, or agent settings.
- If malicious MCP servers were added, block the associated domains at the network level.
- Review and rotate any API keys or credentials that may have been exposed through the compromised GenAI configuration.


## Rule Query

```kuery
event.category : "file" and event.action : ("modification" or "overwrite") and
file.path : (
    */.cursor/mcp.json or */.cursor/settings.json or */AppData/Roaming/Cursor/*mcp* or
    */.claude/* or */claude_desktop_config.json or */AppData/Roaming/Claude/* or
    */.config/github-copilot/* or */AppData/Local/GitHub?Copilot/* or
    */.ollama/config* or */AppData/Local/Ollama/* or
    */.codex/* or */AppData/Roaming/Codex/* or
    */.gemini/* or */AppData/Roaming/gemini-cli/* or
    */.grok/* or */AppData/Roaming/Grok/* or
    */.windsurf/* or */AppData/Roaming/Windsurf/* or
    */.vscode/extensions/*mcp* or
    */.openclaw/* or */AppData/Roaming/OpenClaw/* or
    */.moltbot/* or */AppData/Roaming/Moltbot/* or
    */.config/openclaw/*
) and not (
  file.extension : (lck or lock) or
  (
    file.path : */.config/github-copilot/* and 
    file.name : (apps.json or versions.json or copilot*nitrite.db)
    
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Modify Authentication Process
- Id: T1556
- Reference URL: [[https://attack.mitre.org/techniques/T1556/](https://attack.mitre.org/techniques/T1556/)](https://attack.mitre.org/techniques/T1556/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Compromise Host Software Binary
- Id: T1554
- Reference URL: [[https://attack.mitre.org/techniques/T1554/](https://attack.mitre.org/techniques/T1554/)](https://attack.mitre.org/techniques/T1554/)