﻿---
title: Agent Spoofing - Multiple Hosts Using Same Agent
description: Detects when multiple hosts are using the same agent ID. This could occur in the event of an agent being taken over and used to inject illegitimate documents...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_agent_spoofing_multiple_hosts
products:
  - Elastic Security
---

# Agent Spoofing - Multiple Hosts Using Same Agent
Detects when multiple hosts are using the same agent ID. This could occur in the event of an agent being taken over and
used to inject illegitimate documents into an instance as an attempt to spoof events in order to masquerade actual
activity to evade detection.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 105
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Agent Spoofing - Multiple Hosts Using Same Agent

In network environments, agents are deployed on hosts to monitor and report activities. Adversaries may exploit these agents by hijacking their IDs to inject false data, masking malicious actions. The detection rule identifies anomalies where multiple hosts report using the same agent ID, signaling potential spoofing attempts. By focusing on unique agent ID usage, it helps uncover evasion tactics aimed at concealing unauthorized activities.

### Possible investigation steps

- Review the alert details to identify the specific agent ID that is being reported by multiple hosts.
- Cross-reference the agent ID with the list of known and authorized agents to determine if it has been compromised or misconfigured.
- Examine the network logs and host activity for each host reporting the same agent ID to identify any unusual or unauthorized activities.
- Check for any recent changes or updates to the agent software on the affected hosts that could explain the anomaly.
- Investigate the timeline of events to determine when the agent ID started being used by multiple hosts and correlate this with any known incidents or changes in the network environment.
- Assess the potential impact of the spoofing attempt on the network's security posture and consider isolating affected hosts if necessary to prevent further malicious activity.


### False positive analysis

- Legitimate load balancing or failover scenarios where multiple hosts are configured to use the same agent ID for redundancy can trigger false positives. Users should identify and document these configurations, then create exceptions in the detection rule to exclude these known non-threatening behaviors.
- Virtualized environments where snapshots or clones of a host are created might result in multiple instances reporting the same agent ID. Users should ensure that each virtual instance is assigned a unique agent ID or adjust the rule to account for these scenarios.
- Testing or development environments where agents are intentionally duplicated for testing purposes can also lead to false positives. Users should tag these environments appropriately and modify the rule to exclude events from these tags.
- In cases where agents are temporarily reassigned to different hosts for maintenance or troubleshooting, users should maintain a log of these activities and adjust the detection rule to ignore these temporary changes.


### Response and remediation

- Isolate affected hosts immediately to prevent further spread of potentially malicious activities across the network.
- Revoke and reissue new agent IDs for the affected hosts to ensure that compromised IDs are no longer in use.
- Conduct a thorough forensic analysis on the isolated hosts to identify any unauthorized changes or malicious software that may have been introduced.
- Review and update access controls and authentication mechanisms for agent deployment to prevent unauthorized access and hijacking of agent IDs.
- Monitor network traffic and logs closely for any signs of continued spoofing attempts or related suspicious activities.
- Escalate the incident to the security operations center (SOC) and relevant stakeholders to ensure awareness and coordinated response efforts.
- Implement enhanced logging and alerting for agent ID anomalies to improve detection of similar threats in the future.


## Rule Query

```esql
from logs-endpoint.*  metadata _id
| where event.agent_id_status is not null and agent.id is not null
| stats Esql.count_distinct_host_ids = count_distinct(host.id), Esql.host_id_values = values(host.id), Esql.user_id_values_user_id = values(user.id) by agent.id
| where Esql.count_distinct_host_ids >= 2
| keep Esql.count_distinct_host_ids, Esql.host_id_values, Esql.user_id_values_user_id, agent.id
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)