﻿---
title: Credential Access via TruffleHog Execution
description: This rule detects the execution of TruffleHog, a tool used to search for high-entropy strings and secrets in code repositories, which may indicate an...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/credential_access_trufflehog_execution
products:
  - Elastic Security
---

# Credential Access via TruffleHog Execution
This rule detects the execution of TruffleHog, a tool used to search for high-entropy strings and secrets
in code repositories, which may indicate an attempt to access credentials. This tool was abused by the Shai-Hulud
worm to search for credentials in code repositories.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.forwarded*
- logs-windows.sysmon_operational-*
- winlogbeat-*
- auditbeat-*
- logs-auditd_manager.auditd-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/blog/shai-hulud-worm-npm-supply-chain-compromise](https://www.elastic.co/blog/shai-hulud-worm-npm-supply-chain-compromise)](https://www.elastic.co/blog/shai-hulud-worm-npm-supply-chain-compromise)
- [[https://socket.dev/blog/shai-hulud-strikes-again-v2](https://socket.dev/blog/shai-hulud-strikes-again-v2)](https://socket.dev/blog/shai-hulud-strikes-again-v2)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: Windows
- OS: macOS
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Windows Security Event Logs
- Data Source: Microsoft Defender for Endpoint
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Data Source: Auditd Manager
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Credential Access via TruffleHog Execution

This rule flags TruffleHog executed to scan the local filesystem with verified JSON results, a direct path to harvesting secrets from source code, configs, and build artifacts. Attackers gain shell access on a developer workstation or CI runner, clone or point to internal repositories, run 'trufflehog --results=verified --json filesystem .' to enumerate valid tokens, and then pivot using the recovered keys to pull private code or authenticate to cloud and CI/CD systems.

### Possible investigation steps

- Review binary path, code signature/hash, parent process chain, initiating user, and host role (developer workstation vs CI runner) to quickly decide if the execution matches an approved secret-scanning job or an ad‑hoc run.
- Determine the working directory and target path used by the scan to identify which repositories or configuration directories were inspected and whether sensitive files (e.g., .env, deployment keys, build secrets) were in scope.
- Pivot to same-session activity to spot credential use or exfiltration by correlating subsequent outbound connections to git remotes or cloud/CI APIs and launches of developer CLIs like git, gh, aws, az, gcloud, docker, kubectl, or vault.
- Look for output artifacts and exfil channels by checking for creation or deletion of JSON reports or archives, clipboard access, or piping of results to curl/wget/netcat and whether those artifacts were emailed or uploaded externally.
- Cross-check VCS and CI/CD audit logs for this identity and host for unusual pushes, pipeline changes, or new tokens issued shortly after the scan, which may indicate worm-like propagation or credential abuse.


### False positive analysis

- An approved secret-scanning task by a developer or security engineer runs trufflehog with --results=verified --json filesystem to audit local code and configuration, producing benign activity on a development host.
- An internal automation or scheduled job invokes trufflehog to baseline filesystem secrets for compliance or hygiene checks, leading to expected process-start logs without credential abuse.


### Response and remediation

- Immediately isolate the host or CI runner, terminate the trufflehog process and its parent shell/script, and block egress to git remotes and cloud APIs from that asset.
- Collect the verified findings from trufflehog output (stdout or JSON file), revoke and rotate any listed secrets (GitHub personal access tokens, AWS access keys, Azure service principal credentials, CI job tokens), and clear credential caches on the host.
- Remove unauthorized trufflehog binaries/packages, helper scripts, and scheduled tasks; delete report files and scanned working directories (local repo clones, .env/config folders), and purge shell history containing exfil commands like curl/wget/netcat.
- Restore the workstation or runner from a known-good image if tampering is suspected, re-enroll endpoint protection, reissue required developer or CI credentials with least privilege, and validate normal pulls to internal git and cloud services.
- Escalate to full incident response if trufflehog ran under a service account, on a build server/CI runner, or if any discovered secret was used to authenticate to external git remotes (e.g., github.com), cloud APIs, or private registries in the same session.
- Harden by blocking unapproved trufflehog execution via application control, moving approved secret scanning to a locked-down pipeline, enforcing short-lived PATs and key rotation, enabling egress filtering from developer hosts/runners, and deploying fleet-wide detections for "trufflehog --results=verified --json filesystem".


## Rule Query

```eql
process where event.type == "start" and process.name : ("trufflehog.exe", "trufflehog") and
process.args == "--json" and process.args == "filesystem"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Technique:
  - Name: Credentials from Password Stores
- Id: T1555
- Reference URL: [[https://attack.mitre.org/techniques/T1555/](https://attack.mitre.org/techniques/T1555/)](https://attack.mitre.org/techniques/T1555/)