﻿---
title: GenAI Process Accessing Sensitive Files
description: Detects when GenAI tools access sensitive files such as cloud credentials, SSH keys, browser password databases, or shell configurations. Attackers leverage...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/credential_access_genai_process_sensitive_file_access
products:
  - Elastic Security
---

# GenAI Process Accessing Sensitive Files
Detects when GenAI tools access sensitive files such as cloud credentials, SSH keys, browser password databases, or
shell configurations. Attackers leverage GenAI agents to systematically locate and exfiltrate credentials, API keys, and
tokens. Access to credential stores (.aws/credentials, .ssh/id_*) suggests harvesting, while writes to shell configs
(.bashrc, .zshrc) indicate persistence attempts. Note: On linux only creation events are available. Access events are not yet implemented.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://atlas.mitre.org/techniques/AML.T0085](https://atlas.mitre.org/techniques/AML.T0085)](https://atlas.mitre.org/techniques/AML.T0085)
- [[https://atlas.mitre.org/techniques/AML.T0085.001](https://atlas.mitre.org/techniques/AML.T0085.001)](https://atlas.mitre.org/techniques/AML.T0085.001)
- [[https://atlas.mitre.org/techniques/AML.T0055](https://atlas.mitre.org/techniques/AML.T0055)](https://atlas.mitre.org/techniques/AML.T0055)
- [[https://glama.ai/blog/2025-11-11-the-lethal-trifecta-securing-model-context-protocol-against-data-flow-attacks](https://glama.ai/blog/2025-11-11-the-lethal-trifecta-securing-model-context-protocol-against-data-flow-attacks)](https://glama.ai/blog/2025-11-11-the-lethal-trifecta-securing-model-context-protocol-against-data-flow-attacks)
- [[https://www.elastic.co/security-labs/elastic-advances-llm-security](https://www.elastic.co/security-labs/elastic-advances-llm-security)](https://www.elastic.co/security-labs/elastic-advances-llm-security)
- [[https://specterops.io/blog/2025/11/21/an-evening-with-claude-code](https://specterops.io/blog/2025/11/21/an-evening-with-claude-code)](https://specterops.io/blog/2025/11/21/an-evening-with-claude-code)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: macOS
- OS: Windows
- Use Case: Threat Detection
- Tactic: Collection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Resources: Investigation Guide
- Domain: LLM
- Mitre Atlas: T0085
- Mitre Atlas: T0085.001
- Mitre Atlas: T0055

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating GenAI Process Accessing Sensitive Files

This rule detects GenAI tools accessing credential files, SSH keys, browser data, or shell configurations. While GenAI tools legitimately access project files, access to sensitive credential stores is unusual and warrants investigation.

### Possible investigation steps

- Review the GenAI process that triggered the alert to identify which tool is being used and verify if it's an expected/authorized tool.
- Investigate the user account associated with the GenAI process to determine if this activity is expected for that user.
- Review the types of sensitive files being accessed (credentials, keys, browser data, etc.) to assess the potential impact of credential harvesting or data exfiltration.
- Check for other alerts or suspicious activity on the same host around the same time, particularly network exfiltration events.
- Verify if the GenAI tool or extension is from a trusted source and if it's authorized for use in your environment.
- Determine if the GenAI process accessed multiple sensitive directories in sequence, an indication of credential harvesting.
- Check if the GenAI tool recently created or accessed AI agent config files, which may contain instructions enabling autonomous file scanning.
- Review whether the access was preceded by an MCP server, LangChain agent, or background automation.


### False positive analysis

- Automated security scanning or auditing tools that leverage GenAI may access sensitive files as part of their normal operation.
- Development workflows that use GenAI tools for code analysis may occasionally access credential files.


### Response and remediation

- Immediately review the GenAI process that accessed the documents to determine if it's compromised or malicious.
- Review, rotate, and revoke any API keys, tokens, or credentials that may have been exposed or used by the GenAI tool.
- Investigate the document access patterns to determine the scope of potential data exfiltration.
- Update security policies to restrict or monitor GenAI tool usage in the environment, especially for access to sensitive files.


## Rule Query

```eql
file where event.action in ("open", "creation", "modification") and event.outcome == "success" and

  // GenAI process 
    (
      process.name in (
        "ollama.exe", "ollama", "Ollama",
        "textgen.exe", "textgen", "text-generation-webui.exe", "oobabooga.exe",
        "lmstudio.exe", "lmstudio", "LM Studio",
        "claude.exe", "claude", "Claude",
        "cursor.exe", "cursor", "Cursor",
        "copilot.exe", "copilot", "Copilot",
        "codex.exe", "codex",
        "Jan", "jan.exe", "jan",
        "gpt4all.exe", "gpt4all", "GPT4All",
        "gemini-cli.exe", "gemini-cli",
        "genaiscript.exe", "genaiscript",
        "grok.exe", "grok",
        "qwen.exe", "qwen",
        "koboldcpp.exe", "koboldcpp", "KoboldCpp",
        "llama-server", "llama-cli"
      ) or
      // OpenClaw/Moltbot/Clawdbot via Node.js
      (process.name in ("node", "node.exe") and
       process.command_line like~ ("*openclaw*", "*moltbot*", "*clawdbot*"))
    ) and

  // Sensitive file paths
  (
    // Persistence via Shell configs
    file.name in (".bashrc", ".bash_profile", ".zshrc", ".zshenv", ".zprofile", ".profile", ".bash_logout") or

    // Credentials In Files 
    file.name like~ 
                 ("key?.db", 
                  "logins.json", 
                  "Login Data", 
                  "Local State",
                  "signons.sqlite",
                  "Cookies", 
                  "cookies.sqlite",
                  "Cookies.binarycookies", 
                  "login.keychain-db", 
                  "System.keychain", 
                  "credentials.db", 
                  "credentials", 
                  "access_tokens.db", 
                  "accessTokens.json", 
                  "azureProfile.json",
                  "RDCMan.settings", 
                  "known_hosts", 
                  "KeePass.config.xml", 
                  "Unattended.xml")
  ) and not (
    host.os.type == "windows" and
    process.name : ("claude.exe", "Claude") and
    file.path : "?:\\Users\\*\\AppData\\Roaming\\Claude\\Local State"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Credentials from Password Stores
- Id: T1555
- Reference URL: [[https://attack.mitre.org/techniques/T1555/](https://attack.mitre.org/techniques/T1555/)](https://attack.mitre.org/techniques/T1555/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Data from Local System
- Id: T1005
- Reference URL: [[https://attack.mitre.org/techniques/T1005/](https://attack.mitre.org/techniques/T1005/)](https://attack.mitre.org/techniques/T1005/)