﻿---
title: Active Directory Forced Authentication from Linux Host - SMB Named Pipes
description: Identifies a potential forced authentication using related SMB named pipes. Attackers may attempt to force targets to authenticate to a host controlled...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/credential_access_forced_authentication_pipes
products:
  - Elastic Security
---

# Active Directory Forced Authentication from Linux Host - SMB Named Pipes
Identifies a potential forced authentication using related SMB named pipes. Attackers may attempt to force targets to
authenticate to a host controlled by them to capture hashes or enable relay attacks.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*
- logs-system.security*
- winlogbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/p0dalirius/windows-coerced-authentication-methods](https://github.com/p0dalirius/windows-coerced-authentication-methods)](https://github.com/p0dalirius/windows-coerced-authentication-methods)
- [[https://www.thehacker.recipes/a-d/movement/mitm-and-coerced-authentications](https://www.thehacker.recipes/a-d/movement/mitm-and-coerced-authentications)](https://www.thehacker.recipes/a-d/movement/mitm-and-coerced-authentications)
- [[https://attack.mitre.org/techniques/T1187/](https://attack.mitre.org/techniques/T1187/)](https://attack.mitre.org/techniques/T1187/)

**Tags**:
- Domain: Endpoint
- OS: Windows
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Data Source: Active Directory
- Use Case: Active Directory Monitoring
- Data Source: Windows Security Event Logs
- Resources: Investigation Guide

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule uses Elastic Endpoint network events from Linux hosts and system integration events from Domain controllers
for correlation. Both data sources should be collected from the hosts for this detection to work.
The 'Audit Detailed File Share' audit policy must be configured (Success Failure).
Steps to implement the logging policy with Advanced Audit Configuration:
```
Computer Configuration >
Policies >
Windows Settings >
Security Settings >
Advanced Audit Policies Configuration >
Audit Policies >
Object Access >
Audit Detailed File Share (Success,Failure)
```


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Active Directory Forced Authentication from Linux Host - SMB Named Pipes

Active Directory (AD) and SMB named pipes facilitate network resource access and inter-process communication. Adversaries exploit these by forcing authentication from a Linux host to capture credentials or perform relay attacks. The detection rule identifies suspicious SMB connection attempts from Linux to Windows hosts, focusing on specific named pipes indicative of forced authentication attempts, thus highlighting potential credential access threats.

### Possible investigation steps

- Review the network logs to identify the Linux host IP address that attempted the SMB connection on port 445 and verify if this activity is expected or authorized.
- Check the Windows host logs for event code 5145 to determine which named pipes were accessed and assess if these accesses align with normal operations or indicate suspicious activity.
- Investigate the source IP address from the Windows logs to determine if it matches the Linux host IP and evaluate if this connection is part of a known and legitimate process.
- Analyze historical data for any previous similar connection attempts from the same Linux host to identify patterns or repeated unauthorized access attempts.
- Consult with system administrators to confirm if there have been any recent changes or updates in the network configuration that could explain the connection attempts.


### False positive analysis

- Routine administrative tasks from Linux hosts may trigger alerts. Identify and document these tasks to create exceptions for known IP addresses or hostnames involved in regular operations.
- Automated backup or monitoring systems that connect to Windows hosts using SMB may cause false positives. Review and whitelist these systems by their IP addresses or specific named pipes they access.
- Development or testing environments where Linux hosts frequently interact with Windows systems can generate alerts. Establish a separate monitoring policy or exclude these environments from the rule to reduce noise.
- Security tools or scripts that perform network scans or audits might mimic suspicious behavior. Verify these tools and exclude their activities by specifying their source IPs or associated user accounts.
- Cross-platform file sharing services that use SMB for legitimate purposes may be flagged. Identify these services and adjust the rule to ignore their specific connection patterns or named pipes.


### Response and remediation

- Isolate the affected Linux host from the network to prevent further unauthorized SMB connection attempts and potential credential capture.
- Conduct a thorough review of the Linux host's network activity logs to identify any unauthorized access or data exfiltration attempts.
- Reset passwords for any accounts that may have been exposed or compromised during the forced authentication attempt to mitigate the risk of credential misuse.
- Implement network segmentation to limit SMB traffic between Linux and Windows hosts, reducing the attack surface for similar threats.
- Escalate the incident to the security operations center (SOC) for further investigation and to determine if additional hosts or systems are affected.
- Deploy enhanced monitoring on the identified named pipes and associated network traffic to detect and respond to future forced authentication attempts promptly.
- Review and update firewall rules to restrict unnecessary SMB traffic and ensure only authorized systems can communicate over port 445.


## Rule Query

```eql
sequence with maxspan=15s
[network where host.os.type == "linux" and event.action == "connection_attempted" and destination.port == 445 and not startswith~(string(destination.ip), string(host.ip))] by host.ip, data_stream.namespace
[file where host.os.type == "windows" and event.code == "5145" and file.name : ("Spoolss", "netdfs", "lsarpc", "lsass", "netlogon", "samr", "efsrpc", "FssagentRpc")] by source.ip, data_stream.namespace
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Forced Authentication
- Id: T1187
- Reference URL: [[https://attack.mitre.org/techniques/T1187/](https://attack.mitre.org/techniques/T1187/)](https://attack.mitre.org/techniques/T1187/)