﻿---
title: Potential Traffic Tunneling using QEMU
description: Identifies the use of the QEMU hardware emulator to potentially tunnel network traffic between Virtual machines. This can be used by attackers to enable...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_tunnel_qemu
products:
  - Elastic Security
---

# Potential Traffic Tunneling using QEMU
Identifies the use of the QEMU hardware emulator to potentially tunnel network traffic between Virtual machines. This
can be used by attackers to enable routing of network packets that would otherwise not reach their intended destination.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process-*
- logs-m365_defender.event-*
- logs-sentinel_one_cloud_funnel.*
- logs-system.security*
- logs-windows.sysmon_operational-*
- winlogbeat-*
- auditbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://securelist.com/network-tunneling-with-qemu/111803/](https://securelist.com/network-tunneling-with-qemu/111803/)](https://securelist.com/network-tunneling-with-qemu/111803/)
- [[https://blog.xpnsec.com/bring-your-own-vm-mac-edition/](https://blog.xpnsec.com/bring-your-own-vm-mac-edition/)](https://blog.xpnsec.com/bring-your-own-vm-mac-edition/)
- [[https://www.huntress.com/blog/active-exploitation-solarwinds-web-help-desk-cve-2025-26399](https://www.huntress.com/blog/active-exploitation-solarwinds-web-help-desk-cve-2025-26399)](https://www.huntress.com/blog/active-exploitation-solarwinds-web-help-desk-cve-2025-26399)

**Tags**:
- Domain: Endpoint
- OS: Windows
- OS: Linux
- OS: macOS
- Use Case: Threat Detection
- Tactic: Command and Control
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Sysmon
- Data Source: SentinelOne
- Data Source: Microsoft Defender for Endpoint
- Data Source: Windows Security Event Logs
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Traffic Tunneling using QEMU

QEMU is a legitimate virtualization and emulation platform used for system testing and development. However, its advanced networking features can be abused to tunnel network traffic, forward ports, and create covert communication channels between systems. The detection rule identifies suspicious QEMU executions using networking-related arguments that are commonly associated with traffic forwarding and tunneling behavior.

### Possible investigation steps

- Review the process command line for the presence of networking arguments such as `-netdev`, `hostfwd=`, `connect=`, `restrict=off`, and `-nographic`.
- Confirm whether QEMU is legitimately installed and expected to run on the affected system.
- Check the parent process to determine how QEMU was launched and whether the execution chain appears suspicious.
- Investigate the user account and host context to assess whether virtualization activity is normal for that environment.
- Analyze related network activity for signs of traffic forwarding, tunneling, or unauthorized external connections.
- Correlate the event with other telemetry (process creation, persistence mechanisms, or VM artifacts) for additional context.


### False positive analysis

- Legitimate developer or research environments using QEMU for virtualization and testing may trigger this rule.
- Approved lab systems, malware analysis sandboxes, or CI/CD pipelines may use similar networking configurations.
- Internal training or testing environments may generate similar activity.


### Response and remediation

- Isolate the affected system and terminate unauthorized QEMU processes.
- Investigate for signs of lateral movement or command-and-control activity.
- Remove unauthorized VM images, configurations, and persistence mechanisms.
- Rotate credentials and assess scope of impact if tunneling activity is confirmed.
- Escalate to the SOC or incident response team for further investigation.


## Rule Query

```eql
process where event.type == "start" and
 process.args : "-netdev" and
 (
  (process.args : "-nographic" and process.command_line : "*connect=*" and process.command_line : "*restrict=off*") or
   process.command_line : "*hostfwd=*"
 )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Remote Access Tools
- Id: T1219
- Reference URL: [[https://attack.mitre.org/techniques/T1219/](https://attack.mitre.org/techniques/T1219/)](https://attack.mitre.org/techniques/T1219/)