﻿---
title: SOCKS Traffic from an Unusual Process
description: This detection correlates FortiGate's application control SOCKS events with Elastic Defend network event to identify the source process performing SOCKS...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_socks_fortigate_endpoint
products:
  - Elastic Security
---

# SOCKS Traffic from an Unusual Process
This detection correlates FortiGate's application control SOCKS events with Elastic Defend network event to identify the
source process performing SOCKS traffic. Adversaries may use a connection proxy to direct network traffic between systems
or act as an intermediary for network communications to a command and control server to avoid direct connections to their
infrastructure.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*
- logs-fortinet_fortigate.log-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://attack.mitre.org/techniques/T1090/](https://attack.mitre.org/techniques/T1090/)](https://attack.mitre.org/techniques/T1090/)
- [[https://www.elastic.co/docs/reference/integrations/fortinet_fortigate](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)](https://www.elastic.co/docs/reference/integrations/fortinet_fortigate)
- [[https://www.elastic.co/docs/reference/integrations/endpoint](https://www.elastic.co/docs/reference/integrations/endpoint)](https://www.elastic.co/docs/reference/integrations/endpoint)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: Windows
- OS: macOS
- Use Case: Threat Detection
- Tactic: Command and Control
- Data Source: Elastic Defend
- Data Source: Fortinet
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating SOCKS Traffic from an Unusual Process


### Possible investigation steps

- Review the process details like command_line, privileges, global relevance and reputation.
- Review the parent process execution details like command_line, global relevance and reputation.
- Examine all network connection details performed by the process during last 48h.
- Examine all localhost network connections performed by the same process to verify if there is any port forwarding with another process on the same machine.
- Correlate the alert with other security events or logs to identify any patterns or additional indicators of compromise related to the same process or network activity.


### False positive analysis

- Browser proxy extensions and Add-ons.
- Development and deployment tools.
- Third party trusted tools using SOCKS for network communication.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Terminate the suspicious processes and all associated children and parents.
- Conduct a thorough review of the system's configuration files to identify unauthorized changes.
- Reset credentials for any accounts associated with the source machine.
- Implement network-level controls to block traffic via SOCKS unless authorized.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.


## Rule Query

```eql
sequence by source.port, source.ip, destination.ip with maxspan=1m
 [network where event.dataset == "fortinet_fortigate.log" and event.action == "signature" and network.application in ("SOCKS4", "SOCKS5")]
 [network where event.module == "endpoint" and event.action in ("disconnect_received", "connection_attempted")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Proxy
- Id: T1090
- Reference URL: [[https://attack.mitre.org/techniques/T1090/](https://attack.mitre.org/techniques/T1090/)](https://attack.mitre.org/techniques/T1090/)