﻿---
title: PANW and Elastic Defend - Command and Control Correlation
description: This detection correlates Palo Alto Networks (PANW) command and control events with Elastic Defend network events to identify the source process performing...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_pan_elastic_defend_c2
products:
  - Elastic Security
---

# PANW and Elastic Defend - Command and Control Correlation
This detection correlates Palo Alto Networks (PANW) command and control events with Elastic Defend network events to identify
the source process performing the network activity.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*
- logs-panw.panos-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- [[https://www.elastic.co/docs/reference/integrations/panw](https://www.elastic.co/docs/reference/integrations/panw)](https://www.elastic.co/docs/reference/integrations/panw)
- [[https://www.elastic.co/docs/reference/integrations/endpoint](https://www.elastic.co/docs/reference/integrations/endpoint)](https://www.elastic.co/docs/reference/integrations/endpoint)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: Windows
- OS: macOS
- Use Case: Threat Detection
- Tactic: Command and Control
- Data Source: Elastic Defend
- Data Source: PAN-OS
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating PANW and Elastic Defend - Command and Control Correlation


### Possible investigation steps

- Investigate in the Timeline feature the two events matching this correlation (PANW and Elastic Defend).
- Review the process details like command_line, privileges, global relevance and reputation.
- Assess the destination.ip reputation and global relevance.
- Review the parent process execution details like command_line, global relevance and reputation.
- Examine all network connection details performed by the process during last 48h.
- Correlate the alert with other security events or logs to identify any patterns or additional indicators of compromise related to the same process or network activity.


### False positive analysis

- Trusted system or third party processes performing network activity that looks like beaconing.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Terminate the suspicious processes and all associated children and parents.
- Implement network-level controls to block traffic to the destination.ip.
- Conduct a thorough review of the system's configuration files to identify unauthorized changes.
- Reset credentials for any accounts associated with the source machine.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.


## Rule Query

```eql
sequence by source.port, source.ip, destination.ip with maxspan=1m
 [network where event.module == "panw" and event.action == "c2_communication"]
 [network where event.module == "endpoint" and event.action in ("disconnect_received", "connection_attempted")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)