﻿---
title: Sysmon Event ID 3: Network Connection
description: Caution: Collecting Sysmon events without a tailored configuration for your environment will cause high data volume. These setup instructions would need...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid3_network_connection
products:
  - Elastic Security
---

# Sysmon Event ID 3: Network Connection
## Setup

**Caution:** Collecting Sysmon events without a tailored configuration for your environment will cause high data volume. These setup instructions would need significant tuning in order to be production-ready. For more specific configurations, we recommend you to explore the following resources:
- [https://github.com/trustedsec/SysmonCommunityGuide](https://github.com/trustedsec/SysmonCommunityGuide)
- [https://github.com/olafhartong/sysmon-modular](https://github.com/olafhartong/sysmon-modular)
- [https://github.com/Neo23x0/sysmon-config](https://github.com/Neo23x0/sysmon-config)

Some detection rules support the use of Sysmon Event ID 3 (Network Connection) events to detect malicious network activity, such as connections to command and control (C2) servers or data exfiltration.
To collect these logs, use the [Windows Integration](https://www.elastic.co/docs/current/integrations/windows) and select the `Sysmon Operational` channel on the integration setup page.

## Configuration Example

The following snippet demonstrates the minimal configuration required to enable Event ID 3 (Network Connection). While this will turn on the event logging, it lacks the necessary filtering for a production environment and will generate significant noise. It should be used as a reference and integrated into a more robust configuration, such as those provided in the resources above.
```xml
<Sysmon schemaversion="4.90">
    <HashAlgorithms>md5,sha256</HashAlgorithms>
    <EventFiltering>
        <!-- Log all network connection events -->
        <NetworkConnect onmatch="exclude"></NetworkConnect>
    </EventFiltering>
</Sysmon>
```


## Related Rules

Use the following GitHub search to identify rules that use the events generated by this configuration:
[Elastic Detection Rules Github Repo Search](https://github.com/search?q=repo%3Aelastic%2Fdetection-rules+%22Data+Source%3A+Sysmon%22+AND+%28%22network+where%22+OR+%22event.category%3Anetwork%22%29++language%3ATOML&type=code)