﻿---
title: Sysmon Event ID 17, 18: Pipe Events
description: Caution: Collecting Sysmon events without a tailored configuration for your environment will cause high data volume. These setup instructions would need...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid17_18_pipe_event
products:
  - Elastic Security
---

# Sysmon Event ID 17, 18: Pipe Events
## Setup

**Caution:** Collecting Sysmon events without a tailored configuration for your environment will cause high data volume. These setup instructions would need significant tuning in order to be production-ready. For more specific configurations, we recommend you to explore the following resources:
- [https://github.com/trustedsec/SysmonCommunityGuide](https://github.com/trustedsec/SysmonCommunityGuide)
- [https://github.com/olafhartong/sysmon-modular](https://github.com/olafhartong/sysmon-modular)
- [https://github.com/Neo23x0/sysmon-config](https://github.com/Neo23x0/sysmon-config)

Some detection rules require the use of Sysmon named pipe events (Event IDs 17 and 18) to detect malicious activity, such as lateral movement techniques employed by tools like Cobalt Strike or Metasploit.
To collect these logs, use the [Windows Integration](https://www.elastic.co/docs/current/integrations/windows) and select the `Sysmon Operational` channel on the integration setup page.

## Configuration Example

The following snippet demonstrates the minimal configuration required to enable Sysmon's named pipe monitoring capabilities. This single configuration block enables Event ID 17 (Pipe Created) and Event ID 18 (Pipe Connected). While this will turn on the event logging, it lacks the necessary filtering for a production environment and will generate significant noise. It should be used as a reference and integrated into a more robust configuration, such as those provided in the resources above.
```xml
<Sysmon schemaversion="4.90">
    <HashAlgorithms>md5,sha256</HashAlgorithms>
    <EventFiltering>
        <!-- Log all named pipe events (Covers IDs 17 and 18) -->
        <PipeEvent onmatch="exclude"></PipeEvent>
    </EventFiltering>
</Sysmon>
```


## Related Rules

Use the following GitHub search to identify rules that use the events generated by this configuration:
[Elastic Detection Rules Github Repo Search](https://github.com/search?q=repo%3Aelastic%2Fdetection-rules+%22Data+Source%3A+Sysmon%22+AND+%28%22event.code+%3D%3D+%5C%2217%5C%22%22+OR+%22event.code%3A%5C%2217%5C%22%22+OR+%22event.code%3A17%22+OR+%22event.code+%3D%3D+%5C%2218%5C%22%22+OR+%22event.code%3A%5C%2218%5C%22%22+OR+%22event.code%3A18%22%29++language%3ATOML&type=code)