﻿---
title: Sysmon Event ID 10: Process Access
description: Caution: Collecting Sysmon events without a tailored configuration for your environment will cause high data volume. These setup instructions would need...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid10_process_access
products:
  - Elastic Security
---

# Sysmon Event ID 10: Process Access
## Setup

**Caution:** Collecting Sysmon events without a tailored configuration for your environment will cause high data volume. These setup instructions would need significant tuning in order to be production-ready. For more specific configurations, we recommend you to explore the following resources:
- [https://github.com/trustedsec/SysmonCommunityGuide](https://github.com/trustedsec/SysmonCommunityGuide)
- [https://github.com/olafhartong/sysmon-modular](https://github.com/olafhartong/sysmon-modular)
- [https://github.com/Neo23x0/sysmon-config](https://github.com/Neo23x0/sysmon-config)

Some detection rules require the use of Sysmon Event ID 10 (Process Accessed) events to detect malicious activity, such as credential dumping from `lsass.exe`.
To collect these logs, use the [Windows Integration](https://www.elastic.co/docs/current/integrations/windows) and select the `Sysmon Operational` channel on the integration setup page.

## Configuration Example

The following example demonstrates a more targeted approach for Event ID 10 by focusing specifically on attempts to access the `lsass.exe` process. Based on [https://github.com/Neo23x0/sysmon-config/blob/1fdc5f837e06bcf95a42f0c8d49ea311fde628a3/sysmonconfig-export.xml#L517C4-L520C11](https://github.com/Neo23x0/sysmon-config/blob/1fdc5f837e06bcf95a42f0c8d49ea311fde628a3/sysmonconfig-export.xml#L517C4-L520C11)
```xml
<Sysmon schemaversion="4.90">
    <HashAlgorithms>md5,sha256</HashAlgorithms>
    <EventFiltering>
        <ProcessAccess onmatch="include">
            <Rule groupRelation="and">
		        <TargetImage condition="end with">\lsass.exe</TargetImage>
		        <GrantedAccess condition="contains any">0x40;0x1000;0x1010;0x1038;0x1410;0x1418;0x1438;0x143a;0x100000;0x1f0fff;0x1f1fff;0x1f2fff;0x1f3fff;0x1fffff</GrantedAccess> <!--0x1400 too noisy-->
	        </Rule>
        </ProcessAccess>
    </EventFiltering>
</Sysmon>
```


## Related Rules

Use the following GitHub search to identify rules that use the events generated by this configuration:
[Elastic Detection Rules Github Repo Search](https://github.com/search?q=repo%3Aelastic%2Fdetection-rules+%22Data+Source%3A+Sysmon%22+AND+%28%22event.code+%3D%3D+%5C%2210%5C%22%22+OR+%22winlog.event_data.TargetImage%22%29++language%3ATOML&type=code)