﻿---
title: Windows Audit Policies
description: Windows related audit policies that need to be implemented in order to generate the events that power our detection rules. It serves as a centralized...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/readme
products:
  - Elastic Security
---

# Windows Audit Policies
Windows related audit policies that need to be implemented in order to generate the events that power our detection rules. It serves as a centralized view of the policies we use so you don't need to go through every rule to know the different audit policies required.
Audit Policies:
- [Audit Authorization Policy Change](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_authorization_policy_change)
- [Audit Computer Account Management](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_computer_account_management)
- [Audit Detailed File Share](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_detailed_file_share)
- [Audit Directory Service Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_directory_service_access)
- [Audit Directory Service Changes](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_directory_service_changes)
- [Audit Filtering Platform Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_filtering_platform_connection)
- [Audit Filtering Platform Packet Drop](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_filtering_platform_packet_drop)
- [Audit Handle Manipulation](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_handle_manipulation)
- [Audit Logon](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_logon)
- [Audit Other Object Access Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_other_object_access_events)
- [Audit Policy Change](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_policy_change)
- [Audit Process Creation and Command Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_process_creation_and_command_line)
- [Audit Security Group Management](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_security_group_management)
- [Audit Security System Extension](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_security_system_extension)
- [Audit Sensitive Privilege Use](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_sensitive_privilege_use)
- [Audit Special Logon](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_special_logon)
- [Audit Token Right Adjusted Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_token_right_adjusted_events)
- [Audit User Account Management](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_user_account_management)
- [Audit Powershell Script Block Logging](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/audit_powershell_scriptblock)

---


# Sysmon Configuration Guides

**Caution:** The following guides provide minimal configuration examples designed to enable specific Sysmon Event IDs. Collecting Sysmon events without a tailored configuration for your environment will cause high data volume and potentially high CPU-load, and these setup instructions require significant tuning to be production-ready.
To build an efficient and production-ready configuration, we strongly recommend exploring these community resources:
- [TrustedSec Sysmon Community Guide](https://github.com/trustedsec/SysmonCommunityGuide)
- [olafhartong - sysmon-modular](https://github.com/olafhartong/sysmon-modular)
- [Neo23x0 - sysmon-config](https://github.com/Neo23x0/sysmon-config)

For a production-ready and more integrated solution that is designed to work with our detection rules and also provide native Endpoint Protection and Response, check out [Elastic Endpoint Security](https://www.elastic.co/security/endpoint-security).
- [Sysmon Event ID 1: Process Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid1_process_creation)
- [Sysmon Event ID 2: File Creation Time Changed](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid2_file_creation_time_changed)
- [Sysmon Event ID 3: Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid3_network_connection)
- [Sysmon Event ID 7: Image Loaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid7_image_loaded)
- [Sysmon Event ID 8: Create Remote Thread](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid8_createremotethread)
- [Sysmon Event ID 10: Process Accessed](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid10_process_access)
- [Sysmon Event ID 11: File Create](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid11_file_create)
- [Sysmon Event IDs 12, 13, 14: Registry Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid12_13_14_registry_event)
- [Sysmon Event IDs 17, 18: Named Pipe Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid17_18_pipe_event)
- [Sysmon Event IDs 19, 20, 21: WMI Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid19_20_21_wmi_event)
- [Sysmon Event ID 22: DNS Query](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid22_dns_query)
- [Sysmon Event ID 23: File Delete](https://www.elastic.co/docs/reference/security/prebuilt-rules/audit_policies/windows/sysmon_eventid23_file_delete)