﻿---
title: Prebuilt detection rules reference
description: AWS Access Token Used from Multiple Addresses AWS CLI with Kali Linux Fingerprint Identified AWS CloudTrail Log Created AWS CloudTrail Log Deleted AWS...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules
products:
  - Elastic Security
---

# Prebuilt detection rules reference
<important>
  All prebuilt machine learning rules are tagged with `ML`, and their rule type is `machine_learning`. Before using prebuilt machine learning rules, ensure you have all of the appropriate requirements.
</important>


## Cloud

[AWS Access Token Used from Multiple Addresses](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/initial_access_iam_session_token_used_from_multiple_addresses) [AWS CLI with Kali Linux Fingerprint Identified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/initial_access_kali_user_agent_detected_with_aws_cli) [AWS CloudTrail Log Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/collection_cloudtrail_logging_created) [AWS CloudTrail Log Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_cloudtrail_logging_deleted) [AWS CloudTrail Log Evasion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_cloudtrail_logging_evasion) [AWS CloudTrail Log Suspended](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_cloudtrail_logging_suspended) [AWS CloudTrail Log Updated](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_cloudtrail_logging_updated) [AWS CloudWatch Alarm Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_cloudwatch_alarm_deletion) [AWS CloudWatch Log Group Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_cloudwatch_log_group_deletion) [AWS CloudWatch Log Stream Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_cloudwatch_log_stream_deletion) [AWS Config Resource Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_config_service_rule_deletion) [AWS Configuration Recorder Stopped](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_configuration_recorder_stopped) [AWS Discovery API Calls via CLI from a Single Resource](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/discovery_multiple_discovery_api_calls_via_cli) [AWS DynamoDB Scan by Unusual User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_dynamodb_scan_by_unusual_user) [AWS DynamoDB Table Exported to S3](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_dynamodb_table_exported_to_s3) [AWS EC2 AMI Shared with Another Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_ec2_ami_shared_with_separate_account) [AWS EC2 Deprecated AMI Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/discovery_ec2_deprecated_ami_discovery) [AWS EC2 EBS Snapshot Access Removed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_ec2_ebs_snapshot_access_removed) [AWS EC2 EBS Snapshot Shared or Made Public](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_ec2_ebs_snapshot_shared_with_another_account) [AWS EC2 Encryption Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_ec2_disable_ebs_encryption) [AWS EC2 Export Task](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_ec2_export_task) [AWS EC2 Full Network Packet Capture Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_ec2_full_network_packet_capture_detected) [AWS EC2 Instance Connect SSH Public Key Uploaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/lateral_movement_ec2_instance_connect_ssh_public_key_uploaded) [AWS EC2 Instance Console Login via Assumed Role](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/lateral_movement_ec2_instance_console_login) [AWS EC2 Instance Interaction with IAM Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_iam_instance_request_to_iam_service) [AWS EC2 LOLBin Execution via SSM SendCommand](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_aws_ec2_lolbin_via_ssm) [AWS EC2 Multi-Region DescribeInstances API Calls](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_ec2_multi_region_describe_instances) [AWS EC2 Network Access Control List Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_ec2_network_acl_creation) [AWS EC2 Network Access Control List Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_ec2_network_acl_deletion) [AWS EC2 Route Table Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_route_table_created) [AWS EC2 Route Table Modified or Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_ec2_route_table_modified_or_deleted) [AWS EC2 Security Group Configuration Change](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_ec2_security_group_configuration_change_detection) [AWS EC2 Serial Console Access Enabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_ec2_serial_console_access_enabled) [AWS EC2 Unauthorized Admin Credential Fetch via Assumed Role](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/credential_access_aws_getpassword_for_ec2_instance) [AWS EC2 User Data Retrieval for EC2 Instance](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/discovery_ec2_userdata_request_for_ec2_instance) [AWS EFS File System Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_efs_filesystem_deleted) [AWS EventBridge Rule Disabled or Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_aws_eventbridge_rule_disabled_or_deleted) [AWS First Occurrence of STS GetFederationToken Request by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_sts_get_federation_token) [AWS GuardDuty Detector Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_guardduty_detector_deletion) [AWS IAM API Calls via Temporary Session Tokens](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_iam_api_calls_via_user_session_token) [AWS IAM AdministratorAccess Policy Attached to Group](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_iam_administratoraccess_policy_attached_to_group) [AWS IAM AdministratorAccess Policy Attached to Role](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_iam_administratoraccess_policy_attached_to_role) [AWS IAM AdministratorAccess Policy Attached to User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_iam_administratoraccess_policy_attached_to_user) [AWS IAM Assume Role Policy Update](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_iam_update_assume_role_policy) [AWS IAM CompromisedKeyQuarantine Policy Attached to User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/credential_access_iam_compromisedkeyquarantine_policy_attached_to_user) [AWS IAM Create User via Assumed Role on EC2 Instance](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_iam_create_user_via_assumed_role_on_ec2_instance) [AWS IAM Customer-Managed Policy Attached to Role by Rare User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_iam_customer_managed_policy_attached_to_role) [AWS IAM Deactivation of MFA Device](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_iam_deactivate_mfa_device) [AWS IAM Group Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_iam_group_creation) [AWS IAM Group Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_iam_group_deletion) [AWS IAM Login Profile Added for Root](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_iam_create_login_profile_for_root) [AWS IAM Login Profile Added to User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_aws_iam_login_profile_added_to_user) [AWS IAM Principal Enumeration via UpdateAssumeRolePolicy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/discovery_iam_principal_enumeration_via_update_assume_role_policy) [AWS IAM Roles Anywhere Profile Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_iam_roles_anywhere_profile_created) [AWS IAM Roles Anywhere Trust Anchor Created with External CA](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_iam_roles_anywhere_trusted_anchor_created_with_external_ca) [AWS IAM SAML Provider Updated](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_iam_saml_provider_updated) [AWS IAM User Addition to Group](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/credential_access_iam_user_addition_to_group) [AWS IAM User Created Access Keys For Another User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_iam_user_created_access_keys_for_another_user) [AWS IAM Virtual MFA Device Registration Attempt with Session Token](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_aws_attempt_to_register_virtual_mfa_device) [AWS KMS Customer Managed Key Disabled or Scheduled for Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_kms_cmk_disabled_or_scheduled_for_deletion) [AWS Lambda Function Created or Updated](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_aws_lambda_function_updated) [AWS Lambda Function Policy Updated to Allow Public Invocation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_lambda_backdoor_invoke_function_for_any_principal) [AWS Lambda Layer Added to Existing Function](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/execution_lambda_external_layer_added_to_function) [AWS Management Console Brute Force of Root User Identity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/credential_access_root_console_failure_brute_force) [AWS Management Console Root Login](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/initial_access_console_login_root) [AWS RDS DB Instance Made Public](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_rds_instance_made_public) [AWS RDS DB Instance Restored](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_rds_instance_restored) [AWS RDS DB Instance or Cluster Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_rds_instance_cluster_deletion) [AWS RDS DB Instance or Cluster Deletion Protection Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_rds_instance_cluster_deletion_protection_disabled) [AWS RDS DB Instance or Cluster Password Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_rds_db_instance_password_modified) [AWS RDS DB Snapshot Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_aws_rds_snapshot_created) [AWS RDS DB Snapshot Shared with Another Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_rds_snapshot_shared_with_another_account) [AWS RDS Snapshot Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_rds_snapshot_deleted) [AWS RDS Snapshot Export](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_rds_snapshot_export) [AWS Route 53 Domain Transfer Lock Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_route_53_domain_transfer_lock_disabled) [AWS Route 53 Domain Transferred to Another Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_route_53_domain_transferred_to_another_account) [AWS Route 53 Private Hosted Zone Associated With a VPC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_route_53_hosted_zone_associated_with_a_vpc) [AWS Route 53 Resolver Query Log Configuration Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_route53_dns_query_resolver_config_deletion) [AWS S3 Bucket Configuration Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_s3_bucket_configuration_deletion) [AWS S3 Bucket Enumeration or Brute Force](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_aws_s3_bucket_enumeration_or_brute_force) [AWS S3 Bucket Expiration Lifecycle Configuration Added](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_s3_bucket_lifecycle_expiration_added) [AWS S3 Bucket Policy Added to Allow Public Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_s3_bucket_policy_added_for_public_access) [AWS S3 Bucket Policy Added to Share with External Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_s3_bucket_policy_added_for_external_account_access) [AWS S3 Bucket Replicated to Another Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_s3_bucket_replicated_to_external_account) [AWS S3 Bucket Server Access Logging Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_s3_bucket_server_access_logging_disabled) [AWS S3 Object Encryption Using External KMS Key](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_s3_object_encryption_with_external_key) [AWS S3 Object Versioning Suspended](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_s3_object_versioning_disabled) [AWS S3 Static Site JavaScript File Uploaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_s3_static_site_js_file_uploaded) [AWS S3 Unauthenticated Bucket Access by Rare Source](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/collection_s3_unauthenticated_bucket_access_by_rare_source) [AWS SNS Rare Protocol Subscription by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/exfiltration_sns_rare_protocol_subscription_by_user) [AWS SNS Topic Created by Rare User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/resource_development_sns_topic_created_by_rare_user) [AWS SNS Topic Message Publish by Rare User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/lateral_movement_sns_topic_message_publish_by_rare_user) [AWS SQS Queue Purge](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_sqs_purge_queue) [AWS SSM Command Document Created by Rare User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/execution_ssm_command_document_created_by_rare_user) [AWS SSM Session Started to EC2 Instance](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/lateral_movement_aws_ssm_start_session_to_ec2_instance) [AWS SSM `SendCommand` Execution by Rare User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/execution_ssm_sendcommand_by_rare_user) [AWS STS AssumeRole with New MFA Device](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_sts_assume_role_with_new_mfa) [AWS STS AssumeRoot by Rare User and Member Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_sts_assume_root_from_rare_user_and_member_account) [AWS STS GetCallerIdentity API Called for the First Time](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/discovery_new_terms_sts_getcalleridentity) [AWS STS GetSessionToken Usage](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/privilege_escalation_sts_getsessiontoken_abuse) [AWS STS Role Assumption by Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_role_assumption_by_service) [AWS STS Role Assumption by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_role_assumption_by_user) [AWS STS Role Chaining](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_sts_role_chaining) [AWS Secrets Manager Rapid Secrets Retrieval](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/credential_access_rapid_secret_retrieval_attempts_from_secretsmanager) [AWS Service Quotas Multi-Region GetServiceQuota Requests](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/discovery_servicequotas_multi_region_service_quota_requests) [AWS Sign-In Console Login with Federated User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/initial_access_signin_console_login_federated_user) [AWS Sign-In Root Password Recovery Requested](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/initial_access_password_recovery) [AWS Sign-In Token Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_aws_signin_token_created) [AWS Systems Manager SecureString Parameter Request with Decryption Flag](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/credential_access_retrieve_secure_string_parameters_via_ssm) [AWS VPC Flow Logs Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_ec2_flow_log_deletion) [AWS WAF Access Control List Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_waf_acl_deletion) [AWS WAF Rule or Rule Group Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_waf_rule_or_rule_group_deletion) [Application Added to Google Workspace Domain](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_application_added_to_google_workspace_domain) [Application Removed from Blocklist in Google Workspace](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/defense_evasion_application_removed_from_blocklist_in_google_workspace) [Azure Automation Account Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_automation_account_created) [Azure Automation Runbook Created or Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/execution_automation_runbook_created_or_modified) [Azure Automation Runbook Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/defense_evasion_automation_runbook_deleted) [Azure Automation Webhook Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_automation_webhook_created) [Azure Blob Storage Container Access Level Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/discovery_storage_blob_container_access_modification) [Azure Blob Storage Permissions Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/defense_evasion_storage_blob_permissions_modified) [Azure Compute Restore Point Collection Deleted by Unusual User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/impact_azure_compute_restore_point_collection_deleted) [Azure Compute Restore Point Collections Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/impact_azure_compute_restore_point_collections_deleted) [Azure Compute Snapshot Deletion by Unusual User and Resource Group](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/impact_azure_compute_vm_snapshot_deletion) [Azure Compute Snapshot Deletions by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/impact_azure_compute_vm_snapshot_deletions) [Azure Compute VM Command Executed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/execution_compute_vm_command_executed) [Azure Diagnostic Settings Alert Suppression Rule Created or Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/defense_evasion_security_alert_suppression_rule_created) [Azure Diagnostic Settings Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/defense_evasion_insights_diagnostic_settings_deletion) [Azure Event Hub Authorization Rule Created or Updated](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_event_hub_created_or_updated) [Azure Event Hub Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/defense_evasion_event_hub_deletion) [Azure Key Vault Excessive Secret or Key Retrieved](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_key_vault_excessive_retrieval) [Azure Key Vault Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/impact_key_vault_modified_by_unusual_user) [Azure Key Vault Unusual Secret Key Usage](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_key_vault_retrieval_from_rare_identity) [Azure Kubernetes Services (AKS) Kubernetes Events Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/defense_evasion_kubernetes_events_deleted) [Azure Kubernetes Services (AKS) Kubernetes Pods Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/impact_kubernetes_pod_deleted) [Azure Kubernetes Services (AKS) Kubernetes Rolebindings Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/privilege_escalation_kubernetes_aks_rolebinding_created) [Azure RBAC Built-In Administrator Roles Assigned](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/privilege_escalation_azure_rbac_administrator_roles_assigned) [Azure Recovery Services Resource Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/impact_azure_recovery_services_deletion) [Azure Resource Group Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/impact_resources_resource_group_deletion) [Azure Storage Account Blob Public Access Enabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/collection_azure_storage_account_blob_public_access_enabled) [Azure Storage Account Deletion by Unusual User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/impact_azure_storage_account_deletion) [Azure Storage Account Deletions by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/impact_azure_storage_account_deletion_multiple) [Azure Storage Account Key Regenerated](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_storage_account_key_regenerated) [Azure Storage Account Keys Accessed by Privileged User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_azure_storage_account_keys_accessed) [Azure Storage Blob Retrieval via AzCopy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/exfiltration_azure_storage_blob_download_azcopy_sas_token) [Azure VNet Firewall Front Door WAF Policy Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/defense_evasion_network_frontdoor_firewall_policy_deletion) [Azure VNet Firewall Policy Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/defense_evasion_network_firewall_policy_deletion) [Azure VNet Full Network Packet Capture Enabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_network_full_network_packet_capture_detected) [Azure VNet Network Watcher Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/defense_evasion_network_watcher_deletion) [Domain Added to Google Workspace Trusted Domains](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/defense_evasion_domain_added_to_google_workspace_trusted_domains) [Entra ID ADRS Token Request by Microsoft Authentication Broker](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_suspicious_adrs_token_request) [Entra ID Actor Token User Impersonation Abuse](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_actor_token_user_impersonation_abuse) [Entra ID Application Credential Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_application_credential_modification) [Entra ID Concurrent Sign-in with Suspicious Properties](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_entra_id_suspicious_signin) [Entra ID Conditional Access Policy (CAP) Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_conditional_access_policy_modified) [Entra ID Device Registration Detected (ROADtools)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_suspicious_cloud_device_registration) [Entra ID Elevated Access to User Access Administrator](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/privilege_escalation_entra_id_elevate_to_user_administrator_access) [Entra ID Excessive Account Lockouts Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_entra_id_excessive_account_lockouts) [Entra ID External Authentication Methods (EAM) Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_graph_eam_addition_or_modification) [Entra ID External Guest User Invited](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_external_guest_user_invite) [Entra ID Global Administrator Role Assigned](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_global_administrator_role_assigned) [Entra ID Global Administrator Role Assigned (PIM User)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_pim_user_added_global_admin) [Entra ID High Risk Sign-in](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_high_risk_signin) [Entra ID High Risk User Sign-in Heuristic](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_risky_user_or_compromised_sign_in) [Entra ID Illicit Consent Grant via Registered Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_illicit_consent_grant_via_registered_application) [Entra ID MFA Disabled for User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_mfa_disabled_for_user) [Entra ID MFA TOTP Brute Force Attempted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_entra_id_totp_brute_force_attempts) [Entra ID OAuth Authorization Code Grant for Unusual User, App, and Resource](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_oauth_auth_code_grant_unusual_app_resource_user) [Entra ID OAuth Device Code Flow with Concurrent Sign-ins](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_azure_entra_susp_device_code_signin) [Entra ID OAuth Device Code Grant by Microsoft Authentication Broker](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_device_code_auth_with_broker_client) [Entra ID OAuth Device Code Grant by Unusual User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_first_time_seen_device_code_auth) [Entra ID OAuth Flow by Microsoft Authentication Broker to Device Registration Service (DRS)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_suspicious_oauth_flow_via_auth_broker_to_drs) [Entra ID OAuth PRT Issuance to Non-Managed Device Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_rt_to_prt_transition_from_user_device) [Entra ID OAuth Phishing via First-Party Microsoft Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_oauth_phishing_via_first_party_microsoft_application) [Entra ID OAuth ROPC Grant Login Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_unusual_ropc_login_attempt) [Entra ID OAuth User Impersonation to Microsoft Graph](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_graph_single_session_from_multiple_addresses) [Entra ID OAuth user_impersonation Scope for Unusual User and Client](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_oauth_user_impersonation_scope) [Entra ID OIDC Discovery URL Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_oidc_discovery_url_change) [Entra ID PowerShell Sign-in](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_powershell_signin) [Entra ID Privileged Identity Management (PIM) Role Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_privileged_identity_management_role_modified) [Entra ID Protection - Risk Detection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/entra_id_identity_protection_risk_detections) [Entra ID Protection - Risk Detection - Sign-in Risk](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_protection_sign_in_risk_detected) [Entra ID Protection - Risk Detection - User Risk](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_protection_user_risk_detected) [Entra ID Protection Admin Confirmed Compromise](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_protection_confirmed_compromise) [Entra ID Protection Alerts for User Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_protection_alerts_for_user) [Entra ID Protection User Alert and Device Registration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_identity_protect_alert_followed_by_device_reg) [Entra ID Service Principal Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_service_principal_created) [Entra ID Service Principal Credentials Created by Unusual User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_service_principal_credentials_added) [Entra ID SharePoint Accessed by Unusual User and Microsoft Authentication Broker Client](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/collection_entra_id_auth_broker_sharepoint_access_for_user_principal) [Entra ID Sign-in BloodHound Suite User-Agent Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/discovery_bloodhound_user_agents_detected) [Entra ID Sign-in Brute Force Attempted (Microsoft 365)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_entra_id_signin_brute_force_microsoft_365) [Entra ID Sign-in TeamFiltration User-Agent Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/discovery_entra_id_teamfiltration_user_agents_detected) [Entra ID User Added as Registered Application Owner](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_user_added_as_owner_for_azure_application) [Entra ID User Added as Service Principal Owner](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_user_added_as_owner_for_azure_service_principal) [Entra ID User Reported Suspicious Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_user_reported_risk) [Entra ID User Sign-in Brute Force Attempted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_entra_id_brute_force_activity) [Entra ID User Sign-in with Unusual Authentication Type](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_rare_authentication_requirement_for_principal_user) [Entra ID User Sign-in with Unusual Client](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_rare_app_id_for_principal_auth) [Entra ID User Sign-in with Unusual Non-Managed Device](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_user_signed_in_from_unusual_device) [Excessive AWS S3 Object Encryption with SSE-C](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_s3_excessive_object_encryption_with_sse_c) [External User Added to Google Workspace Group](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/initial_access_external_user_added_to_google_workspace_group) [First Occurrence GitHub Event for a Personal Access Token (PAT)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_github_new_event_action_for_pat) [First Occurrence of GitHub Repo Interaction From a New IP](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_github_repo_interaction_from_new_ip) [First Occurrence of GitHub User Interaction with Private Repo](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_github_new_repo_interaction_for_user) [First Occurrence of IP Address For GitHub Personal Access Token (PAT)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_github_new_ip_address_for_pat) [First Occurrence of IP Address For GitHub User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_github_new_ip_address_for_user) [First Occurrence of Personal Access Token (PAT) Use For a GitHub User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_github_new_pat_for_user) [First Occurrence of Private Repo Event from Specific GitHub Personal Access Token (PAT)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_github_new_repo_interaction_for_pat) [First Occurrence of User Agent For a GitHub Personal Access Token (PAT)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_github_new_user_agent_for_pat) [First Occurrence of User-Agent For a GitHub User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_github_new_user_agent_for_user) [First Time AWS CloudFormation Stack Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/execution_new_terms_cloudformation_createstack) [First Time Seen AWS Secret Value Accessed in Secrets Manager](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/credential_access_new_terms_secretsmanager_getsecretvalue) [First Time Seen Google Workspace OAuth Login from Third-Party Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/defense_evasion_google_workspace_new_oauth_login_from_third_party_application) [Forwarded Google Workspace Security Alert](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/google_workspace_alert_center_promotion) [GCP Firewall Rule Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_firewall_rule_created) [GCP Firewall Rule Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_firewall_rule_deleted) [GCP Firewall Rule Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_firewall_rule_modified) [GCP IAM Custom Role Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/initial_access_gcp_iam_custom_role_creation) [GCP IAM Role Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/impact_gcp_iam_role_deletion) [GCP IAM Service Account Key Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/persistence_gcp_iam_service_account_key_deletion) [GCP Logging Bucket Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_logging_bucket_deletion) [GCP Logging Sink Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_logging_sink_deletion) [GCP Logging Sink Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/exfiltration_gcp_logging_sink_modification) [GCP Pub/Sub Subscription Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/collection_gcp_pub_sub_subscription_creation) [GCP Pub/Sub Subscription Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_pub_sub_subscription_deletion) [GCP Pub/Sub Topic Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/collection_gcp_pub_sub_topic_creation) [GCP Pub/Sub Topic Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_pub_sub_topic_deletion) [GCP Service Account Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/persistence_gcp_service_account_created) [GCP Service Account Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/impact_gcp_service_account_deleted) [GCP Service Account Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/impact_gcp_service_account_disabled) [GCP Service Account Key Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/persistence_gcp_key_created_for_service_account) [GCP Storage Bucket Configuration Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_storage_bucket_configuration_modified) [GCP Storage Bucket Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/impact_gcp_storage_bucket_deleted) [GCP Storage Bucket Permissions Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_storage_bucket_permissions_modified) [GCP Virtual Private Cloud Network Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_virtual_private_cloud_network_deleted) [GCP Virtual Private Cloud Route Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_virtual_private_cloud_route_created) [GCP Virtual Private Cloud Route Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/defense_evasion_gcp_virtual_private_cloud_route_deleted) [GitHub Actions Unusual Bot Push to Repository](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/initial_access_github_actions_bot_first_push_to_repo) [GitHub Actions Workflow Modification Blocked](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/initial_access_github_actions_workflow_injection_blocked) [GitHub App Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/execution_github_app_deleted) [GitHub Exfiltration via High Number of Repository Clones by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/exfiltration_high_number_of_cloning_by_user) [GitHub Owner Role Granted To User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/persistence_organization_owner_role_granted) [GitHub PAT Access Revoked](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/impact_github_pat_access_revoked) [GitHub Private Repository Turned Public](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/exfiltration_github_private_repository_turned_public) [GitHub Protected Branch Settings Changed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/defense_evasion_github_protected_branch_settings_changed) [GitHub Repo Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_github_repo_created) [GitHub Repository Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/impact_github_repository_deleted) [GitHub Secret Scanning Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/defense_evasion_secret_scanning_disabled) [GitHub UEBA - Multiple Alerts from a GitHub Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/execution_github_ueba_multiple_behavior_alerts_from_account) [GitHub User Blocked From Organization](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/impact_github_user_blocked_from_organization) [Github Activity on a Private Repository from an Unusual IP](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/impact_github_repository_activity_from_unusual_ip) [Google Drive Ownership Transferred via Google Workspace](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/collection_google_drive_ownership_transferred_via_google_workspace) [Google Workspace 2SV Policy Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_2sv_policy_disabled) [Google Workspace API Access Granted via Domain-Wide Delegation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_api_access_granted_via_dwd) [Google Workspace Admin Role Assigned to a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_admin_role_assigned_to_user) [Google Workspace Admin Role Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/impact_google_workspace_admin_role_deletion) [Google Workspace Bitlocker Setting Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/defense_evasion_google_workspace_bitlocker_setting_disabled) [Google Workspace Custom Admin Role Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_custom_admin_role_created) [Google Workspace Custom Gmail Route Created or Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/collection_google_workspace_custom_gmail_route_created_or_modified) [Google Workspace Drive Encryption Key(s) Accessed from Anonymous User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/credential_access_google_workspace_drive_encryption_key_accessed_by_anonymous_user) [Google Workspace MFA Enforcement Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/impact_google_workspace_mfa_enforcement_disabled) [Google Workspace Object Copied to External Drive with App Consent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/initial_access_object_copied_to_external_drive_with_app_consent) [Google Workspace Password Policy Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_password_policy_modified) [Google Workspace Restrictions for Marketplace Modified to Allow Any App](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/defense_evasion_restrictions_for_marketplace_modified_to_allow_any_app) [Google Workspace Role Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_role_modified) [Google Workspace Suspended User Account Renewed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/initial_access_google_workspace_suspended_user_renewed) [Google Workspace User Organizational Unit Changed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_google_workspace_user_organizational_unit_changed) [High Number of Cloned GitHub Repos From PAT](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/execution_github_high_number_of_cloned_repos_from_pat) [High Number of Closed Pull Requests by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/impact_high_number_of_closed_pull_requests_by_user) [High Number of Protected Branch Force Pushes by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/impact_high_number_of_protected_branch_force_pushes_by_user) [Insecure AWS EC2 VPC Security Group Ingress Rule Added](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_vpc_security_group_ingress_rule_added_for_remote_connections) [M365 Exchange Anti-Phish Policy Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_anti_phish_policy_deletion) [M365 Exchange Anti-Phish Rule Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_anti_phish_rule_modification) [M365 Exchange DKIM Signing Configuration Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_dkim_signing_config_disabled) [M365 Exchange DLP Policy Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_dlp_policy_removed) [M365 Exchange Email Safe Attachment Rule Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_safe_attach_rule_disabled) [M365 Exchange Email Safe Link Policy Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_exchange_safelinks_disabled) [M365 Exchange Federated Domain Created or Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/privilege_escalation_exchange_new_or_modified_federation_domain) [M365 Exchange Inbox Forwarding Rule Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/collection_exchange_new_inbox_rule) [M365 Exchange Inbox Phishing Evasion Rule Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_new_inbox_rule_delete_or_move) [M365 Exchange Mail Flow Transport Rule Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/exfiltration_exchange_transport_rule_creation) [M365 Exchange Mail Flow Transport Rule Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/exfiltration_exchange_transport_rule_modification) [M365 Exchange Mailbox Accessed by Unusual Client](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/collection_exchange_mailbox_access_by_unusual_client_app_id) [M365 Exchange Mailbox Audit Logging Bypass Added](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_mailbox_audit_bypass_association) [M365 Exchange Mailbox High-Risk Permission Delegated](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/persistence_exchange_suspicious_mailbox_permission_delegation) [M365 Exchange Mailbox Items Accessed Excessively](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/collection_exchange_excessive_mail_items_accessed) [M365 Exchange Malware Filter Policy Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_malware_filter_policy_deletion) [M365 Exchange Malware Filter Rule Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_exchange_malware_filter_rule_mod) [M365 Exchange Management Group Role Assigned](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/persistence_exchange_management_role_assignment) [M365 Identity Excessive SSO Login Errors Reported](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/credential_access_entra_id_user_excessive_sso_logon_errors) [M365 Identity Global Administrator Role Assigned](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/persistence_entra_id_global_administrator_role_assign) [M365 Identity Login from Atypical Travel Location](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/initial_access_entra_id_portal_login_atypical_travel) [M365 Identity Login from Impossible Travel Location](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/initial_access_entra_id_portal_login_impossible_travel) [M365 Identity OAuth Flow by First-Party Microsoft App from Multiple IPs](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_entra_id_susp_oauth2_authorization) [M365 Identity OAuth Flow by User Sign-in to Device Registration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/credential_access_entra_id_device_reg_via_oauth_redirection) [M365 Identity OAuth Illicit Consent Grant by Rare Client and User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/initial_access_identity_illicit_consent_grant_via_registered_application) [M365 Identity OAuth Phishing via First-Party Microsoft Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/initial_access_identity_oauth_phishing_via_first_party_microsoft_application) [M365 Identity User Account Lockouts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/credential_access_identity_user_account_lockouts) [M365 Identity User Brute Force Attempted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/credential_access_entra_id_potential_user_account_brute_force) [M365 OneDrive Excessive File Downloads with OAuth Token](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/collection_onedrive_excessive_file_downloads) [M365 OneDrive Malware File Upload](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/lateral_movement_onedrive_malware_uploaded) [M365 Security Compliance Email Reported by User as Malware or Phish](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/initial_access_security_compliance_user_reported_phish_malware) [M365 Security Compliance Potential Ransomware Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/impact_security_compliance_potential_ransomware_activity) [M365 Security Compliance Unusual Volume of File Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/impact_security_compliance_unusual_volume_of_file_deletion) [M365 Security Compliance User Restricted from Sending Email](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/initial_access_security_compliance_user_restricted_from_sending_email) [M365 SharePoint Malware File Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/lateral_movement_sharepoint_malware_uploaded) [M365 Teams Custom Application Interaction Enabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_teams_custom_app_interaction_allowed) [M365 Teams External Access Enabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/defense_evasion_teams_external_access_enabled) [M365 Teams Guest Access Enabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/o365/persistence_teams_guest_access_enabled) [M365 Threat Intelligence Signal](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_defender_for_m365_threat_intelligence_signal) [M365 or Entra ID Identity Sign-in from a Suspicious Source](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/initial_access_azure_o365_with_network_alert) [MFA Deactivation with no Re-Activation for Okta User Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/persistence_mfa_deactivation_with_no_reactivation) [MFA Disabled for Google Workspace Organization](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/google_workspace/persistence_mfa_disabled_for_google_workspace_organization) [Member Removed From GitHub Organization](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/impact_github_member_removed_from_organization) [Microsoft Graph Request Email Access by Unusual User and Client](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/collection_graph_email_access_by_unusual_public_client_via_graph) [Microsoft Graph Request User Impersonation by Unusual Client](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_graph_first_occurrence_of_client_request) [Multiple Cloud Secrets Accessed by Source Address](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/credential_access_multi_could_secrets_via_api) [New GitHub App Installed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/execution_new_github_app_installed) [New GitHub Owner Added](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/persistence_github_org_owner_added) [New GitHub Personal Access Token (PAT) Added](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/persistence_new_pat_created) [New GitHub Self Hosted Action Runner](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/initial_access_github_register_self_hosted_runner) [New User Added To GitHub Organization](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_github_new_user_added_to_organization) [Potential AWS S3 Bucket Ransomware Note Uploaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_s3_bucket_object_uploaded_with_ransom_keyword) [Rare AWS Error Code](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/ml_cloudtrail_rare_error_code) [Rare Azure Activity Logs Event Failures](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/ml_azure_rare_event_failures) [Rare GCP Audit Failure Event Code](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/ml_gcp_rare_error_code) [Several Failed Protected Branch Force Pushes by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/github/impact_high_number_of_failed_protected_branch_force_pushes_by_user) [Spike in AWS Error Messages](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/ml_cloudtrail_error_message_spike) [Spike in Azure Activity Logs Failed Messages](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/ml_azure_event_failures) [Spike in GCP Audit Failed Messages](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/ml_gcp_error_message_spike) [Unusual AWS Command for a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/ml_cloudtrail_rare_method_by_user) [Unusual AWS S3 Object Encryption with SSE-C](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_s3_unusual_object_encryption_with_sse_c) [Unusual Azure Activity Logs Event for a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/ml_azure_rare_method_by_user) [Unusual City For a GCP Event](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/ml_gcp_rare_method_by_city) [Unusual City For an AWS Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/ml_cloudtrail_rare_method_by_city) [Unusual City for an Azure Activity Logs Event](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/ml_azure_rare_method_by_city) [Unusual Country For a GCP Event](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/ml_gcp_rare_method_by_country) [Unusual Country For an AWS Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/ml_cloudtrail_rare_method_by_country) [Unusual Country for an Azure Activity Logs Event](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/ml_azure_rare_method_by_country) [Unusual GCP Event for a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/gcp/ml_gcp_rare_method_by_user) 

## Container

[AWS Credentials Searched For Inside A Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_aws_creds_search_inside_container) [Cloud Credential Search Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/credential_access_cloud_creds_search_inside_a_container) [Container Management Utility Execution Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_container_management_binary_launched_inside_a_container) [Container Management Utility Run Inside A Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_container_management_binary_launched_inside_container) [Container Workload Protection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/container_workload_protection) [Curl SOCKS Proxy Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/command_and_control_curl_socks_proxy_detected_inside_container) [DNS Enumeration Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_dns_enumeration) [DebugFS Execution Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/privilege_escalation_debugfs_launched_inside_a_privileged_container) [Direct Interactive Kubernetes API Request Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_direct_interactive_kubernetes_api_request) [Direct Interactive Kubernetes API Request by Common Utilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_d4c_k8s_mda_direct_interactive_kubernetes_api_request_by_usual_utilities) [Direct Interactive Kubernetes API Request by Unusual Utilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_d4c_k8s_mda_kubernetes_api_activity_by_unusual_utilities) [Dynamic Linker Modification Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/defense_evasion_ld_preload_shared_object_modified_inside_a_container) [Encoded Payload Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/defense_evasion_potential_evasion_via_encoded_payload) [Environment Variable Enumeration Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_environment_enumeration) [File Creation and Execution Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_interactive_file_creation_followed_by_execution) [File Download Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/command_and_control_interactive_file_download_from_internet) [File Execution Permission Modification Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_suspicious_file_made_executable_via_chmod_inside_a_container) [File System Debugger Launched Inside a Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_debugfs_launched_inside_container) [Forbidden Direct Interactive Kubernetes API Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_d4c_k8s_mda_forbidden_direct_interactive_kubernetes_api_request) [Interactive Exec Into Container Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_interactive_exec_to_container) [Interactive Privilege Boundary Enumeration Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_privilege_boundary_enumeration_from_interactive_process) [Interactive Shell Launched via Unusual Parent Process in a Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_unusual_interactive_process_inside_container) [Interactive Shell Spawn Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_interactive_shell_spawned_from_inside_a_container) [Kubectl Configuration Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_kubectl_configuration_discovery) [Kubectl Workload and Cluster Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_kubectl_workload_and_cluster_discovery) [Kubelet Certificate File Access Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_kubelet_certificate_file_access) [Kubelet Pod Discovery Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_kubelet_pod_discovery_via_builtin_utilities) [Mount Execution Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/privilege_escalation_mount_launched_inside_a_privileged_container) [Mount Launched Inside a Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_mount_launched_inside_container) [Netcat File Transfer or Listener Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_netcat_listener_established_inside_a_container) [Potential Cluster Enumeration via jq Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_potential_cluster_enumeration_via_jq) [Potential Direct Kubelet Access via Process Arguments Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_potential_direct_kubelet_access_via_process_args) [Potential Kubeletctl Execution Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_kubeletctl_execution) [Potential notify_on_release Container Escape Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/privilege_escalation_potential_container_escape_via_modified_notify_on_release_file) [Potential release_agent Container Escape Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/privilege_escalation_potential_container_escape_via_modified_release_agent_file) [SSH Authorized Key File Activity Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/persistence_ssh_authorized_keys_modification_inside_a_container) [Sensitive File Compression Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/credential_access_collection_sensitive_files_compression_inside_a_container) [Sensitive Files Compression Inside A Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_collection_sensitive_files_compression_inside_container) [Sensitive Keys Or Passwords Search Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/credential_access_sensitive_keys_or_passwords_search_inside_a_container) [Sensitive Keys Or Passwords Searched For Inside A Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_sensitive_keys_or_passwords_search_inside_container) [Service Account Namespace Read Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_service_account_namespace_read) [Service Account Token or Certificate Access Followed by Kubernetes API Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_d4c_k8s_mda_service_account_token_access_followed_by_kubernetes_api_request) [Service Account Token or Certificate Read Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/credential_access_service_account_token_or_cert_read) [Shell Command-Line History Deletion Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/defense_evasion_deletion_of_shell_cmdline_history) [Suspicious File Made Executable via Chmod Inside A Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_file_made_executable_via_chmod_inside_container) [Suspicious Interactive Process Execution Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/defense_evasion_interactive_process_execution_from_suspicious_directory) [Suspicious Interpreter Execution Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_suspicious_interactive_interpreter_command_execution) [Suspicious Network Tool Launch Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_suspicious_network_tool_launched_inside_a_container) [Suspicious Network Tool Launched Inside A Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_suspicious_network_tool_launched_inside_container) [System Path File Creation and Execution Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_interactive_file_creation_in_system_binary_locations) [Tool Enumeration Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/discovery_tool_enumeration) [Tool Installation Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/execution_tool_installation) [Web Server Child Shell Spawn Detected via Defend for Containers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/persistence_suspicious_webserver_child_process_execution) 

## Email

[Elastic Defend and Email Alerts Correlation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_email_elastic_defend_correlation) 

## Endpoint

[A scheduled task was created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_scheduled_task_creation_winlog) [APT Package Manager Configuration File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_apt_package_manager_file_creation) [AWS CLI Command with Custom Endpoint URL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_aws_cli_endpoint_url_used) [AWS SSM `SendCommand` with Run Shell Command Parameters](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_aws_ssm_sendcommand_with_command_parameters) [Abnormal Process ID or Lock File Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_abnormal_process_id_file_created) [Accepted Default Telnet Port Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_accepted_default_telnet_port_connection) [Access Control List Modification via setfacl](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_acl_modification_via_setfacl) [Access to a Sensitive LDAP Attribute](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_ldap_attributes) [Accessing Outlook Data Files](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/collection_outlook_email_archive) [Account Configured with Never-Expiring Password](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_dontexpirepasswd_account) [Account Discovery Command via SYSTEM Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_command_system_account) [Account Password Reset Remotely](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_remote_password_reset) [Account or Group Discovery via Built-In Tools](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_of_accounts_or_groups_via_builtin_tools) [Active Directory Discovery using AdExplorer](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_ad_explorer_execution) [Active Directory Forced Authentication from Linux Host - SMB Named Pipes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/credential_access_forced_authentication_pipes) [Active Directory Group Modification by SYSTEM](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_group_modification_by_system) [AdFind Command Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_adfind_command_activity) [Adding Hidden File Attribute via Attrib](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_adding_the_hidden_file_attribute_with_via_attribexe) [AdminSDHolder Backdoor](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_ad_adminsdholder) [AdminSDHolder SDProp Exclusion Added](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_sdprop_exclusion_dsheuristics) [Adobe Hijack Persistence](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_adobe_hijack_persistence) [Alternate Data Stream Creation/Execution at Volume Root Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_root_dir_ads_creation) [Anomalous Linux Compiler Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/resource_development_ml_linux_anomalous_compiler_activity) [Anomalous Process For a Linux Population](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/persistence_ml_linux_anomalous_process_all_hosts) [Anomalous Process For a Windows Population](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/persistence_ml_windows_anomalous_process_all_hosts) [Anomalous Windows Process Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/persistence_ml_windows_anomalous_process_creation) [Apple Script Execution followed by Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/execution_scripting_osascript_exec_followed_by_netcon) [Apple Scripting Execution with Administrator Privileges](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/privilege_escalation_applescript_with_admin_privs) [Archive File with Unusual Extension](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_collection_masquerading_unusual_archive_file_extension) [At Job Created or Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_at_job_creation) [At.exe Command Lateral Movement](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/lateral_movement_at) [Attempt to Clear Kernel Ring Buffer](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_clear_kernel_ring_buffer) [Attempt to Clear Logs via Journalctl](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_journalctl_clear_logs) [Attempt to Disable Auditd Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_attempt_to_disable_auditd_service) [Attempt to Disable Gatekeeper](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_attempt_to_disable_gatekeeper) [Attempt to Disable IPTables or Firewall](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_attempt_to_disable_iptables_or_firewall) [Attempt to Disable Syslog Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_attempt_to_disable_syslog_service) [Attempt to Enable the Root Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_enable_root_account) [Attempt to Establish VScode Remote Tunnel](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_tunnel_vscode) [Attempt to Install Kali Linux via WSL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_wsl_kalilinux) [Attempt to Install Root Certificate](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_install_root_certificate) [Attempt to Mount SMB Share via Command Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/lateral_movement_mounting_smb_share) [Attempt to Unload Elastic Endpoint Security Kernel Extension](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_unload_endpointsecurity_kext) [Attempted Private Key Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/credential_access_win_private_key_access) [Authentication via Unusual PAM Grantor](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_unusual_pam_grantor) [Authorization Plugin Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_credential_access_authorization_plugin_creation) [BPF filter applied using TC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_tc_bpf_filter) [Backup Deletion with Wbadmin](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_deleting_backup_catalogs_with_wbadmin) [Base16 or Base32 Encoding/Decoding Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_base16_or_base32_encoding_or_decoding_activity) [Base64 Decoded Payload Piped to Interpreter](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_interpreter_launched_from_decoded_payload) [Bash Shell Profile Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/persistence_shell_profile_modification) [Binary Content Copy via Cmd.exe](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_cmd_copy_binary_contents) [Binary Executed from Shared Memory Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_process_started_in_shared_memory_directory) [Bitsadmin Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/command_and_control_bitsadmin_activity) [Boot File Copy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_boot_file_copy) [Browser Extension Install](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_browser_extension_install) [Browser Process Spawned from an Unusual Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_browsers_unusual_parent) [Bypass UAC via Event Viewer](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_uac_bypass_event_viewer) [Chkconfig Service Add](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_chkconfig_service_add) [Clearing Windows Console History](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_clearing_windows_console_history) [Clearing Windows Event Logs](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_clearing_windows_event_logs) [Cobalt Strike Command and Control Beacon](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_cobalt_strike_beacon) [Code Signing Policy Modification Through Built-in tools](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_code_signing_policy_modification_builtin_tools) [Code Signing Policy Modification Through Registry](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_code_signing_policy_modification_registry) [Command Execution via ForFiles](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_indirect_exec_forfiles) [Command Execution via SolarWinds Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_apt_solarwinds_backdoor_child_cmd_powershell) [Command Line Obfuscation via Whitespace Padding](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_whitespace_padding_command_line) [Command Obfuscation via Unicode Modifier Letters](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_obf_args_unicode_modified_letters) [Command Prompt Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_command_prompt_connecting_to_the_internet) [Command Shell Activity Started via RunDLL32](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_command_shell_via_rundll32) [Command and Scripting Interpreter via Windows Scripts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_powershell_susp_args_via_winscript) [Component Object Model Hijacking](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_suspicious_com_hijack_registry) [Compression DLL Loaded by Unusual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/collection_archive_data_zip_imageload) [Conhost Spawned By Suspicious Parent Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_via_hidden_shell_conhost) [Connection to Common Large Language Model Endpoints](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_common_llm_endpoint) [Connection to Commonly Abused Free SSL Certificate Providers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_encrypted_channel_freesslcert) [Connection to Commonly Abused Web Services](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_common_webservices) [Connection to External Network via Telnet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/lateral_movement_telnet_network_activity_external) [Connection to Internal Network via Telnet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/lateral_movement_telnet_network_activity_internal) [Control Panel Process with Unusual Arguments](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_control_panel_suspicious_args) [Creation of Hidden Files and Directories via CommandLine](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_hidden_file_dir_tmp) [Creation of Hidden Launch Agent or Daemon](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_evasion_hidden_launch_agent_deamon_creation) [Creation of Hidden Login Item via Apple Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_creation_hidden_login_item_osascript) [Creation of Hidden Shared Object File](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_hidden_shared_object) [Creation of SettingContent-ms Files](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_settingcontent_ms_file_creation) [Creation of a DNS-Named Record](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dnsnode_creation) [Creation of a Hidden Local User Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_evasion_hidden_local_account_creation) [Creation or Modification of Domain Backup DPAPI private key](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_domain_backup_dpapi_private_keys) [Creation or Modification of Root Certificate](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_create_mod_root_certificate) [Creation or Modification of a new GPO Scheduled Task or Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_gpo_schtask_service_creation) [Credential Access via TruffleHog Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/credential_access_trufflehog_execution) [Credential Acquisition via Registry Hive Dumping](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dump_registry_hives) [Cron Job Created or Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_cron_job_creation) [Cupsd or Foomatic-rip Shell Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_cupsd_foomatic_rip_shell_execution) [Curl Execution via Shell Profile](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_curl_execution_via_shell_profile) [Curl SOCKS Proxy Activity from Unusual Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_curl_socks_proxy_detected) [Curl or Wget Egress Network Connection via LoLBin](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_curl_or_wget_executed_via_lolbin) [Curl or Wget Spawned via Node.js](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_curl_wget_spawn_via_nodejs_parent) [D-Bus Service Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_dbus_service_creation) [DNF Package Manager Plugin File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_dnf_package_manager_plugin_file_creation) [DNS Global Query Block List Modified or Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_reg_disable_enableglobalqueryblocklist) [DNS Request for IP Lookup Service via Unsigned Binary](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/discovery_dns_request_for_ip_lookup_service) [DNS-over-HTTPS Enabled via Registry](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_dns_over_https_enabled) [DPKG Package Installed by Unusual Parent Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_dpkg_package_installation_from_unusual_parent) [Default Cobalt Strike Team Server Certificate](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_cobalt_strike_default_teamserver_cert) [Delayed Execution via Ping](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_delayed_via_ping_lolbas_unsigned) [Delegated Managed Service Account Modification by an Unusual User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_badsuccessor_dmsa_abuse) [Delete Volume USN Journal with Fsutil](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_delete_volume_usn_journal_with_fsutil) [Deprecated - EggShell Backdoor Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_pentest_eggshell_remote_admin_tool) [Deprecated - Sudo Heap-Based Buffer Overflow Attempt](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/privilege_escalation_sudo_buffer_overflow) [Detection Alert on a Process Exhibiting CPU Spike](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/impact_alert_from_a_process_with_cpu_spike) [Directory Creation in /bin directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_directory_creation_in_bin) [Disable Windows Event and Security Logs Using Built-in Tools](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_disabling_windows_logs) [Disable Windows Firewall Rules via Netsh](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_disable_windows_firewall_rules_with_netsh) [Disabling Lsa Protection via Registry Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_lsass_ppl_disabled_registry) [Disabling User Account Control via Registry Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_disable_uac_registry) [Disabling Windows Defender Security Settings via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_disabling_windows_defender_powershell) [Discovery Command Output Written to Suspicious File](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/collection_discovery_output_written_to_suspicious_file) [Discovery of Domain Groups](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_of_domain_groups) [Discovery of Internet Capabilities via Built-in Tools](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_internet_capabilities) [Docker Release File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_docker_release_file_creation) [Docker Socket Enumeration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_docker_socket_discovery) [Downloaded Shortcut Files](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_downloaded_shortcut_files) [Downloaded URL Files](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_downloaded_url_file) [Dracut Module Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_dracut_module_creation) [Dumping Account Hashes via Built-In Commands](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_dumping_hashes_bi_cmds) [Dumping of Keychain Content via Security Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_dumping_keychain_security) [Dylib Injection via Process Environment Variables](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_dylib_injection_via_env_vars) [Dynamic IEX Reconstruction via Method String Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_iex_string_reconstruction) [Dynamic Linker (ld.so) Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_ld_so_creation) [Dynamic Linker Copy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_dynamic_linker_backup) [Dynamic Linker Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_dynamic_linker_file_creation) [ESXI Discovery via Find](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_esxi_software_via_find) [ESXI Discovery via Grep](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_esxi_software_via_grep) [ESXI Timestomping using Touch Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_esxi_suspicious_timestomp_touch) [Egress Connection from Entrypoint in Container](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_egress_connection_from_entrypoint_in_container) [Elastic Agent Service Terminated](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_elastic_agent_service_terminated) [Emond Rules Creation or Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_emond_rules_file_creation) [Enable Host Network Discovery via Netsh](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_enable_network_discovery_with_netsh) [Encoded Executable Stored in the Registry](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_hide_encoded_executable_registry) [Encrypting Files with WinRar or 7z](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_winrar_encryption) [Enumerating Domain Trusts via DSQUERY.EXE](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_enumerating_domain_trusts_via_dsquery) [Enumerating Domain Trusts via NLTEST.EXE](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_enumerating_domain_trusts_via_nltest) [Enumeration Command Spawned via WMIPrvSE](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_enumeration_via_wmiprvse) [Enumeration of Administrator Accounts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_admin_recon) [Enumeration of Privileged Local Groups Membership](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_privileged_localgroup_membership) [Enumeration of Users or Groups via Built-in Commands](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/discovery_users_domain_built_in_commands) [Exchange Mailbox Export via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_mailbox_export_winlog) [Executable Bit Set for Potential Persistence Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_potential_persistence_script_executable_bit_set) [Executable File Creation with Multiple Extensions](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_file_creation_mult_extension) [Executable File Download via Wget](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_executable_download_via_wget) [Executable File with Unusual Extension](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_masquerading_unusual_exe_file_extension) [Executable Masquerading as Kernel Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_kthreadd_masquerading) [Execution from Unusual Directory - Command Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_from_unusual_path_cmdline) [Execution from a Removable Media with Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_execution_from_removable_media) [Execution of COM object via Xwizard](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_com_object_xwizard) [Execution of File Written or Modified by Microsoft Office](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_ms_office_written_file) [Execution of Persistent Suspicious Program](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_runtime_run_key_startup_susp_procs) [Execution of a Downloaded Windows Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_windows_script_from_internet) [Execution of an Unsigned Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_unsigned_service_executable) [Execution via Electron Child Process Node.js Module](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/execution_defense_evasion_electron_app_childproc_node_js) [Execution via GitHub Actions Runner](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_via_github_actions_runner) [Execution via MS VisualStudio Pre/Post Build Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_execution_via_visualstudio_prebuildevent) [Execution via MSSQL xp_cmdshell Stored Procedure](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_xp_cmdshell_mssql_stored_procedure) [Execution via Microsoft DotNet ClickOnce Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_dotnet_clickonce_dfsvc_netcon) [Execution via OpenClaw Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_openclaw_agent_child_process) [Execution via TSClient Mountpoint](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_execution_from_tsclient_mup) [Execution via Windows Command Debugging Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_lolbas_win_cdb_utility) [Execution via Windows Subsystem for Linux](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_wsl_child_process) [Execution via local SxS Shared Module](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_shared_modules_local_sxs_dll) [Execution with Explicit Credentials via Scripting](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/privilege_escalation_explicit_creds_via_scripting) [Expired or Revoked Driver Loaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_expired_driver_loaded) [Exporting Exchange Mailbox via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_email_powershell_exchange_mailbox) [External IP Address Discovery via Curl](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/discovery_external_ip_address_discovery_via_curl) [External IP Lookup from Non-Browser Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_post_exploitation_external_ip_lookup) [File Compressed or Archived into Common Format by Unsigned Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/collection_common_compressed_archived_file) [File Creation Time Changed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_timestomp_sysmon) [File Creation by Cups or Foomatic-rip Child](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_cupsd_foomatic_rip_file_creation) [File Creation in /var/log via Suspicious Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_var_log_file_creation_by_unsual_process) [File Creation, Execution and Self-Deletion in Suspicious Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_file_execution_followed_by_deletion) [File Deletion via Shred](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_file_deletion_via_shred) [File Permission Modification in Writable Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_file_mod_writable_dir) [File Staged in Root Folder of Recycle Bin](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/collection_files_staged_in_recycle_bin_root) [File Transfer Utility Launched from Unusual Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/exfiltration_unusual_file_transfer_utility_launched) [File Transfer or Listener Established via Netcat](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_file_transfer_or_listener_established_via_netcat) [File and Directory Permissions Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_file_permission_modification) [File made Immutable by Chattr](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_chattr_immutable_file) [File or Directory Deletion Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_generic_deletion) [File with Right-to-Left Override Character (RTLO) Created/Executed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_right_to_left_override) [File with Suspicious Extension Downloaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_download_susp_extension) [Finder Sync Plugin Registered and Enabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_finder_sync_plugin_pluginkit) [First Time Seen Commonly Abused Remote Access Tool Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_new_terms_commonly_abused_rat_execution) [First Time Seen Driver Loaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_driver_newterm_imphash) [First Time Seen NewCredentials Logon Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_newcreds_logon_rare_process) [First Time Seen Removable Device](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_exfiltration_first_time_seen_usb) [FirstTime Seen Account Performing DCSync](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dcsync_newterm_subjectuser) [Full Disk Access Permission Check](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/discovery_full_disk_access_check) [Full User-Mode Dumps Enabled System-Wide](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_generic_localdumps) [GRUB Configuration File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_grub_configuration_creation) [GRUB Configuration Generation through Built-in Utilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_grub_makeconfig) [Gatekeeper Override and Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_gatekeeper_override_and_execution) [GenAI Process Accessing Sensitive Files](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/credential_access_genai_process_sensitive_file_access) [GenAI Process Compiling or Generating Executables](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_genai_process_compiling_executables) [GenAI Process Connection to Suspicious Top Level Domain](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_genai_process_suspicious_tld_connection) [GenAI Process Connection to Unusual Domain](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_genai_process_unusual_domain) [GenAI Process Performing Encoding/Chunking Prior to Network Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_genai_process_encoding_prior_to_network_activity) [GenAI or MCP Server Child Process Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_mcp_server_child_process) [Git Hook Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_git_hook_process_execution) [Git Hook Command Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_git_hook_execution) [Git Hook Created or Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_git_hook_file_creation) [Git Hook Egress Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_git_hook_netcon) [Git Repository or File Download to Suspicious Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_git_repo_or_file_download_to_sus_dir) [GitHub Authentication Token Access via Node.js](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_gh_auth_via_nodejs) [Google Calendar C2 via Script Interpreter](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_google_calendar_c2_via_script) [Group Policy Abuse for Privilege Addition](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_group_policy_privileged_groups) [Group Policy Discovery via Microsoft GPResult Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_group_policy_object_discovery) [Halfbaked Command and Control Beacon](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_halfbaked_beacon) [Hidden Directory Creation via Unusual Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_hidden_directory_creation) [Hidden Files and Directories via Hidden Flag](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_creation_of_hidden_files_directories) [High Number of Egress Network Connections from Unusual Executable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_frequent_egress_netcon_from_sus_executable) [High Number of Process Terminations](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/impact_process_kill_threshold) [High Number of Process and/or Service Terminations](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_stop_process_service_threshold) [Host File System Changes via Windows Subsystem for Linux](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_wsl_filesystem) [Hosts File Modified](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/impact_hosts_file_modified) [Hping Process Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_linux_hping_activity) [IIS HTTP Logging Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_iis_httplogging_disabled) [IPSEC NAT Traversal Port Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_nat_traversal_port_activity) [IPv4/IPv6 Forwarding Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_ip_forwarding_activity) [Image File Execution Options Injection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_evasion_registry_ifeo_injection) [Image Loaded with Invalid Signature](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_invalid_codesign_imageload) [ImageLoad via Windows Update Auto Update Client](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_lolbas_wuauclt) [Inbound Connection to an Unsecure Elasticsearch Node](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_unsecure_elasticsearch_node) [Incoming DCOM Lateral Movement via MSHTA](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_dcom_hta) [Incoming DCOM Lateral Movement with MMC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_dcom_mmc20) [Incoming DCOM Lateral Movement with ShellBrowserWindow or ShellWindows](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_dcom_shellwindow_shellbrowserwindow) [Incoming Execution via PowerShell Remoting](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_powershell_remoting_target) [Incoming Execution via WinRM Remote Shell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_incoming_winrm_shell_execution) [Indirect Command Execution via Forfiles/Pcalua](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_indirect_command_exec_pcalua_forfiles) [Ingress Transfer via Windows BITS](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_ingress_transfer_bits) [Initial Access via File Upload Followed by GET Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/initial_access_file_upload_followed_by_get_request) [Initramfs Extraction via CPIO](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_extract_initramfs_via_cpio) [Initramfs Unpacking via unmkinitramfs](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_unpack_initramfs_via_unmkinitramfs) [InstallUtil Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_installutil_command_activity) [InstallUtil Process Making Network Connections](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_installutil_beacon) [Installation of Custom Shim Databases](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_app_compat_shim) [Installation of Security Support Provider](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_lsa_security_support_provider_registry) [Interactive Logon by an Unusual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_make_token_local) [Interactive Terminal Spawned via Perl](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_perl_tty_shell) [Interactive Terminal Spawned via Python](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_python_tty_shell) [KDE AutoStart Script or Desktop File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_kde_autostart_modification) [KRBTGT Delegation Backdoor](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_msds_alloweddelegateto_krbtgt) [Kerberos Cached Credentials Dumping](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_kerberosdump_kcc) [Kerberos Pre-authentication Disabled for User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_disable_kerberos_preauth) [Kerberos Traffic from Unusual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_kerberoasting_unusual_process) [Kernel Driver Load](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_kernel_driver_load) [Kernel Driver Load by non-root User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_kernel_driver_load_by_non_root) [Kernel Load or Unload via Kexec Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_load_and_unload_of_kernel_via_kexec) [Kernel Module Load via insmod](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_insmod_kernel_module_load) [Kernel Module Removal](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_kernel_module_removal) [Kernel Object File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_kernel_object_file_creation) [Kernel Seeking Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_kernel_seeking) [Kernel Unpacking Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_kernel_unpacking) [Keychain CommandLine Interaction via Unsigned or Untrusted Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_credentials_keychains) [Keychain Password Retrieval via Command Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_keychain_pwd_retrieval_security_cmd) [Kill Command Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_kill_command_executed) [Kirbi File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_kirbi_file) [Kubeconfig File Creation or Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/lateral_movement_kubeconfig_file_activity) [Kubeconfig File Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_kubeconfig_file_discovery) [Kubectl Apply Pod from URL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_kubectl_apply_pod_from_url) [Kubectl Network Configuration Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_kubectl_networking_modification) [Kubectl Permission Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_kubectl_permission_discovery) [Kubernetes Direct API Request via Curl or Wget](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_kubernetes_direct_api_request_via_curl_or_wget) [Kubernetes Sensitive Configuration File Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_kubernetes_sensitive_file_activity) [Kubernetes Service Account Secret Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_kubernetes_service_account_secret_access) [LLM-Based Attack Chain Triage by Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_llm_attack_chain_triage_by_host) [LSASS Memory Dump Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_lsass_memdump_file_created) [LSASS Memory Dump Handle Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_lsass_memdump_handle_access) [LSASS Process Access via Windows API](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_lsass_openprocess_api) [Lateral Movement via Startup Folder](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_via_startup_folder_rdp_smb) [Launch Service Creation and Immediate Loading](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_creation_change_launch_agents_file) [Linux Audio Recording Activity Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/collection_potential_audio_recording_activity) [Linux Clipboard Activity Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/collection_linux_clipboard_activity) [Linux Group Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_linux_group_creation) [Linux Process Hooking via GDB](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_gdb_process_hooking) [Linux Restricted Shell Breakout via Linux Binary(s)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_evasion_linux_binary) [Linux SSH X11 Forwarding](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_linux_ssh_x11_forwarding) [Linux System Information Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_linux_system_information_discovery) [Linux System Information Discovery via Getconf](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_getconf_execution) [Linux Telegram API Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_telegram_api_request) [Linux User Account Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_linux_user_account_creation) [Linux User Account Credential Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_user_credential_modification_via_echo) [Linux User Added to Privileged Group](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_linux_user_added_to_privileged_group) [Linux User or Group Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_user_or_group_deletion) [Linux Video Recording or Screenshot Activity Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/collection_potential_video_recording_or_screenshot_activity) [Linux init (PID 1) Secret Dump via GDB](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_gdb_init_process_hooking) [Loadable Kernel Module Configuration File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_lkm_configuration_file_creation) [Local Account TokenFilter Policy Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_persistence_account_tokenfilterpolicy) [Local Scheduled Task Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_local_scheduled_task_creation) [MS Office Macro Security Registry Modifications](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_ms_office_suspicious_regmod) [Manual Dracut Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_manual_dracut_execution) [Manual Loading of a Suspicious Chromium Extension](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_manual_chromium_extension_loading) [Manual Memory Dumping via Proc Filesystem](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_manual_memory_dumping) [Manual Mount Discovery via /etc/exports or /etc/fstab](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_manual_mount_discovery_via_exports_or_fstab) [Masquerading Space After Filename](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_masquerading_space_after_filename) [Memory Dump File with Unusual Extension](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/credential_access_mdmp_file_unusual_extension) [Memory Swap Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/impact_memory_swap_modification) [Message-of-the-Day (MOTD) File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_message_of_the_day_creation) [Microsoft Build Engine Started an Unusual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_msbuild_started_unusal_process) [Microsoft Build Engine Started by a Script Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_msbuild_started_by_script) [Microsoft Build Engine Started by a System Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_msbuild_started_by_system_process) [Microsoft Build Engine Started by an Office Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_msbuild_started_by_office_app) [Microsoft Build Engine Using an Alternate Name](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_msbuild_started_renamed) [Microsoft Exchange Server UM Spawning Suspicious Processes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_suspicious_ms_exchange_process) [Microsoft Exchange Server UM Writing Suspicious Files](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_suspicious_ms_exchange_files) [Microsoft Exchange Transport Agent Install Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_transport_agent_exchange) [Microsoft Exchange Worker Spawning Suspicious Processes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_suspicious_ms_exchange_worker_child_process) [Microsoft IIS Connection Strings Decryption](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_iis_connectionstrings_dumping) [Microsoft IIS Service Account Password Dumped](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/credential_access_iis_apppoolsa_pwd_appcmd) [Microsoft Management Console File from Unusual Path](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_via_mmc_console_file_unusual_path) [Microsoft Windows Defender Tampering](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_microsoft_defender_tampering) [Mimikatz Memssp Log File Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_mimikatz_memssp_default_logs) [Modification of AmsiEnable Registry Key](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_amsienable_key_mod) [Modification of Boot Configuration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_modification_of_boot_config) [Modification of Dynamic Linker Preload Shared Object](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_ld_preload_shared_object_modif) [Modification of Environment Variable via Unsigned or Untrusted Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_modify_environment_launchctl) [Modification of Safari Settings via Defaults Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_safari_config_change) [Modification of WDigest Security Provider](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_mod_wdigest_security_provider) [Modification of the msPKIAccountCredentials](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_credroaming_ldap) [Mofcomp Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_mofcomp) [Mounting Hidden or WebDav Remote Shares](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_mount_hidden_or_webdav_share_net) [MsBuild Making Network Connections](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_msbuild_making_network_connections) [Mshta Making Network Connections](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_mshta_beacon) [MsiExec Service Child Process With Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_msiexec_child_proc_netcon) [Multi-Base64 Decoding Attempt from Suspicious Location](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_multi_base64_decoding_attempt) [Multiple Alerts on a Host Exhibiting CPU Spike](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/impact_alerts_on_host_with_cpu_spike) [Multiple External EDR Alerts by Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_external_edr_alerts_by_host) [Multiple Logon Failure Followed by Logon Success](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_bruteforce_multiple_logon_failure_followed_by_success) [Multiple Logon Failure from the same Source Address](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_bruteforce_multiple_logon_failure_same_srcip) [Multiple Vault Web Credentials Read](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_saved_creds_vault_winlog) [NTDS Dump via Wbadmin](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_wbadmin_ntds) [NTDS or SAM Database File Copied](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_copy_ntds_sam_volshadowcp_cmdline) [Namespace Manipulation Using Unshare](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_unshare_namespace_manipulation) [NetSupport Manager Execution from an Unusual Path](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_rmm_netsupport_susp_path) [Netcat Listener Established via rlwrap](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_nc_listener_via_rlwrap) [Netsh Helper DLL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_netsh_helper_dll) [Network Activity Detected via Kworker](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_linux_kworker_netcon) [Network Activity Detected via cat](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_cat_network_activity) [Network Activity to a Suspicious Top Level Domain](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_dns_susp_tld) [Network Connection Initiated by Suspicious SSHD Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_ssh_netcon) [Network Connection by Cups or Foomatic-rip Child](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_cupsd_foomatic_rip_netcon) [Network Connection from Binary with RWX Memory Region](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_netcon_from_rwx_mem_region_binary) [Network Connection to OAST Domain via Script Interpreter](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_network_connection_to_oast_domain) [Network Connection via Certutil](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/command_and_control_certutil_network_connection) [Network Connection via Compiled HTML File](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_html_help_executable_program_connecting_to_the_internet) [Network Connection via MsXsl](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_msxsl_network) [Network Connection via Recently Compiled Executable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_network_event_post_compilation) [Network Connection via Registration Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_register_server_program_connecting_to_the_internet) [Network Connection via Signed Binary](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_misc_lolbin_connecting_to_the_internet) [Network Connections Initiated Through XDG Autostart Entry](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_xdg_autostart_netcon) [Network Logon Provider Registry Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_persistence_network_logon_provider_modification) [Network Traffic Capture via CAP_NET_RAW](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_capnetraw_capability) [Network-Level Authentication (NLA) Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_disable_nla) [NetworkManager Dispatcher Script Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_network_manager_dispatcher_persistence) [New ActiveSyncAllowedDeviceID Added via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_powershell_exch_mailbox_activesync_add_device) [New USB Storage Device Mounted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/initial_access_exfiltration_new_usb_device_mounted) [Newly Observed Process Exhibiting High CPU Usage](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/impact_newly_observed_process_with_high_cpu) [Node.js Pre or Post-Install Script Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_nodejs_pre_or_post_install_script_execution) [Nping Process Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_linux_nping_activity) [NullSessionPipe Registry Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_defense_evasion_lanman_nullsessionpipe_modification) [Office Test Registry Persistence](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_msoffice_startup_registry) [Ollama API Accessed from External Network](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/initial_access_ollama_api_external_access) [Ollama DNS Query to Untrusted Domain](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/command_and_control_ollama_model_download_untrusted_source) [OpenSSL Password Hash Generation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_openssl_passwd_hash_generation) [Openssl Client or Server Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_openssl_client_or_server) [Outbound Scheduled Task Activity via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_scheduled_task_powershell_source) [Outlook Home Page Registry Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_outlook_home_page) [PANW and Elastic Defend - Command and Control Correlation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_pan_elastic_defend_c2) [Parent Process Detected with Suspicious Windows Process(es)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_suspicious_windows_process_cluster_from_parent_process) [Parent Process PID Spoofing](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_parent_process_pid_spoofing) [Pbpaste Execution via Unusual Parent Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/collection_pbpaste_execution_via_unusual_parent) [Peripheral Device Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_peripheral_device) [Perl Outbound Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_perl_outbound_network_connection) [Persistence via BITS Job Notify Cmdline](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_bits_job_notify_command) [Persistence via DirectoryService Plugin Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_directory_services_plugins_modification) [Persistence via Docker Shortcut Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_docker_shortcuts_plist_modification) [Persistence via Folder Action Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_folder_action_scripts_runtime) [Persistence via Hidden Run Key Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_hidden_run_key_valuename) [Persistence via Login or Logout Hook](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_login_logout_hooks_defaults) [Persistence via Microsoft Office AddIns](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_ms_office_addins_file) [Persistence via Microsoft Outlook VBA](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_ms_outlook_vba_template) [Persistence via PowerShell profile](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_powershell_profiles) [Persistence via Scheduled Job Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_local_scheduled_job_creation) [Persistence via Suspicious Launch Agent or Launch Daemon](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_suspicious_launch_agent_or_launch_daemon) [Persistence via TelemetryController Scheduled Task Hijack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_telemetrycontroller_scheduledtask_hijack) [Persistence via Update Orchestrator Service Hijack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_update_orchestrator_service_hijack) [Persistence via WMI Event Subscription](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_windows_management_instrumentation_event_subscription) [Persistence via WMI Standard Registry Provider](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_wmi_stdregprov_run_services) [Persistence via a Hidden Plist Filename](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_hidden_plist_filename) [Persistence via a Windows Installer](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_msi_installer_task_startup) [Persistent Scripts in the Startup Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_startup_folder_scripts) [Pluggable Authentication Module (PAM) Creation in Unusual Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_pluggable_authentication_module_creation_in_unusual_dir) [Pluggable Authentication Module (PAM) Source Download](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_pluggable_authentication_module_source_download) [Pluggable Authentication Module (PAM) Version Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_pam_version_discovery) [Pluggable Authentication Module or Configuration Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_pluggable_authentication_module_creation) [Pod or Container Creation with Suspicious Command-Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_suspicious_pod_or_container_creation_command_execution) [Polkit Policy Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_polkit_policy_creation) [Polkit Version Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_polkit_version_discovery) [Port Forwarding Rule Addition](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_port_forwarding_added_registry) [Possible FIN7 DGA Command and Control Behavior](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_fin7_c2_behavior) [Potential ADIDNS Poisoning via Wildcard Record Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_adidns_wildcard) [Potential Active Directory Replication Account Backdoor](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dcsync_user_backdoor) [Potential Admin Group Account Addition](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/privilege_escalation_local_user_added_to_admin) [Potential Antimalware Scan Interface Bypass via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_amsi_bypass_powershell) [Potential Application Shimming via Sdbinst](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_via_application_shimming) [Potential Backdoor Execution Through PAM_EXEC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_pluggable_authentication_module_pam_exec_backdoor_exec) [Potential Buffer Overflow Attack Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_potential_bufferoverflow_attack) [Potential CVE-2025-32463 Nsswitch File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_cve_2025_32463_nsswitch_file_creation) [Potential CVE-2025-32463 Sudo Chroot Execution Attempt](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_cve_2025_32463_sudo_chroot_execution) [Potential CVE-2025-33053 Exploitation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_url_cve_2025_33053) [Potential CVE-2025-41244 vmtoolsd LPE Exploitation Attempt](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_cve_2025_41244_vmtoolsd_lpe) [Potential Chroot Container Escape via Mount](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_docker_mount_chroot_container_escape) [Potential Code Execution via Postgresql](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_remote_code_execution_via_postgresql) [Potential Command Shell via NetCat](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_revshell_cmd_via_netcat) [Potential Command and Control via Internet Explorer](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_iexplore_via_com) [Potential Computer Account NTLM Relay Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dollar_account_relay) [Potential Cookies Theft via Browser Debugging](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/credential_access_cookies_chromium_browsers_debugging) [Potential Credential Access via DCSync](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dcsync_replication_rights) [Potential Credential Access via DuplicateHandle in LSASS](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_potential_lsa_memdump_via_mirrordump) [Potential Credential Access via LSASS Memory Dump](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_suspicious_lsass_access_memdump) [Potential Credential Access via Memory Dump File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/credential_access_mdmp_file_creation) [Potential Credential Access via Renamed COM+ Services DLL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_suspicious_comsvcs_imageload) [Potential Credential Access via Trusted Developer Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_credential_dumping_msbuild) [Potential Credential Access via Windows Utilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_cmdline_dump_tool) [Potential DLL Side-Loading via Trusted Microsoft Programs](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_suspicious_explorer_winword) [Potential DNS Tunneling via NsLookup](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_dns_tunneling_nslookup) [Potential Data Exfiltration Through Curl](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/exfiltration_potential_curl_data_exfiltration) [Potential Data Exfiltration Through Wget](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/exfiltration_potential_wget_data_exfiltration) [Potential Data Splitting Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/exfiltration_potential_data_splitting_for_exfiltration) [Potential Defense Evasion via CMSTP.exe](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_cmstp_execution) [Potential Defense Evasion via Doas](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_doas_configuration_creation_or_rename) [Potential Defense Evasion via PRoot](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_potential_proot_exploits) [Potential Disabling of AppArmor](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_disable_apparmor_attempt) [Potential Disabling of SELinux](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_disable_selinux_attempt) [Potential Docker Escape via Nsenter](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_docker_escape_via_nsenter) [Potential Dynamic IEX Reconstruction via Environment Variables](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_iex_env_vars_reconstruction) [Potential Enumeration via Active Directory Web Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_active_directory_webservice) [Potential Escalation via Vulnerable MSI Repair](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_msi_repair_via_mshelp_link) [Potential Etherhiding C2 via Blockchain Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_potential_etherhiding_c2) [Potential Evasion via Filter Manager](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_via_filter_manager) [Potential Evasion via Windows Filtering Platform](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_windows_filtering_platform) [Potential Execution of rc.local Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_rc_local_service_already_running) [Potential Execution via FileFix Phishing Attack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_windows_phish_clickfix) [Potential Execution via SSH Backdoor](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_suspicious_ssh_execution_xzbackdoor) [Potential Exploitation of an Unquoted Service Path Vulnerability](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_unquoted_service_path) [Potential External Linux SSH Brute Force Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_potential_linux_ssh_bruteforce_external) [Potential Fake CAPTCHA Phishing Attack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_windows_fakecaptcha_cmd_ps) [Potential File Download via a Headless Browser](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_headless_browser) [Potential File Transfer via Certreq](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_certreq_postdata) [Potential File Transfer via Curl for Windows](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_tool_transfer_via_curl) [Potential Foxmail Exploitation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_initial_access_foxmail_exploit) [Potential Git CVE-2025-48384 Exploitation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_git_exploit_cve_2025_48384) [Potential Hex Payload Execution via Command-Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_hex_payload_execution_via_commandline) [Potential Hex Payload Execution via Common Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_hex_payload_execution_via_utility) [Potential Hidden Local User Account Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_account_creation_hide_at_logon) [Potential Hidden Process via Mount Hidepid](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_mount_execution) [Potential Impersonation Attempt via Kubectl](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_potential_kubectl_impersonation) [Potential Internal Linux SSH Brute Force Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_potential_linux_ssh_bruteforce_internal) [Potential Invoke-Mimikatz PowerShell Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_mimikatz_powershell_module) [Potential JAVA/JNDI Exploitation Attempt](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_suspicious_java_netcon_childproc) [Potential Kerberos Attack via Bifrost](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/lateral_movement_credential_access_kerberos_bifrostconsole) [Potential Kerberos Coercion via DNS-Based SPN Spoofing](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_kerberos_coerce) [Potential Kerberos Relay Attack against a Computer Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dollar_account_relay_kerberos) [Potential Kerberos SPN Spoofing via Suspicious DNS Query](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_kerberos_coerce_dns) [Potential Kubectl Masquerading via Unexpected Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_potential_kubectl_masquerading) [Potential LSA Authentication Package Abuse](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_lsa_auth_package) [Potential LSASS Clone Creation via PssCaptureSnapShot](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_via_snapshot_lsass_clone_creation) [Potential LSASS Memory Dump via PssCaptureSnapShot](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_suspicious_lsass_access_via_snapshot) [Potential Lateral Tool Transfer via SMB Share](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_executable_tool_transfer_smb) [Potential Linux Backdoor User Account Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_linux_backdoor_user_creation) [Potential Linux Credential Dumping via Proc Filesystem](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_proc_credential_dumping) [Potential Linux Credential Dumping via Unshadow](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_credential_dumping) [Potential Linux Hack Tool Launched](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_potential_hack_tool_executed) [Potential Linux Local Account Brute Force Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_potential_linux_local_account_bruteforce) [Potential Linux Ransomware Note Creation Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/impact_potential_linux_ransomware_note_detected) [Potential Linux Tunneling and/or Port Forwarding](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_linux_tunneling_and_port_forwarding) [Potential Linux Tunneling and/or Port Forwarding via Command Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_potential_tunneling_command_line) [Potential Linux Tunneling and/or Port Forwarding via SSH Option](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_linux_tunneling_via_ssh_option) [Potential Local NTLM Relay via HTTP](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_relay_ntlm_auth_via_http_spoolss) [Potential Machine Account Relay Attack via SMB](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_machine_account_smb_relay) [Potential Malicious PowerShell Based on Alert Correlation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_posh_malicious_script_agg) [Potential Malware-Driven SSH Brute Force Attempt](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/impact_potential_bruteforce_malware_infection) [Potential Masquerading as Browser Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_masquerading_browsers) [Potential Masquerading as Business App Installer](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_masquerading_business_apps_installer) [Potential Masquerading as Communication Apps](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_masquerading_communication_apps) [Potential Masquerading as Svchost](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_masquerading_as_svchost) [Potential Masquerading as System32 DLL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_masquerading_windows_dll) [Potential Masquerading as System32 Executable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_masquerading_windows_system32_exe) [Potential Masquerading as VLC DLL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_masquerading_vlc_dll) [Potential Memory Seeking Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_potential_memory_seeking_activity) [Potential Meterpreter Reverse Shell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_via_meterpreter_linux) [Potential Microsoft Office Sandbox Evasion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_sandboxed_office_app_suspicious_zip_file) [Potential Modification of Accessibility Binaries](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_priv_escalation_via_accessibility_features) [Potential NTLM Relay Attack against a Computer Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_dollar_account_relay_ntlm) [Potential NetNTLMv1 Downgrade Attack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_ntlm_downgrade) [Potential Network Scan Executed From Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_ping_sweep_detected) [Potential Network Share Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_net_share_discovery_winlog) [Potential OpenSSH Backdoor Logging Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_ssh_backdoor_log) [Potential Outgoing RDP Connection by Unusual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/lateral_movement_rdp_conn_unusual_process) [Potential Pass-the-Hash (PtH) Attempt](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_alternate_creds_pth) [Potential Password Spraying Attack via SSH](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_potential_password_spraying_attack) [Potential Persistence via Atom Init Script Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_via_atom_init_file_modification) [Potential Persistence via File Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/fim/persistence_suspicious_file_modifications) [Potential Persistence via Login Hook](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_loginwindow_plist_modification) [Potential Persistence via Mandatory User Profile](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_suspicious_user_mandatory_profile_file) [Potential Persistence via Periodic Tasks](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_periodic_tasks_file_mdofiy) [Potential Persistence via Time Provider Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_time_provider_mod) [Potential Port Monitor or Print Processor Registration Abuse](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_port_monitor_print_pocessor_abuse) [Potential Port Scanning Activity from Compromised Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_port_scanning_activity_from_compromised_host) [Potential PowerShell HackTool Script by Author](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_posh_hacktool_authors) [Potential PowerShell HackTool Script by Function Names](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_posh_hacktool_functions) [Potential PowerShell Obfuscated Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation) [Potential PowerShell Obfuscation via Backtick-Escaped Variable Expansion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_backtick_var) [Potential PowerShell Obfuscation via Character Array Reconstruction](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_char_arrays) [Potential PowerShell Obfuscation via Concatenated Dynamic Command Invocation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_concat_dynamic) [Potential PowerShell Obfuscation via High Numeric Character Proportion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_high_number_proportion) [Potential PowerShell Obfuscation via High Special Character Proportion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_posh_obfuscation_proportion_special_chars) [Potential PowerShell Obfuscation via Invalid Escape Sequences](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_backtick) [Potential PowerShell Obfuscation via Reverse Keywords](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_reverse_keyword) [Potential PowerShell Obfuscation via Special Character Overuse](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_whitespace_special_proportion) [Potential PowerShell Obfuscation via String Concatenation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_string_concat) [Potential PowerShell Obfuscation via String Reordering](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_string_format) [Potential PowerShell Pass-the-Hash/Relay Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_relay_tools) [Potential Privacy Control Bypass via Localhost Secure Copy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_privilege_escalation_privacy_pref_sshd_fulldiskaccess) [Potential Privacy Control Bypass via TCCDB Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_privacy_controls_tcc_database_modification) [Potential Privilege Escalation through Writable Docker Socket](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_writable_docker_socket) [Potential Privilege Escalation via CVE-2023-4911](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_looney_tunables_cve_2023_4911) [Potential Privilege Escalation via Container Misconfiguration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_container_util_misconfiguration) [Potential Privilege Escalation via Enlightenment](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_enlightenment_window_manager) [Potential Privilege Escalation via InstallerFileTakeOver](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_installertakeover) [Potential Privilege Escalation via Linux DAC permissions](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_dac_permissions) [Potential Privilege Escalation via OverlayFS](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_overlayfs_local_privesc) [Potential Privilege Escalation via PKEXEC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_pkexec_envar_hijack) [Potential Privilege Escalation via Python cap_setuid](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_suspicious_cap_setuid_python_execution) [Potential Privilege Escalation via Recently Compiled Executable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_uid_change_post_compilation) [Potential Privilege Escalation via SUID/SGID Proxy Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_potential_suid_sgid_proxy_execution) [Potential Privilege Escalation via Service ImagePath Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_reg_service_imagepath_mod) [Potential Privilege Escalation via Sudoers File Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/privilege_escalation_echo_nopasswd_sudoers) [Potential Privileged Escalation via SamAccountName Spoofing](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_samaccountname_spoofing_attack) [Potential Process Injection from Malicious Document](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_injection_from_msoffice) [Potential Process Injection via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_process_injection) [Potential Process Name Stomping with Prctl](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_prctl_process_name_tampering) [Potential Protocol Tunneling via Chisel Client](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_linux_chisel_client_activity) [Potential Protocol Tunneling via EarthWorm](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_tunneling_via_earthworm) [Potential REMCOS Trojan Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_remcos_rat_iocs) [Potential Ransomware Behavior - Note Files by System](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_high_freq_file_renames_by_kernel) [Potential Ransomware Note File Dropped via SMB](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_ransomware_note_file_over_smb) [Potential Remote Credential Access via Registry](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_remote_sam_secretsdump) [Potential Remote Desktop Shadowing Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_evasion_rdp_shadowing) [Potential Remote Desktop Tunneling Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_rdp_tunnel_plink) [Potential Remote File Execution via MSIEXEC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_execution_remote_via_msiexec) [Potential Remote Install via MsiExec](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_msiexec_remote_payload) [Potential RemoteMonologue Attack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_regmod_remotemonologue) [Potential Reverse Shell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_via_tcp_cli_utility_linux) [Potential Reverse Shell Activity via Terminal](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_revershell_via_shell_cmd) [Potential Reverse Shell via Background Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_via_background_process) [Potential Reverse Shell via Child](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_via_child_tcp_utility_linux) [Potential Reverse Shell via Java](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_via_java_revshell_linux) [Potential Reverse Shell via Suspicious Binary](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_via_suspicious_binary) [Potential Reverse Shell via Suspicious Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_via_lolbin_interpreter_linux) [Potential Reverse Shell via UDP](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_via_udp_cli_utility_linux) [Potential SAP NetWeaver Exploitation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_sap_netweaver_webshell_exec) [Potential SAP NetWeaver WebShell Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_sap_netweaver_jsp_webshell) [Potential SSH Password Grabbing via strace](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_ssh_password_grabbing_via_strace) [Potential Secret Scanning via Gitleaks](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/credential_access_gitleaks_execution) [Potential Secure File Deletion via SDelete Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_sdelete_like_filename_rename) [Potential Shadow Credentials added to AD Object](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_shadow_credentials) [Potential Shadow File Read via Command Line Utilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_shadow_file_read) [Potential SharpRDP Behavior](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_rdp_sharprdp_target) [Potential Shell via Wildcard Injection Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_potential_wildcard_shell_spawn) [Potential Subnet Scanning Activity from Compromised Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_subnet_scanning_activity_from_compromised_host) [Potential Successful SSH Brute Force Attack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_potential_successful_linux_ssh_bruteforce) [Potential Sudo Hijacking](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_sudo_hijacking) [Potential Sudo Privilege Escalation via CVE-2019-14287](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_sudo_cve_2019_14287) [Potential Sudo Token Manipulation via Process Injection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_sudo_token_via_process_injection) [Potential Suspicious DebugFS Root Device Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_sda_disk_mount_non_root) [Potential Suspicious File Edit](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_suspicious_file_opened_through_editor) [Potential System Tampering via File Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_mod_critical_os_files) [Potential THC Tool Downloaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/lateral_movement_ssh_it_worm_download) [Potential Telnet Authentication Bypass (CVE-2026-24061)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/initial_access_telnet_auth_bypass_via_user_envar) [Potential Traffic Tunneling using QEMU](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_tunnel_qemu) [Potential Unauthorized Access via Wildcard Injection Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_chown_chmod_unauthorized_file_read) [Potential Upgrade of Non-interactive Shell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_interpreter_tty_upgrade) [Potential Veeam Credential Access Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_veeam_commands) [Potential WPAD Spoofing via DNS Record Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_adidns_wpad_record) [Potential WSUS Abuse for Lateral Movement](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_via_wsus_update) [Potential Web Shell ASPX File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_web_shell_aspx_write) [Potential Webshell Deployed via Apache Struts CVE-2023-50164 Exploitation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/initial_access_apache_struts_cve_2023_50164_exploitation_to_webshell) [Potential Widespread Malware Infection Across Multiple Hosts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_potential_widespread_malware_infection) [Potential Windows Error Manager Masquerading](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_masquerading_werfault) [Potential Windows Session Hijacking via CcmExec](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_sccm_scnotification_dll) [Potential macOS SSH Brute Force Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_potential_macos_ssh_bruteforce) [Potential privilege escalation via CVE-2022-38028](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_exploit_cve_202238028) [Potentially Suspicious Process Started via tmux or screen](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_sus_utility_executed_via_tmux_or_screen) [PowerShell Invoke-NinjaCopy script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_invoke_ninjacopy) [PowerShell Kerberos Ticket Dump](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_kerb_ticket_dump) [PowerShell Kerberos Ticket Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_request_ticket) [PowerShell Keylogging Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_posh_keylogger) [PowerShell Mailbox Collection Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_posh_mailbox) [PowerShell MiniDump Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_minidump) [PowerShell Obfuscation via Negative Index String Reversal](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_obfuscation_index_reversal) [PowerShell PSReflect Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_posh_psreflect) [PowerShell Script Block Logging Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_disable_posh_scriptblocklogging) [PowerShell Script with Archive Compression Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/collection_posh_compression) [PowerShell Script with Discovery Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_posh_generic) [PowerShell Script with Encryption/Decryption Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_encryption) [PowerShell Script with Log Clear Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_powershell_clear_logs_script) [PowerShell Script with Password Policy Discovery Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_posh_password_policy) [PowerShell Script with Remote Execution Capabilities via WinRM](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/lateral_movement_posh_winrm_activity) [PowerShell Script with Token Impersonation Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_posh_token_impersonation) [PowerShell Script with Veeam Credential Access Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_posh_veeam_sql) [PowerShell Script with Webcam Video Capture Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_posh_webcam_video_capture) [PowerShell Script with Windows Defender Tampering Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_defender_tampering) [PowerShell Share Enumeration Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_posh_invoke_sharefinder) [PowerShell Suspicious Discovery Related Windows API Functions](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_posh_suspicious_api_functions) [PowerShell Suspicious Payload Encoded and Compressed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_compressed) [PowerShell Suspicious Script with Audio Capture Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_posh_audio_capture) [PowerShell Suspicious Script with Clipboard Retrieval Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_posh_clipboard_capture) [PowerShell Suspicious Script with Screenshot Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_posh_screen_grabber) [Printer User (lp) Shell Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_cupsd_foomatic_rip_lp_user_execution) [Private Key Searching Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_private_key_password_searching_activity) [Privilege Escalation via CAP_CHOWN/CAP_FOWNER Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_suspicious_chown_fowner_elevation) [Privilege Escalation via CAP_SETUID/SETGID Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_suspicious_uid_guid_elevation) [Privilege Escalation via GDB CAP_SYS_PTRACE](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_gdb_sys_ptrace_elevation) [Privilege Escalation via Named Pipe Impersonation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_named_pipe_impersonation) [Privilege Escalation via Rogue Named Pipe Impersonation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_via_rogue_named_pipe) [Privilege Escalation via Root Crontab File Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/privilege_escalation_root_crontab_filemod) [Privilege Escalation via SUID/SGID](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_potential_suid_sgid_exploitation) [Privilege Escalation via Windir Environment Variable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_rogue_windir_environment_var) [Privileged Account Brute Force](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_bruteforce_admin_account) [Privileged Container Creation with Host Directory Mount](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_privileged_container_creation_with_host_reference) [Privileged Docker Container Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_potentially_overly_permissive_container_creation) [Privileges Elevation via Parent Process PID Spoofing](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_via_ppid_spoofing) [Process Activity via Compiled HTML File](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_via_compiled_html_file) [Process Backgrounded by Unusual Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_process_backgrounded_by_unusual_parent) [Process Capability Enumeration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_process_capabilities) [Process Capability Set via setcap Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_process_capability_set_via_setcap) [Process Created with a Duplicated Token](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_create_process_with_token_unpriv) [Process Created with an Elevated Token](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_via_token_theft) [Process Creation via Secondary Logon](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_create_process_as_different_user) [Process Discovery Using Built-in Tools](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_generic_process_discovery) [Process Discovery via Built-In Applications](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_process_discovery_via_builtin_tools) [Process Execution from an Unusual Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_from_unusual_directory) [Process Injection by the Microsoft Build Engine](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_injection_msbuild) [Process Spawned from Message-of-the-Day (MOTD)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_message_of_the_day_execution) [Process Started from Process ID (PID) File](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_process_started_from_process_id_file) [Process Started with Executable Stack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_executable_stack_execution) [Processes with Trailing Spaces](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_processes_with_trailing_spaces) [Program Files Directory Masquerading](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_masquerading_trusted_directory) [Prompt for Credentials with Osascript](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_promt_for_pwd_via_osascript) [Proxy Execution via Console Window Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_indirect_exec_conhost) [Proxy Execution via Windows OpenSSH](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_indirect_exec_openssh) [Proxy Shell Execution via Busybox](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_busybox_indirect_shell_spawn) [ProxyChains Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_linux_proxychains_activity) [PsExec Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_psexec_lateral_movement_command) [Python Path File (pth) Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_pth_file_creation) [Python Site or User Customize File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_site_and_user_customize_file_creation) [Quarantine Attrib Removed by Unsigned or Untrusted Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_attempt_del_quarantine_attrib) [Query Registry using Built-in Tools](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_generic_registry_query) [RDP (Remote Desktop Protocol) from the Internet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_rdp_remote_desktop_protocol_from_the_internet) [RDP Enabled via Registry](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_rdp_enabled_registry) [ROT Encoded Python Script Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_encoding_rot13_python_script) [RPC (Remote Procedure Call) from the Internet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_rpc_remote_procedure_call_from_the_internet) [RPC (Remote Procedure Call) to the Internet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_rpc_remote_procedure_call_to_the_internet) [RPM Package Installed by Unusual Parent Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_rpm_package_installation_from_unusual_parent) [Rare Connection to WebDAV Target](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_rare_webdav_destination) [Rare SMB Connection to the Internet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/exfiltration_smb_rare_destination) [Registry Persistence via AppCert DLL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_appcertdlls_registry) [Registry Persistence via AppInit DLL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_appinitdlls_registry) [Remote Computer Account DnsHostName Update](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_suspicious_dnshostname_update) [Remote Desktop Enabled in Windows Firewall by Netsh](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_enable_inbound_rdp_with_netsh) [Remote Desktop File Opened from Suspicious Path](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_rdp_file_mail_attachment) [Remote Execution via File Shares](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_execution_via_file_shares_sequence) [Remote File Copy to a Hidden Share](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_remote_file_copy_hidden_share) [Remote File Copy via TeamViewer](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_teamviewer_remote_file_copy) [Remote File Creation in World Writeable Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/lateral_movement_remote_file_creation_world_writeable_dir) [Remote File Download via Desktopimgdownldr Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_remote_file_copy_desktopimgdownldr) [Remote File Download via MpCmdRun](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_remote_file_copy_mpcmdrun) [Remote File Download via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_remote_file_copy_powershell) [Remote File Download via Script Interpreter](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_remote_file_copy_scripts) [Remote GitHub Actions Runner Registration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_register_github_actions_runner) [Remote SSH Login Enabled via systemsetup Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/lateral_movement_remote_ssh_login_enabled) [Remote Scheduled Task Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_scheduled_task_target) [Remote Scheduled Task Creation via RPC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_remote_task_creation_winlog) [Remote System Discovery Commands](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_remote_system_discovery_commands_windows) [Remote Windows Service Installed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_remote_service_installed_winlog) [Remote XSL Script Execution via COM](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_xsl_script_execution_via_com) [Remotely Started Services via RPC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_remote_services) [Renamed Automation Script Interpreter](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_masquerading_renamed_autoit) [Renamed Utility Executed with Short Program Name](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_short_program_name) [Renaming of OpenSSH Binaries](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_credential_access_modify_ssh_binaries) [Root Certificate Installation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_root_certificate_installation) [Root Network Connection via GDB CAP_SYS_PTRACE](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_gdb_sys_ptrace_netcon) [Roshal Archive (RAR) or PowerShell File Downloaded from the Internet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_download_rar_powershell_from_internet) [SELinux Configuration Creation or Renaming](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_selinux_configuration_creation_or_renaming) [SIP Provider Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_sip_provider_mod) [SMB Connections via LOLBin or Untrusted Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_direct_outbound_smb_connection) [SMTP on Port 26/TCP](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_port_26_activity) [SOCKS Traffic from an Unusual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_socks_fortigate_endpoint) [SSH Authorized Keys File Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/persistence_ssh_authorized_keys_modification) [SSH Authorized Keys File Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_authorized_keys_file_deletion) [SSH Key Generated via ssh-keygen](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_ssh_key_generation) [SSL Certificate Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_ssl_certificate_deletion) [SUID/SGID Bit Set](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/privilege_escalation_setuid_setgid_bit_set_via_chmod) [SUID/SGUID Enumeration Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_suid_sguid_enumeration) [SUNBURST Command and Control Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_sunburst_c2_activity_detected) [Scheduled Task Created by a Windows Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_local_scheduled_task_scripting) [Scheduled Task Execution at Scale via GPO](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_group_policy_scheduled_task) [Scheduled Tasks AT Command Enabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_scheduledjobs_at_protocol_enabled) [ScreenConnect Server Spawning Suspicious Processes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_webshell_screenconnect_server) [Screensaver Plist File Modified by Unexpected Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_screensaver_plist_file_modification) [Script Execution via Microsoft HTML Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_script_via_html_app) [Script Interpreter Connection to Non-Standard Port](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_script_interpreter_connection_to_non_standard_port) [SeDebugPrivilege Enabled by a Suspicious Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_tokenmanip_sedebugpriv_enabled) [Searching for Saved Credentials via VaultCmd](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_saved_creds_vaultcmd) [Security File Access via Common Utilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_security_file_access_via_common_utility) [Security Software Discovery using WMIC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_security_software_wmic) [Security Software Discovery via Grep](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/discovery_security_software_grep) [Segfault Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_linux_segfault) [Sensitive Audit Policy Sub-Category Disabled](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_audit_policy_disabled_winlog) [Sensitive File Access followed by Compression](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/collection_sensitive_file_access_followed_by_compression) [Sensitive Files Compression](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_collection_sensitive_files) [Sensitive Privilege SeEnableDelegationPrivilege assigned to a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_seenabledelegationprivilege_assigned_to_user) [Sensitive Registry Hive Access via RegBack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_regback_sam_security_hives) [Service Command Lateral Movement](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_cmd_service) [Service Control Spawned via Script Interpreter](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_service_control_spawned_script_int) [Service Creation via Local Kerberos Authentication](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_krbrelayup_service_creation) [Service DACL Modification via sc.exe](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_sc_sdset) [Service Disabled via Registry Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_service_disabled_registry) [Service Path Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_service_path_registry) [Service Path Modification via sc.exe](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_services_exe_path) [Setcap setuid/setgid Capability Set](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_setuid_setgid_capability_set) [Shadow File Modification by Unusual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_shadow_file_modification) [Shared Object Created by Previously Unknown Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_shared_object_creation) [Shell Configuration Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_shell_configuration_modification) [Shell Execution via Apple Scripting](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/execution_shell_execution_via_apple_scripting) [Shortcut File Written or Modified on Startup Folder](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_startup_folder_lnk) [Signed Proxy Execution via MS Work Folders](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_workfolders_control_execution) [Simple HTTP Web Server Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_simple_web_server_connection_accepted) [Simple HTTP Web Server Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_simple_web_server_creation) [SoftwareUpdate Preferences Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_apple_softupdates_modification) [SolarWinds Process Disabling Services via Registry](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_solarwinds_backdoor_service_disabled_via_registry) [Startup Folder Persistence via Unsigned Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_startup_folder_file_written_by_unsigned_process) [Startup Persistence by a Suspicious Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_startup_folder_file_written_by_suspicious_process) [Startup or Run Key Registry Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_run_key_and_startup_broad) [Startup/Logon Script added to Group Policy Object](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_group_policy_iniscript) [Stolen Credentials Used to Login to Okta Account After MFA Reset](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/persistence_stolen_credentials_used_to_login_to_okta_account_after_mfa_reset) [Sublime Plugin or Application Script Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_modification_sublime_app_plugin_or_script) [Successful SSH Authentication from Unusual IP Address](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/initial_access_successful_ssh_authentication_by_unusual_ip) [Successful SSH Authentication from Unusual SSH Public Key](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/initial_access_first_time_public_key_authentication) [Successful SSH Authentication from Unusual User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/initial_access_successful_ssh_authentication_by_unusual_user) [Sudo Command Enumeration Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_sudo_allowed_command_enumeration) [Sudoers File Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/privilege_escalation_sudoers_file_mod) [Suricata and Elastic Defend Network Correlation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_suricata_elastic_defend_c2) [Suspicious .NET Code Compilation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_dotnet_compiler_parent_process) [Suspicious .NET Reflection via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_posh_assembly_load) [Suspicious /proc/maps Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_proc_maps_read) [Suspicious APT Package Manager Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_apt_package_manager_execution) [Suspicious APT Package Manager Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_apt_package_manager_netcon) [Suspicious AWS S3 Connection via Script Interpreter](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_aws_s3_connection_via_script) [Suspicious Access to LDAP Attributes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_high_number_ad_properties) [Suspicious Antimalware Scan Interface DLL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_amsi_bypass_dllhijack) [Suspicious Apple Mail Rule Plist Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_apple_mail_rule_modification) [Suspicious Automator Workflows Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/execution_script_via_automator_workflows) [Suspicious Browser Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/execution_initial_access_suspicious_browser_childproc) [Suspicious Calendar File Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_suspicious_calendar_modification) [Suspicious CertUtil Commands](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_certutil_commands) [Suspicious Child Execution via Web Server](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_linux_shell_activity_via_web_server) [Suspicious Child Process of Adobe Acrobat Reader Update Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/privilege_escalation_exploit_adobe_acrobat_updater) [Suspicious Cmd Execution via WMI](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_suspicious_cmd_wmi) [Suspicious Communication App Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_communication_apps_suspicious_child_process) [Suspicious Content Extracted or Decompressed via Funzip](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_sus_extraction_or_decrompression_via_funzip) [Suspicious CronTab Creation or Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_crontab_creation) [Suspicious Curl from macOS Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_suspicious_curl_from_macos_application) [Suspicious Curl to Google App Script Endpoint](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_suspicious_curl_to_google_app_script) [Suspicious Curl to Jamf Endpoint](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/lateral_movement_suspicious_curl_to_jamf_endpoint) [Suspicious DLL Loaded for Persistence or Privilege Escalation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_persistence_phantom_dll) [Suspicious Data Encryption via OpenSSL Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/impact_data_encrypted_via_openssl) [Suspicious Dynamic Linker Discovery via od](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_dynamic_linker_via_od) [Suspicious Emond Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_emond_rules_process_execution) [Suspicious Endpoint Security Parent Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_masquerading_as_elastic_endpoint_process) [Suspicious Execution from Foomatic-rip or Cupsd Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_cupsd_foomatic_rip_suspicious_child_execution) [Suspicious Execution from INET Cache](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_execution_from_inetcache) [Suspicious Execution from a Mounted Device](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_execution_from_mounted_device) [Suspicious Execution from a WebDav Share](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_scripting_remote_webdav) [Suspicious Execution via MSIEXEC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_suspicious_msiexec_execution) [Suspicious Execution via Microsoft Office Add-Ins](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_execution_via_office_addins) [Suspicious Execution via Scheduled Task](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_suspicious_scheduled_task_runtime) [Suspicious Execution via Windows Subsystem for Linux](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_wsl_bash_exec) [Suspicious Execution with NodeJS](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_nodejs_susp_patterns) [Suspicious Explorer Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_via_explorer_suspicious_child_parent_args) [Suspicious File Creation via Kworker](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_kworker_file_creation) [Suspicious File Creation via Pkg Install Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_suspicious_file_creation_via_pkg_install_script) [Suspicious File Downloaded from Google Drive](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/command_and_control_google_drive_malicious_file_download) [Suspicious File Renamed via SMB](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_ransomware_file_rename_smb) [Suspicious HTML File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_evasion_suspicious_htm_file_creation) [Suspicious Hidden Child Process of Launchd](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_defense_evasion_hidden_launch_agent_deamon_logonitem_process) [Suspicious Image Load (taskschd.dll) from MS Office](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_suspicious_image_load_scheduled_task_ms_office) [Suspicious ImagePath Service Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_suspicious_service_created_registry) [Suspicious Installer Package Spawns Network Event](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/execution_installer_package_spawned_network_event) [Suspicious Inter-Process Communication via Outlook](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/collection_email_outlook_mailbox_via_com) [Suspicious JetBrains TeamCity Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_exploit_jetbrains_teamcity) [Suspicious Kerberos Authentication Ticket Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_credential_access_kerberos_correlation) [Suspicious Kernel Feature Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_sysctl_kernel_feature_activity) [Suspicious Kworker UID Elevation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_kworker_uid_elevation) [Suspicious LSASS Access via MalSecLogon](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_lsass_handle_via_malseclogon) [Suspicious Lsass Process Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_suspicious_lsass_access_generic) [Suspicious MS Office Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_suspicious_ms_office_child_process) [Suspicious MS Outlook Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_suspicious_ms_outlook_child_process) [Suspicious Managed Code Hosting Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_managedcode_host_process) [Suspicious Memory grep Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_suspicious_memory_grep_activity) [Suspicious Microsoft Antimalware Service Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_execution_windefend_unusual_path) [Suspicious Microsoft Diagnostics Wizard Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_proxy_execution_via_msdt) [Suspicious Microsoft HTML Application Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_mshta_susp_child) [Suspicious Mining Process Creation Event](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_suspicious_mining_process_creation_events) [Suspicious Module Loaded by LSASS](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_lsass_loaded_susp_dll) [Suspicious Named Pipe Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_suspicious_mkfifo_execution) [Suspicious Network Activity to the Internet by Previously Unknown Executable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_suspicious_network_activity_from_unknown_executable) [Suspicious Network Connection via systemd](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_systemd_netcon) [Suspicious Outbound Network Connection via Unsigned Binary](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_suspicious_outbound_network_via_unsigned_binary) [Suspicious Outlook Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_outlook_suspicious_child) [Suspicious PDF Reader Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_suspicious_pdf_reader) [Suspicious Passwd File Event Action](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_suspicious_passwd_file_write) [Suspicious Path Invocation from Command Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_unusual_path_invocation_from_command_line) [Suspicious Path Mounted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_suspicious_path_mounted) [Suspicious Portable Executable Encoded in Powershell Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_posh_portable_executable) [Suspicious PowerShell Engine ImageLoad](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_suspicious_powershell_imgload) [Suspicious Powershell Script](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/execution_ml_windows_anomalous_script) [Suspicious Print Spooler File Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_printspooler_suspicious_file_deletion) [Suspicious Print Spooler Point and Print DLL](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_printspooler_registry_copyfiles) [Suspicious Print Spooler SPL File Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_printspooler_suspicious_spl_file) [Suspicious PrintSpooler Service Executable File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_printspooler_service_suspicious_file) [Suspicious Process Access via Direct System Call](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_process_access_direct_syscall) [Suspicious Process Creation CallTrace](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_process_creation_calltrace) [Suspicious Process Execution via Renamed PsExec Executable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_suspicious_psexesvc) [Suspicious RDP ActiveX Client Loaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_suspicious_rdp_client_imageload) [Suspicious React Server Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/initial_access_execution_susp_react_serv_child) [Suspicious Remote Registry Access via SeBackupPrivilege](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_suspicious_winreg_access_via_sebackup_priv) [Suspicious Renaming of ESXI Files](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_rename_esxi_files) [Suspicious SIP Check by macOS Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/discovery_suspicious_sip_check) [Suspicious ScreenConnect Client Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/command_and_control_screenconnect_childproc) [Suspicious Script Object Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_scrobj_load) [Suspicious SeIncreaseBasePriorityPrivilege Use](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_thread_cpu_priority_hijack) [Suspicious Service was Installed in the System](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_service_windows_service_winlog) [Suspicious SolarWinds Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_apt_solarwinds_backdoor_unusual_child_processes) [Suspicious SolarWinds Web Help Desk Java Module Load or Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_potential_webhelpdesk_exploit) [Suspicious Startup Shell Folder Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_evasion_registry_startup_shell_folder_modified) [Suspicious StartupItem Plist Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_startup_item_plist_creation) [Suspicious Symbolic Link Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_linux_suspicious_symbolic_link) [Suspicious System Commands Executed by Previously Unknown Executable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_suspicious_executable_running_system_commands) [Suspicious TCC Access Granted for User Folders](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_suspicious_tcc_access_granted) [Suspicious Termination of ESXI Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/impact_esxi_process_kill) [Suspicious Troubleshooting Pack Cabinet Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_msdt_suspicious_diagcab) [Suspicious Usage of bpf_probe_write_user Helper](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_bpf_probe_write_user) [Suspicious Utility Launched via ProxyChains](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/command_and_control_linux_suspicious_proxychains_activity) [Suspicious WMI Event Subscription Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_sysmon_wmi_event_subscription) [Suspicious WMI Image Load from MS Office](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_suspicious_image_load_wmi_ms_office) [Suspicious WMIC XSL Script Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_wmi_script) [Suspicious Web Browser Sensitive File Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_suspicious_web_browser_sensitive_file_access) [Suspicious WerFault Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_masquerading_suspicious_werfault_childproc) [Suspicious Windows Command Shell Arguments](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_windows_cmd_shell_susp_args) [Suspicious Windows Powershell Arguments](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_windows_powershell_susp_args) [Suspicious Zoom Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_suspicious_zoom_child_process) [Suspicious macOS MS Office Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/initial_access_suspicious_mac_ms_office_child_process) [Suspicious pbpaste High Volume Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_high_volume_of_pbpaste) [Suspicious rc.local Error Message](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_rc_local_error_via_syslog) [Suspicious which Enumeration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_suspicious_which_command_execution) [Svchost spawning Cmd](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_command_shell_started_by_svchost) [Symbolic Link to Shadow Copy Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_symbolic_link_to_shadow_copy_created) [System Binary Moved or Copied](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_binary_copied_to_suspicious_directory) [System Binary Path File Permission Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_system_binary_file_permission_change) [System Binary Symlink to Suspicious Location](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_symlink_binary_to_writable_dir) [System File Ownership Change](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_modify_ownership_os_files) [System Hosts File Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_hosts_file_access) [System Information Discovery via Windows Command Shell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_files_dir_systeminfo_via_cmd) [System Information Discovery via dmidecode from Parent Shell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_dmidecode_system_discovery) [System Log File Deletion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_log_files_deleted) [System Network Connections Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_system_network_connections) [System Owner/User Discovery Linux](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_linux_system_owner_user_discovery) [System Public IP Discovery via DNS Query](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_host_public_ip_address_lookup) [System Service Discovery through built-in Windows Utilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_system_service_discovery) [System Shells via Services](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_system_shells_via_services) [System Time Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_system_time_discovery) [System V Init Script Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_init_d_file_creation) [System and Network Configuration Check](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/discovery_system_and_network_configuration_check) [SystemKey Access via Command Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_systemkey_dumping) [Systemd Generator Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_systemd_generator_creation) [Systemd Service Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_systemd_service_creation) [Systemd Service Started by Unusual Parent Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_systemd_service_started) [Systemd Shell Execution During Boot](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_systemd_shell_execution) [Systemd Timer Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_systemd_scheduled_timer_created) [Systemd-udevd Rule File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_udev_rule_creation) [TCC Bypass via Mounted APFS Snapshot Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/defense_evasion_tcc_bypass_mounted_apfs_access) [Tainted Kernel Module Load](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_tainted_kernel_module_load) [Tainted Out-Of-Tree Kernel Module Load](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_tainted_kernel_module_out_of_tree_load) [Tampering of Shell Command-Line History](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_deletion_of_bash_command_line_history) [Tampering with RUNNER_TRACKING_ID in GitHub Actions Runners](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/execution_via_github_runner_with_runner_tracking_id_tampering_via_env_vars) [Telnet Authentication Bypass via User Environment Variable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/initial_access_telnet_auth_bypass_envar_auditd) [Temporarily Scheduled Task Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_temp_scheduled_task) [Third-party Backup Files Deleted via Unexpected Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_backup_file_deletion) [Timestomping using Touch Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_timestomp_touch) [Trap Signals Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/privilege_escalation_trap_execution) [UAC Bypass Attempt via Elevated COM Internet Explorer Add-On Installer](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_uac_bypass_com_ieinstal) [UAC Bypass Attempt via Privileged IFileOperation COM Interface](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_uac_bypass_dll_sideloading) [UAC Bypass Attempt via Windows Directory Masquerading](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_uac_bypass_mock_windir) [UAC Bypass Attempt with IEditionUpgradeManager Elevated COM Interface](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_uac_bypass_com_clipup) [UAC Bypass via DiskCleanup Scheduled Task Hijack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_uac_bypass_diskcleanup_hijack) [UAC Bypass via ICMLuaUtil Elevated COM Interface](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_uac_bypass_com_interface_icmluautil) [UAC Bypass via Windows Firewall Snap-In Hijack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_uac_bypass_winfw_mmc_hijack) [UID Elevation from Previously Unknown Executable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/privilege_escalation_uid_elevation_from_unknown_executable) [Uncommon Destination Port Connection by Web Server](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_web_server_sus_destination_port) [Uncommon Registry Persistence Change](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_registry_uncommon) [Unexpected Child Process of macOS Screensaver Engine](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/persistence_screensaver_engine_unexpected_child_process) [Unix Socket Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_unix_socket_communication) [Unknown Execution of Binary with RWX Memory Region](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_unknown_rwx_mem_region_binary_executed) [Unsigned BITS Service Client Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_unsigned_bits_client) [Unsigned DLL Loaded by Svchost](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_service_dll_unsigned) [Unsigned DLL Loaded by a Trusted Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_dll_hijack) [Unsigned DLL Side-Loading from a Suspicious Folder](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_unsigned_dll_loaded_from_suspdir) [Unsigned DLL loaded by DNS Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_dns_serverlevelplugindll) [Untrusted DLL Loaded by Azure AD Sync Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_imageload_azureadconnectauthsvc) [Untrusted Driver Loaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_untrusted_driver_loaded) [Unusual Base64 Encoding/Decoding Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_base64_decoding_activity) [Unusual Child Process from a System Virtual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_unusual_system_vp_child_program) [Unusual Child Process of dns.exe](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_unusual_dns_service_children) [Unusual Child Processes of RunDLL32](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_rundll32_no_arguments) [Unusual Command Execution from Web Server Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_web_server_sus_command_execution) [Unusual D-Bus Daemon Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_dbus_unsual_daemon_parent_execution) [Unusual DPKG Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_dpkg_unusual_execution) [Unusual Discovery Activity by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_signal_unusual_user_host) [Unusual Discovery Signal Alert with Unusual Process Command Line](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_signal_unusual_discovery_signal_proc_cmdline) [Unusual Discovery Signal Alert with Unusual Process Executable](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_signal_unusual_discovery_signal_proc_executable) [Unusual Executable File Creation by a System Critical Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_system_critical_proc_abnormal_file_activity) [Unusual Execution from Kernel Thread (kthreadd) Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_unusual_kthreadd_execution) [Unusual Execution via Microsoft Common Console File](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_initial_access_via_msc_file) [Unusual Exim4 Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_unusual_exim4_child_process) [Unusual File Creation - Alternate Data Stream](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_unusual_ads_file_creation) [Unusual File Creation by Web Server](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_web_server_sus_file_creation) [Unusual File Operation by dns.exe](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_unusual_dns_service_file_writes) [Unusual Instance Metadata Service (IMDS) API Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_unusual_instance_metadata_service_api_request) [Unusual Interactive Shell Launched from System User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_interactive_shell_from_system_user) [Unusual Kernel Module Enumeration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_kernel_module_enumeration) [Unusual Kill Signal](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_unsual_kill_signal) [Unusual LD_PRELOAD/LD_LIBRARY_PATH Command Line Arguments](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_ld_preload_cmdline) [Unusual Library Load via Python](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/execution_unusual_library_load_via_python) [Unusual Linux Network Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_linux_anomalous_network_activity) [Unusual Linux Network Configuration Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/discovery_ml_linux_system_network_configuration_discovery) [Unusual Linux Network Connection Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/discovery_ml_linux_system_network_connection_discovery) [Unusual Linux Network Port Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_linux_anomalous_network_port_activity) [Unusual Linux Process Calling the Metadata Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/credential_access_ml_linux_anomalous_metadata_process) [Unusual Linux Process Discovery Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/discovery_ml_linux_system_process_discovery) [Unusual Linux System Information Discovery Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/discovery_ml_linux_system_information_discovery) [Unusual Linux User Calling the Metadata Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/credential_access_ml_linux_anomalous_metadata_user) [Unusual Linux User Discovery Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/discovery_ml_linux_system_user_discovery) [Unusual Linux Username](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/initial_access_ml_linux_anomalous_user_name) [Unusual Login via System User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_ssh_via_backdoored_system_user) [Unusual Network Activity from a Windows System Binary](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_network_connection_from_windows_binary) [Unusual Network Connection to Suspicious Top Level Domain](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_unusual_connection_to_suspicious_top_level_domain) [Unusual Network Connection to Suspicious Web Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/command_and_control_unusual_network_connection_to_suspicious_web_service) [Unusual Network Connection via DllHost](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_unusual_network_connection_via_dllhost) [Unusual Network Connection via RunDLL32](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_unusual_network_connection_via_rundll32) [Unusual Parent Process for cmd.exe](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_command_shell_started_by_unusual_process) [Unusual Parent-Child Relationship](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_unusual_parentchild_relationship) [Unusual Persistence via Services Registry](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_services_registry) [Unusual Pkexec Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_unusual_pkexec_execution) [Unusual Preload Environment Variable Process Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_unusual_preload_env_vars) [Unusual Print Spooler Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_unusual_printspooler_childprocess) [Unusual Process Execution Path - Alternate Data Stream](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_unusual_dir_ads) [Unusual Process Execution on WBEM Path](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_unusual_process_path_wbem) [Unusual Process Extension](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_unusual_process_extension) [Unusual Process For MSSQL Service Accounts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/lateral_movement_unusual_process_sql_accounts) [Unusual Process For a Linux Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/persistence_ml_rare_process_by_host_linux) [Unusual Process For a Windows Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/persistence_ml_rare_process_by_host_windows) [Unusual Process Modifying GenAI Configuration File](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_genai_config_modification) [Unusual Process Network Connection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_unusual_process_network_connection) [Unusual Process Spawned by a Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_rare_process_for_a_host) [Unusual Process Spawned by a Parent Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_rare_process_for_a_parent_process) [Unusual Process Spawned by a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_rare_process_for_a_user) [Unusual Process Spawned from Web Server Parent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_web_server_sus_child_spawned) [Unusual Remote File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/lateral_movement_unusual_remote_file_creation) [Unusual SSHD Child Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_unusual_sshd_child_process) [Unusual Scheduled Task Update](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_scheduled_task_updated) [Unusual Service Host Child Process - Childless Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_unusual_svchost_childproc_childless) [Unusual Sudo Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/privilege_escalation_ml_linux_anomalous_sudo_activity) [Unusual User Privilege Enumeration via id](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_unusual_user_enumeration_via_id) [Unusual Web Config File Access](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_web_config_file_access) [Unusual Web Server Command Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_web_server_unusual_command_execution) [Unusual Windows Network Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_windows_anomalous_network_activity) [Unusual Windows Path Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/persistence_ml_windows_anomalous_path_activity) [Unusual Windows Process Calling the Metadata Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/credential_access_ml_windows_anomalous_metadata_process) [Unusual Windows Remote User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/initial_access_ml_windows_rare_user_type10_remote_login) [Unusual Windows Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/persistence_ml_windows_anomalous_service) [Unusual Windows User Calling the Metadata Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/credential_access_ml_windows_anomalous_metadata_user) [Unusual Windows User Privilege Elevation Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/privilege_escalation_ml_windows_rare_user_runas_event) [Unusual Windows Username](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/initial_access_ml_windows_anomalous_user_name) [User Account Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_user_account_creation) [User Added to Privileged Group in Active Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_user_account_added_to_privileged_group_ad) [User Added to the Admin Group](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/privilege_escalation_user_added_to_admin_group) [User Detected with Suspicious Windows Process(es)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_suspicious_windows_process_cluster_from_user) [User account exposed to Kerberoasting](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_spn_attribute_modified) [User or Group Creation/Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_user_or_group_creation_or_modification) [VNC (Virtual Network Computing) from the Internet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_vnc_virtual_network_computing_from_the_internet) [VNC (Virtual Network Computing) to the Internet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/command_and_control_vnc_virtual_network_computing_to_the_internet) [Veeam Backup Library Loaded by Unusual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_veeam_backup_dll_imageload) [Virtual Machine Fingerprinting](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_virtual_machine_fingerprinting) [Virtual Machine Fingerprinting via Grep](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/discovery_virtual_machine_fingerprinting_grep) [Virtual Private Network Connection Attempt](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/lateral_movement_vpn_connection_attempt) [Volume Shadow Copy Deleted or Resized via VssAdmin](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_volume_shadow_copy_deletion_or_resized_via_vssadmin) [Volume Shadow Copy Deletion via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_volume_shadow_copy_deletion_via_powershell) [Volume Shadow Copy Deletion via WMIC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/impact_volume_shadow_copy_deletion_via_wmic) [WDAC Policy File by an Unusual Process](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_wdac_policy_by_unusual_process) [WMI Incoming Lateral Movement](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/lateral_movement_incoming_wmi) [WMI WBEMTEST Utility Execution](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_wmi_wbemtest) [WMIC Remote Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/lateral_movement_wmic_remote) [WPS Office Exploitation via DLL Hijack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_initial_access_wps_dll_exploit) [WRITEDAC Access on Active Directory Object](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_write_dac_access) [Web Server Spawned via Python](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_python_webserver_spawned) [Web Shell Detection: Script Process Child of Common Web Processes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_webshell_detection) [WebProxy Settings Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/macos/credential_access_mitm_localhost_webproxy) [WebServer Access Logs Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_deleting_websvr_access_logs) [Werfault ReflectDebugger Persistence](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/persistence_werfault_reflectdebugger) [Whoami Process Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/discovery_whoami_command_activity) [Windows Account or Group Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_generic_account_groups) [Windows CryptoAPI Spoofing Vulnerability (CVE-2020-0601 - CurveBall)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_cve_2020_0601) [Windows Defender Disabled via Registry Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_defender_disabled_via_registry) [Windows Defender Exclusions Added via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_defender_exclusion_via_powershell) [Windows Event Logs Cleared](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_clearing_windows_security_logs) [Windows Firewall Disabled via PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_powershell_windows_firewall_disabled) [Windows Installer with Suspicious Properties](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/defense_evasion_msiexec_installsource_archive_file) [Windows Network Enumeration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_net_view) [Windows Registry File Creation in SMB Share](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_moving_registry_hive_via_smb) [Windows Sandbox with Sensitive Configuration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_run_virt_windowssandbox) [Windows Script Executing PowerShell](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_script_executing_powershell) [Windows Script Execution from Archive](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/execution_scripts_archive_file) [Windows Script Interpreter Executing Process via WMI](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_scripts_process_started_via_wmi) [Windows Server Update Service Spawning Suspicious Processes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/initial_access_suspicious_windows_server_update_svc) [Windows Service Installed via an Unusual Client](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_windows_service_via_unusual_client) [Windows Subsystem for Linux Distribution Installed](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_wsl_registry_modification) [Windows Subsystem for Linux Enabled via Dism Utility](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/defense_evasion_wsl_enabled_via_dism) [Windows System Information Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_windows_system_information_discovery) [Windows System Network Connections Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_win_network_connections) [Wireless Credential Dumping using Netsh Command](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/credential_access_wireless_creds_dumping) [Yum Package Manager Plugin File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_yum_package_manager_plugin_file_creation) [Yum/DNF Plugin Status Discovery](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_yum_dnf_plugin_detection) [dMSA Account Creation by an Unusual User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/windows/privilege_escalation_dmsa_creation_by_unusual_user) [rc.local/rc.common File Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_rc_script_creation) 

## Identity

[LLM-Based Compromised User Triage by User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_llm_compromised_user_triage) [New Okta Authentication Behavior Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_new_okta_authentication_behavior) [Okta AiTM Session Cookie Replay](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_okta_aitm_session_cookie_replay) [Okta Multiple OS Names Detected for a Single DT Hash](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_multiple_user_agent_os_authentication) [Okta Sign-In Events via Third-Party IdP](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/initial_access_sign_in_events_via_third_party_idp) [Potential Okta MFA Bombing via Push Notifications](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_okta_mfa_bombing_via_push_notifications) [Potentially Successful Okta MFA Bombing via Push Notifications](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_okta_potentially_successful_okta_bombing_via_push_notifications) 

## Kubernetes

[Kubernetes Anonymous Request Authorized by Unusual User Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/initial_access_anonymous_request_authorized) [Kubernetes Anonymous User Create/Update/Patch Pods Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/execution_anonymous_create_update_patch_pod_request) [Kubernetes Cluster-Admin Role Binding Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/persistence_cluster_admin_rolebinding_created) [Kubernetes Container Created with Excessive Linux Capabilities](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_container_created_with_excessive_linux_capabilities) [Kubernetes Creation of a RoleBinding Referencing a ServiceAccount](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/persistence_service_account_bound_to_clusterrole) [Kubernetes Creation or Modification of Sensitive Role](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/persistence_sensitive_role_creation_or_modification) [Kubernetes Denied Service Account Request via Unusual User Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/discovery_denied_service_account_request) [Kubernetes Events Deleted](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/defense_evasion_events_deleted) [Kubernetes Forbidden Creation Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/execution_forbidden_creation_request) [Kubernetes Forbidden Request from Unusual User Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/execution_forbidden_request_from_unsual_user_agent) [Kubernetes Pod Created With HostIPC](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_pod_created_with_hostipc) [Kubernetes Pod Created With HostNetwork](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_pod_created_with_hostnetwork) [Kubernetes Pod Created With HostPID](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_pod_created_with_hostpid) [Kubernetes Pod Created with a Sensitive hostPath Volume](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_pod_created_with_sensitive_hostpath_volume) [Kubernetes Potential Endpoint Permission Enumeration Attempt Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/discovery_endpoint_permission_enumeration_by_user_and_srcip) [Kubernetes Potential Endpoint Permission Enumeration Attempt by Anonymous User Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/discovery_endpoint_permission_enumeration_by_anonymous_user) [Kubernetes Privileged Pod Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_privileged_pod_created) [Kubernetes Sensitive RBAC Change Followed by Workload Modification](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_sensitive_rbac_change_followed_by_workload_modification) [Kubernetes Service Account Modified RBAC Objects](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_service_account_rbac_write_operation) [Kubernetes Suspicious Assignment of Controller Service Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/privilege_escalation_suspicious_assignment_of_controller_service_account) [Kubernetes Suspicious Self-Subject Review via Unusual User Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/discovery_suspicious_self_subject_review) [Kubernetes Unusual Decision by User Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/execution_unusual_request_response_by_user_agent) [Kubernetes User Exec into Pod](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/execution_user_exec_to_pod) 

## LLM

[AWS Bedrock Detected Multiple Attempts to use Denied Models by a Single User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_multiple_attempts_to_use_denied_models_by_user) [AWS Bedrock Detected Multiple Validation Exception Errors by a Single User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_multiple_validation_exception_errors_by_single_user) [AWS Bedrock Guardrails Detected Multiple Policy Violations Within a Single Blocked Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_guardrails_multiple_violations_in_single_request) [AWS Bedrock Guardrails Detected Multiple Violations by a Single User Over a Session](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_guardrails_multiple_violations_by_single_user) [AWS Bedrock Invocations without Guardrails Detected by a Single User Over a Session](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_execution_without_guardrails) [Azure OpenAI Insecure Output Handling](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure_openai/azure_openai_insecure_output_handling_detection) [Potential Abuse of Resources by High Token Count and Large Response Sizes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_high_resource_consumption_detection) [Potential Azure OpenAI Model Theft](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure_openai/azure_openai_model_theft_detection) [Potential Denial of Azure OpenAI ML Service](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure_openai/azure_openai_denial_of_ml_service_detection) [Unusual High Confidence Content Filter Blocks Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_high_confidence_misconduct_blocks_detected) [Unusual High Denied Sensitive Information Policy Blocks Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_multiple_sensitive_information_policy_blocks_detected) [Unusual High Denied Topic Blocks Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_multiple_topic_policy_blocks_detected) [Unusual High Word Policy Blocks Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_multiple_word_policy_blocks_detected) 

## Network

[Anomalous React Server Components Flight Data Patterns](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_anomalous_rsc_flight_data_patterns) [First-Time FortiGate Administrator Login](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_newly_observed_fortigate_admin_logon) [FortiGate Administrator Account Creation from Unusual Source](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/persistence_fortigate_admin_creation_unusual_source) [FortiGate Administrator Login from Multiple IP Addresses](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_fortigate_admin_login_multi_srcip) [FortiGate Configuration File Downloaded](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/collection_fortigate_config_download) [FortiGate FortiCloud SSO Login from Unusual Source](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_fortigate_sso_login_from_unusual_source) [FortiGate Overly Permissive Firewall Policy Created](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/defense_evasion_fortigate_overly_permissive_firewall_policy) [FortiGate SSO Login Followed by Administrator Account Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/persistence_fortigate_sso_login_followed_by_admin_creation) [FortiGate Super Admin Account Creation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/persistence_fortigate_super_admin_account_creation) [Machine Learning Detected DGA activity using a known SUNBURST DNS domain](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/dga/command_and_control_ml_dga_activity_using_sunburst_domain) [Machine Learning Detected a DNS Request Predicted to be a DGA Domain](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/dga/command_and_control_ml_dns_request_predicted_to_be_a_dga_domain) [Machine Learning Detected a DNS Request With a High DGA Probability Score](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/dga/command_and_control_ml_dns_request_high_dga_probability) [Newly Observed FortiGate Alert](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/newly_observed_fortigate_alert) [Newly Observed High Severity Suricata Alert](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/newly_observed_suricata_alert) [Newly Observed Palo Alto Network Alert](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/newly_observed_panos_alert) [Potential Network Scan Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/discovery_potential_port_scan_detected) [Potential Network Sweep Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/discovery_potential_network_sweep_detected) [Potential SYN-Based Port Scan Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/discovery_potential_syn_port_scan_detected) [Potential Toolshell Initial Exploit (CVE-2025-53770 & CVE-2025-53771)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_potential_toolshell_exploit_attempt) [Potential VIEWSTATE RCE Attempt on SharePoint/IIS](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_potential_rce_via_toolshell) [React2Shell (CVE-2025-55182) Exploitation Attempt](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_react_server_components_rce_attempt) [React2Shell Network Security Alert](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_react_server_rce_network_alerts) [SMB (Windows File Sharing) Activity to the Internet](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/initial_access_smb_windows_file_sharing_activity_to_the_internet) [Statistical Model Detected C2 Beaconing Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/beaconing/command_and_control_beaconing) [Statistical Model Detected C2 Beaconing Activity with High Confidence](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/beaconing/command_and_control_beaconing_high_confidence) 

## SaaS

[Multiple Device Token Hashes for Single Okta Session](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_multiple_device_token_hashes_for_single_okta_session) [Successful Application SSO from Rare Unknown Client Device](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/initial_access_successful_application_sso_from_unknown_client_device) [Unauthorized Scope for Public App OAuth2 Token Grant with Client Credentials](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_first_occurence_public_app_client_credential_token_exchange) 

## Unspecified

[Abnormally Large DNS Response](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/network/lateral_movement_dns_server_overflow) [Administrator Privileges Assigned to an Okta Group](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/persistence_administrator_privileges_assigned_to_okta_group) [Administrator Role Assigned to an Okta User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/persistence_administrator_role_assigned_to_okta_user) [Adversary Behavior - Detected - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_adversary_behavior_detected) [Agent Spoofing - Multiple Hosts Using Same Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_agent_spoofing_multiple_hosts) [Alerts From Multiple Integrations by Destination Address](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_from_different_modules_by_dstip) [Alerts From Multiple Integrations by Source Address](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_from_different_modules_by_srcip) [Alerts From Multiple Integrations by User Name](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_from_different_modules_by_user) [Alerts in Different ATT&CK Tactics by Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_risky_host_esql) [Attempt to Create Okta API Token](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/persistence_attempt_to_create_okta_api_token) [Attempt to Deactivate an Okta Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/impact_okta_attempt_to_deactivate_okta_application) [Attempt to Deactivate an Okta Network Zone](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_attempt_to_deactivate_okta_network_zone) [Attempt to Deactivate an Okta Policy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_okta_attempt_to_deactivate_okta_policy) [Attempt to Deactivate an Okta Policy Rule](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_okta_attempt_to_deactivate_okta_policy_rule) [Attempt to Delete an Okta Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/impact_okta_attempt_to_delete_okta_application) [Attempt to Delete an Okta Network Zone](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_attempt_to_delete_okta_network_zone) [Attempt to Delete an Okta Policy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_okta_attempt_to_delete_okta_policy) [Attempt to Delete an Okta Policy Rule](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_okta_attempt_to_delete_okta_policy_rule) [Attempt to Modify an Okta Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/impact_okta_attempt_to_modify_okta_application) [Attempt to Modify an Okta Network Zone](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_okta_attempt_to_modify_okta_network_zone) [Attempt to Modify an Okta Policy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_okta_attempt_to_modify_okta_policy) [Attempt to Modify an Okta Policy Rule](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_okta_attempt_to_modify_okta_policy_rule) [Attempt to Reset MFA Factors for an Okta User Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/persistence_attempt_to_reset_mfa_factors_for_okta_user_account) [Attempt to Revoke Okta API Token](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/impact_attempt_to_revoke_okta_api_token) [Attempted Bypass of Okta MFA](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_attempted_bypass_of_okta_mfa) [Attempts to Brute Force an Okta User Account](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_attempts_to_brute_force_okta_user_account) [Behavior - Detected - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/elastic_endpoint_security_behavior_detected) [Behavior - Prevented - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/elastic_endpoint_security_behavior_prevented) [Credential Dumping - Detected - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/credential_access_endgame_cred_dumping_detected) [Credential Dumping - Prevented - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/credential_access_endgame_cred_dumping_prevented) [Credential Manipulation - Detected - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/privilege_escalation_endgame_cred_manipulation_detected) [Credential Manipulation - Prevented - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/privilege_escalation_endgame_cred_manipulation_prevented) [CrowdStrike External Alerts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/crowdstrike_external_alerts) [CyberArk Privileged Access Security Error](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cyberarkpas/privilege_escalation_cyberarkpas_error_audit_event_promotion) [CyberArk Privileged Access Security Recommended Monitor](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cyberarkpas/privilege_escalation_cyberarkpas_recommended_events_to_monitor_promotion) [DNS Tunneling](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/command_and_control_ml_packetbeat_dns_tunneling) [Decline in host-based traffic](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_low_count_events_for_a_host_name) [Elastic Defend and Network Security Alerts Correlation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_elastic_defend_netsecurity_by_host) [Elastic Security External Alerts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/elastic_security_external_alerts) [Endpoint Security (Elastic Defend)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/elastic_endpoint_security) [Enumeration of Kernel Modules via Proc](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_kernel_module_enumeration_via_proc) [Exploit - Detected - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/execution_endgame_exploit_detected) [Exploit - Prevented - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/execution_endgame_exploit_prevented) [External Alerts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/external_alerts) [First Occurrence of Okta User Session Started via Proxy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/initial_access_first_occurrence_user_session_started_via_proxy) [Google SecOps External Alerts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/google_secops_external_alerts) [High Command Line Entropy Detected for Privileged Commands](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_linux_high_median_process_command_line_entropy_by_user) [High Mean of Process Arguments in an RDP Session](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_high_mean_rdp_process_args) [High Mean of RDP Session Duration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_high_mean_rdp_session_duration) [High Number of Okta Device Token Cookies Generated for Authentication](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_okta_multiple_device_token_hashes_for_single_user) [High Number of Okta User Password Reset or Unlock Attempts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_suspicious_okta_user_password_reset_or_unlock_attempts) [High Variance in RDP Session Duration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_high_variance_rdp_session_duration) [Host Detected with Suspicious Windows Process(es)](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_suspicious_windows_process_cluster_from_host) [Kubernetes Exposed Service Created With Type NodePort](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/kubernetes/persistence_exposed_service_created_with_type_nodeport) [Lateral Movement Alerts from a Newly Observed Source Address](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/lateral_movement_multi_alerts_new_srcip) [Lateral Movement Alerts from a Newly Observed User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/lateral_movement_multi_alerts_new_userid) [Machine Learning Detected a Suspicious Windows Event with a High Malicious Probability Score](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_suspicious_windows_event_high_probability) [Machine Learning Detected a Suspicious Windows Event with a Low Malicious Probability Score](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_suspicious_windows_event_low_probability) [Malicious File - Detected - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/execution_elastic_malicious_file_detected) [Malicious File - Prevented - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/execution_elastic_malicious_file_prevented) [Malware - Detected - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_malware_detected) [Malware - Prevented - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_malware_prevented) [Memory Threat - Detected - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/defense_evasion_elastic_memory_threat_detected) [Memory Threat - Prevented- Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/defense_evasion_elastic_memory_threat_prevented) [Microsoft Sentinel External Alerts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/microsoft_sentinel_external_alerts) [Modification or Removal of an Okta Application Sign-On Policy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/persistence_okta_attempt_to_modify_or_delete_application_sign_on_policy) [Multiple Alerts Involving a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_involving_user) [Multiple Alerts in Different ATT&CK Tactics on a Single Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_different_tactics_host) [Multiple Alerts in Same ATT&CK Tactic by Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_same_tactic_by_host) [Multiple Elastic Defend Alerts by Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_edr_elastic_defend_by_host) [Multiple Elastic Defend Alerts from a Single Process Tree](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_edr_elastic_same_process_tree) [Multiple Machine Learning Alerts by Influencer Field](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_machine_learning_jobs_by_entity) [Multiple Okta Sessions Detected for a Single User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/lateral_movement_multiple_sessions_for_single_user) [Multiple Okta User Auth Events with Same Device Token Hash Behind a Proxy](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_multiple_auth_events_from_single_device_behind_proxy) [Multiple Okta User Authentication Events with Client Address](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_okta_authentication_for_multiple_users_from_single_source) [Multiple Okta User Authentication Events with Same Device Token Hash](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_okta_authentication_for_multiple_users_with_the_same_device_token_hash) [Multiple Vulnerabilities by Asset via Wiz](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_vulnerabilities_wiz_by_container) [My First Rule](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/guided_onboarding_sample_rule) [Network Traffic to Rare Destination Country](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_rare_destination_country) [New Okta Identity Provider (IdP) Added by Admin](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/persistence_new_idp_successfully_added_by_admin) [Newly Observed Elastic Defend Behavior Alert](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/newly_observed_elastic_defend_alert) [Newly Observed High Severity Detection Alert](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/newly_observed_elastic_detection_rule) [Okta Brute Force or Password Spraying Attack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_okta_brute_force_or_password_spraying) [Okta FastPass Phishing Detection](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/initial_access_okta_fastpass_phishing) [Okta ThreatInsight Threat Suspected Promotion](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/okta_threatinsight_threat_suspected_promotion) [Okta User Session Impersonation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_user_impersonation_access) [Okta User Sessions Started from Different Geolocations](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/initial_access_okta_user_sessions_started_from_different_geolocations) [Permission Theft - Detected - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/privilege_escalation_endgame_permission_theft_detected) [Permission Theft - Prevented - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/privilege_escalation_endgame_permission_theft_prevented) [Possible Okta DoS Attack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/impact_possible_okta_dos_attack) [Potential DGA Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/dga/command_and_control_ml_dga_high_sum_probability) [Potential Data Exfiltration Activity to an Unusual Destination Port](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/ded/exfiltration_ml_high_bytes_destination_port) [Potential Data Exfiltration Activity to an Unusual IP Address](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/ded/exfiltration_ml_high_bytes_destination_ip) [Potential Data Exfiltration Activity to an Unusual ISO Code](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/ded/exfiltration_ml_high_bytes_destination_geo_country_iso_code) [Potential Data Exfiltration Activity to an Unusual Region](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/ded/exfiltration_ml_high_bytes_destination_region_name) [Process Injection - Detected - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/privilege_escalation_endgame_process_injection_detected) [Process Injection - Prevented - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/privilege_escalation_endgame_process_injection_prevented) [Ransomware - Detected - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/impact_elastic_ransomware_detected) [Ransomware - Detected - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_ransomware_detected) [Ransomware - Prevented - Elastic Defend](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/endpoint/impact_elastic_ransomware_prevented) [Ransomware - Prevented - Elastic Endgame](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/endgame_ransomware_prevented) [Rapid7 Threat Command CVEs Correlation](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_rapid7_threat_command) [Rare User Logon](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/initial_access_ml_auth_rare_user_logon) [SentinelOne Alert External Alerts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/sentinelone_alert_external_alerts) [SentinelOne Threat External Alerts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/sentinelone_threat_external_alerts) [Spike in Bytes Sent to an External Device](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/ded/exfiltration_ml_high_bytes_written_to_external_device) [Spike in Bytes Sent to an External Device via Airdrop](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/ded/exfiltration_ml_high_bytes_written_to_external_device_airdrop) [Spike in Failed Logon Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/credential_access_ml_auth_spike_in_failed_logon_events) [Spike in Firewall Denies](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_high_count_network_denies) [Spike in Group Application Assignment Change Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_okta_spike_in_group_application_assignment_changes) [Spike in Group Lifecycle Change Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_okta_spike_in_group_lifecycle_changes) [Spike in Group Management Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_high_count_group_management_events) [Spike in Group Membership Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_okta_spike_in_group_membership_changes) [Spike in Group Privilege Change Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_okta_spike_in_group_privilege_changes) [Spike in Logon Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/credential_access_ml_auth_spike_in_logon_events) [Spike in Network Traffic](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_high_count_network_events) [Spike in Network Traffic To a Country](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_spike_in_traffic_to_a_country) [Spike in Number of Connections Made from a Source IP](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_spike_in_connections_from_a_source_ip) [Spike in Number of Connections Made to a Destination IP](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_spike_in_connections_to_a_destination_ip) [Spike in Number of Processes in an RDP Session](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_spike_in_rdp_processes) [Spike in Privileged Command Execution by a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_linux_high_count_privileged_process_events_by_user) [Spike in Remote File Transfers](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_spike_in_remote_file_transfers) [Spike in Special Logon Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_high_count_special_logon_events) [Spike in Special Privilege Use Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_high_count_special_privilege_use_events) [Spike in Successful Logon Events from a Source IP](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/credential_access_ml_auth_spike_in_logon_events_from_a_source_ip) [Spike in User Account Management Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_high_count_user_account_management_events) [Spike in User Lifecycle Management Change Events](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_okta_spike_in_user_lifecycle_management_changes) [Spike in host-based traffic](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_high_count_events_for_a_host_name) [Splunk External Alerts](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/promotions/splunk_external_alerts) [Suspected Lateral Movement from Compromised Host](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_by_host_ip_and_source_ip) [Suspicious Activity Reported by Okta User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/initial_access_suspicious_activity_reported_by_okta_user) [Suspicious Modprobe File Event](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_linux_modprobe_enumeration) [Suspicious Proc Pseudo File System Enumeration](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_suspicious_proc_enumeration) [Suspicious Sysctl File Event](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/discovery_linux_sysctl_enumeration) [Threat Intel Email Indicator Match](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_indicator_match_email) [Threat Intel Hash Indicator Match](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_indicator_match_hash) [Threat Intel IP Address Indicator Match](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_indicator_match_address) [Threat Intel URL Indicator Match](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_indicator_match_url) [Threat Intel Windows Registry Indicator Match](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_indicator_match_registry) [Unauthorized Access to an Okta Application](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/initial_access_okta_user_attempted_unauthorized_access) [Unusual DNS Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/command_and_control_ml_packetbeat_rare_dns_question) [Unusual Group Name Accessed by a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_rare_group_name_by_user) [Unusual Host Name for Okta Privileged Operations Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_okta_rare_host_name_by_user) [Unusual Host Name for Windows Privileged Operations Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_rare_device_by_user) [Unusual Hour for a User to Logon](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/initial_access_ml_auth_rare_hour_for_a_user_to_logon) [Unusual Login Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/credential_access_ml_suspicious_login_activity) [Unusual Network Destination Domain Name](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/ml_packetbeat_rare_server_domain) [Unusual Privilege Type assigned to a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_rare_privilege_assigned_to_user) [Unusual Process Detected for Privileged Commands by a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_linux_rare_process_executed_by_user) [Unusual Process Writing Data to an External Device](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/ded/exfiltration_ml_rare_process_writing_to_external_device) [Unusual Region Name for Okta Privileged Operations Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_okta_rare_region_name_by_user) [Unusual Region Name for Windows Privileged Operations Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_rare_region_name_by_user) [Unusual Remote File Directory](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_rare_remote_file_directory) [Unusual Remote File Extension](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_rare_remote_file_extension) [Unusual Remote File Size](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_high_remote_file_size) [Unusual Source IP for Okta Privileged Operations Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_okta_rare_source_ip_by_user) [Unusual Source IP for Windows Privileged Operations Detected](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_rare_source_ip_by_user) [Unusual Source IP for a User to Logon from](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/initial_access_ml_auth_rare_source_ip_for_a_user) [Unusual Spike in Concurrent Active Sessions by a User](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_okta_high_sum_concurrent_sessions_by_user) [Unusual Time or Day for an RDP Session](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/lmd/lateral_movement_ml_unusual_time_for_an_rdp_session) [Unusual Web Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/command_and_control_ml_packetbeat_rare_urls) [Unusual Web User Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/ml/command_and_control_ml_packetbeat_rare_user_agent) [Web Application Suspicious Activity: POST Request Declined](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/apm/apm_403_response_to_a_post) [Web Application Suspicious Activity: Unauthorized Method](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/apm/apm_405_response_method_not_allowed) [Web Application Suspicious Activity: sqlmap User Agent](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/apm/apm_sqlmap_user_agent) [Zoom Meeting with no Passcode](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/initial_access_zoom_meeting_with_no_passcode) 

## Web

[Potential HTTP Downgrade Attack](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/defense_evasion_potential_http_downgrade_attack) [Potential Spike in Web Server Error Logs](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/reconnaissance_web_server_unusual_spike_in_error_logs) [Web Server Discovery or Fuzzing Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/reconnaissance_web_server_discovery_or_fuzzing_activity) [Web Server Local File Inclusion Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/discovery_web_server_local_file_inclusion_activity) [Web Server Potential Command Injection Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/persistence_web_server_potential_command_injection) [Web Server Potential Remote File Inclusion Activity](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/discovery_web_server_remote_file_inclusion_activity) [Web Server Potential SQL Injection Request](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_web_server_potential_sql_injection) [Web Server Potential Spike in Error Response Codes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/reconnaissance_web_server_unusual_spike_in_error_response_codes) [Web Server Suspicious User Agent Requests](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/reconnaissance_web_server_unusual_user_agents)