﻿---
title: Elastic Security ECS field reference
description: This section lists Elastic Common Schema fields that provide an optimal SIEM and security analytics experience to users. These fields are used to display...
url: https://www.elastic.co/docs/reference/security/fields-and-object-schemas/siem-field-reference
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Security ECS field reference
This section lists [Elastic Common Schema](https://www.elastic.co/docs/reference/ecs) fields that provide an optimal SIEM and security analytics experience to users. These fields are used to display data, provide rule previews, enable detection by prebuilt detection rules, provide context during rule triage and investigation, escalate to cases, and more.
<important>
  We recommend you use Elastic Agent integrations or Beats  to ship your data to Elastic Security. Elastic Agent integrations and Beat modules (for example, [Filebeat modules](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules)) are ECS-compliant, which means data they ship to Elastic Security will automatically populate the relevant ECS fields. If you plan to use a custom implementation to map your data to ECS fields (see [how to map data to ECS](https://www.elastic.co/docs/reference/ecs/ecs-converting)), ensure the [always required fields](#siem-always-required-fields) are populated. Ideally, all relevant ECS fields should be populated as well.
</important>

For detailed information about which ECS fields can appear in documents generated by Elastic Endpoint, refer to the [Endpoint event documentation](https://github.com/elastic/endpoint-package/tree/main/custom_documentation/doc/endpoint).

## Always required fields

Elastic Security requires all event and threat intelligence data to be normalized to ECS.  For proper operation, all data must contain the following ECS fields:
- `@timestamp`
- `ecs.version`
- `event.kind`
- `event.category`
- `event.type`


## Fields required for process events

Elastic Security relies on these fields to analyze and display process data:
- `process.name`
- `process.pid`


## Fields required for host events

Elastic Security relies on these fields to analyze and display host data:
- `host.name`
- `host.id`

Elastic Security may use these fields to display additional host data:
- `cloud.instance.id`
- `cloud.machine.type`
- `cloud.provider`
- `cloud.region`
- `host.architecture`
- `host.ip`
- `host.mac`
- `host.os.family`
- `host.os.name`
- `host.os.platform`
- `host.os.version`


#### Authentication fields

Elastic Security relies on these fields and values to analyze and display host authentication data:
- `event.category:authentication`
- `event.outcome:success` or `event.outcome:failure`

Elastic Security may also use this field to display additional host authentication data:
- `user.name`


#### Uncommon process fields

Elastic Security relies on this field to analyze and display host uncommon process data:
- `process.name`

Elastic Security may also use these fields to display uncommon process data:
- `agent.type`
- `event.action`
- `event.code`
- `event.dataset`
- `event.module`
- `process.args`
- `user.id`
- `user.name`


## Fields required for network events

Elastic Security relies on these fields to analyze and display network data:
- `destination.geo.location` (required for display of [map data](https://www.elastic.co/docs/solutions/security/explore/configure-network-map-data))
- `destination.ip`
- `source.geo.location` (required to display map data)
- `source.ip`

Elastic Security may also use these fields to analyze and display network data:
- `destination.as.number`
- `destination.as.organization.name`
- `destination.bytes`
- `destination.domain`
- `destination.geo.country_iso_code`
- `source.as.number`
- `source.as.organization.name`
- `source.bytes`
- `source.domain`
- `source.geo.country_iso_code`


#### DNS query fields

Elastic Security relies on these fields to analyze and display DNS data:
- `dns.question.name`
- `dns.question.registered_domain`

Elastic Security may also use this field to display DNS data:
- `dns.question.type`
  <note>
  If you want to be able to filter out PTR records, make sure relevant events have `dns.question.type` fields with values of `PTR`.
  </note>


#### HTTP request fields

Elastic Security relies on these fields to analyze and display HTTP request data:
- `http.request.method`
- `http.response.status_code`
- `url.domain`
- `url.path`


#### TLS fields

Elastic Security relies on this field to analyze and display TLS data:
- `tls.server.hash.sha1`

Elastic Security may also use these fields to analyze and display TLS data:
- `tls.server.issuer`
- `tls.server.ja3s`
- `tls.server.not_after`
- `tls.server.subject`


## Fields required for events and external alerts

Elastic Security relies on this field to analyze and display event and external alert data:
- `event.kind`
  <note>
  For external alerts, the `event.kind` field’s value must be `alert`.
  </note>

Elastic Security may also use these fields to analyze and display event and external alert data:
- `destination.bytes`
- `destination.geo.city_name`
- `destination.geo.continent_name`
- `destination.geo.country_iso_code`
- `destination.geo.country_name`
- `destination.geo.region_iso_code`
- `destination.geo.region_name`
- `destination.ip`
- `destination.packets`
- `destination.port`
- `dns.question.name`
- `dns.question.type`
- `dns.resolved_ip`
- `dns.response_code`
- `event.action`
- `event.code`
- `event.created`
- `event.dataset`
- `event.duration`
- `event.end`
- `event.hash`
- `event.id`
- `event.module`
- `event.original`
- `event.outcome`
- `event.provider`
- `event.risk_score_norm`
- `event.risk_score`
- `event.severity`
- `event.start`
- `event.timezone`
- `file.ctime`
- `file.device`
- `file.extension`
- `file.gid`
- `file.group`
- `file.inode`
- `file.mode`
- `file.mtime`
- `file.name`
- `file.owner`
- `file.path`
- `file.size`
- `file.target_path`
- `file.type`
- `file.uid`
- `host.id`
- `host.ip`
- `http.request.body.bytes`
- `http.request.body.content`
- `http.request.method`
- `http.request.referrer`
- `http.response.body.bytes`
- `http.response.body.content`
- `http.response.status_code`
- `http.version`
- `message`
- `network.bytes`
- `network.community_id`
- `network.direction`
- `network.packets`
- `network.protocol`
- `network.transport`
- `pe.original_file_name`
- `process.args`
- `process.executable`
- `process.hash.md5`
- `process.hash.sha1`
- `process.hash.sha256`
- `process.name`
- `process.parent.executable`
- `process.parent.name`
- `process.pid`
- `process.ppid`
- `process.title`
- `process.working_directory`
- `rule.reference`
- `source.bytes`
- `source.geo.city_name`
- `source.geo.continent_name`
- `source.geo.country_iso_code`
- `source.geo.country_name`
- `source.geo.region_iso_code`
- `source.geo.region_name`
- `source.ip`
- `source.packets`
- `source.port`
- `user.domain`
- `user.name`