﻿---
title: Alert schema
description: Elastic Security stores alerts that have been generated by detection rules in hidden Elasticsearch indices. The index pattern is .alerts-security.alerts-<space-id->...
url: https://www.elastic.co/docs/reference/security/fields-and-object-schemas/alert-schema
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Alert schema
Elastic Security stores alerts that have been generated by detection rules in hidden Elasticsearch indices. The index pattern is `.alerts-security.alerts-<space-id->`.
<important>
  - System indices, such as the alert indices, contain important configuration and internal data; do not change their mappings. Changes can lead to rule execution and alert indexing failures. Use [runtime fields](https://www.elastic.co/docs/solutions/security/get-started/create-runtime-fields-in-elastic-security) instead, which allow you to add fields to existing alert and event documents.
  - We recommend to NOT to use the `_source` field in alert documents, but rather to use the `fields` option in the search API to programmatically obtain the list of fields used in these documents. Learn more about [retrieving selected fields from a search](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields).
</important>

<note>
  The non-ECS fields listed below are beta and subject to change.
</note>


| Alert field                                                                                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
|-------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [`@timestamp`](https://www.elastic.co/docs/reference/ecs/ecs-base#field-timestamp)                          | ECS field, represents the time when the alert was created or most recently updated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`message`](https://www.elastic.co/docs/reference/ecs/ecs-base#field-message)                               | ECS field copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [`tags`](https://www.elastic.co/docs/reference/ecs/ecs-base#field-tags)                                     | ECS field copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [`labels`](https://www.elastic.co/docs/reference/ecs/ecs-base#field-labels)                                 | ECS field copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [`ecs.version`](https://www.elastic.co/docs/reference/ecs/ecs-ecs#field-ecs-version)                        | ECS mapping version of the alert.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [`event.kind`](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-kind)                     | ECS field, always `signal` for alert documents.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [`event.category`](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-category)             | ECS field, copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`event.type`](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-type)                     | ECS field, copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`event.outcome`](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-outcome)               | ECS field, copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`agent.*`](https://www.elastic.co/docs/reference/ecs/ecs-agent)                                            | ECS `agent.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [`client.*`](https://www.elastic.co/docs/reference/ecs/ecs-client)                                          | ECS `client.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [`cloud.*`](https://www.elastic.co/docs/reference/ecs/ecs-cloud)                                            | ECS `cloud.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [`container.*`](https://www.elastic.co/docs/reference/ecs/ecs-container)                                    | ECS `container.* fields` copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [`destination.*`](https://www.elastic.co/docs/reference/ecs/ecs-destination)                                | ECS `destination.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`dll.*`](https://www.elastic.co/docs/reference/ecs/ecs-dll)                                                | ECS `dll.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`dns.*`](https://www.elastic.co/docs/reference/ecs/ecs-dns)                                                | ECS `dns.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`error.*`](https://www.elastic.co/docs/reference/ecs/ecs-error)                                            | ECS `error.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [`event.*`](https://www.elastic.co/docs/reference/ecs/ecs-event)                                            | ECS `event.*` fields copied from the source document, if present, for custom query and indicator match rules.**Note:** categorization fields (`event.kind`, `event.category`, `event.type`, `event.outcome`) are listed separately.                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`file.*`](https://www.elastic.co/docs/reference/ecs/ecs-file)                                              | ECS `file.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [`group.*`](https://www.elastic.co/docs/reference/ecs/ecs-group)                                            | ECS `group.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [`host.*`](https://www.elastic.co/docs/reference/ecs/ecs-host)                                              | ECS `host.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [`http.*`](https://www.elastic.co/docs/reference/ecs/ecs-http)                                              | ECS `http.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [`log.*`](https://www.elastic.co/docs/reference/ecs/ecs-log)                                                | ECS `log.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`network.*`](https://www.elastic.co/docs/reference/ecs/ecs-network)                                        | ECS `network.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [`observer.*`](https://www.elastic.co/docs/reference/ecs/ecs-observer)                                      | ECS `observer.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [`orchestrator.*`](https://www.elastic.co/docs/reference/ecs/ecs-orchestrator)                              | ECS `orchestrator.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [`organization.*`](https://www.elastic.co/docs/reference/ecs/ecs-organization)                              | ECS `organization.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [`package.*`](https://www.elastic.co/docs/reference/ecs/ecs-package)                                        | ECS `package.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [`process.*`](https://www.elastic.co/docs/reference/ecs/ecs-process)                                        | ECS `process.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [`registry.*`](https://www.elastic.co/docs/reference/ecs/ecs-registry)                                      | ECS `registry.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [`related.*`](https://www.elastic.co/docs/reference/ecs/ecs-related)                                        | ECS `related.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [`rule.*`](https://www.elastic.co/docs/reference/ecs/ecs-rule)                                              | ECS `rule.*` fields copied from the source document, if present, for custom query and indicator match rules.**Note:** These fields are not related to the detection rule that generated the alert.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [`server.*`](https://www.elastic.co/docs/reference/ecs/ecs-server)                                          | ECS `server.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [`service.*`](https://www.elastic.co/docs/reference/ecs/ecs-service)                                        | ECS `service.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [`source.*`](https://www.elastic.co/docs/reference/ecs/ecs-source)                                          | ECS `source.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [`span.*`](https://www.elastic.co/docs/reference/ecs/ecs-tracing#field-span-id)                             | ECS `span.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [`threat.*`](https://www.elastic.co/docs/reference/ecs/ecs-threat)                                          | ECS `threat.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [`tls.*`](https://www.elastic.co/docs/reference/ecs/ecs-tls)                                                | ECS `tls.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`trace.*`](https://www.elastic.co/docs/reference/ecs/ecs-tracing)                                          | ECS `trace.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [`transaction.*`](https://www.elastic.co/docs/reference/ecs/ecs-tracing#field-transaction-id)               | ECS `transaction.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`url.*`](https://www.elastic.co/docs/reference/ecs/ecs-url)                                                | ECS `url.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`user.*`](https://www.elastic.co/docs/reference/ecs/ecs-user)                                              | ECS `user.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [`user_agent.*`](https://www.elastic.co/docs/reference/ecs/ecs-user_agent)                                  | ECS `user_agent.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [`vulnerability.*`](https://www.elastic.co/docs/reference/ecs/ecs-vulnerability)                            | ECS `vulnerability.*` fields copied from the source document, if present, for custom query and indicator match rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `kibana.alert.ancestors.*`                                                                                  | Type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `kibana.alert.depth`                                                                                        | Type: Long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `kibana.alert.new_terms`                                                                                    | The value of the new term that generated this alert.Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `kibana.alert.original_data_stream.*` <applies-to>Elastic Stack: Generally available since 9.1</applies-to> | Data stream information copied from the original source event, including `dataset`, `namespace`, and `type` fields.Type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.original_event.*`                                                                             | Event information copied from the original source event.Type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `kibana.alert.original_time`                                                                                | The value copied from the source event (`@timestamp`).Type: date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `kibana.alert.reason`                                                                                       | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.author`                                                                                  | The value of the `author` who created the rule. Refer to [configure advanced rule settings](/docs/solutions/security/detect-and-alert/create-detection-rule#rule-ui-advanced-params).Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `kibana.alert.building_block_type`                                                                          | The value of `building_block_type` from the rule that generated this alert. Refer to [configure advanced rule settings](/docs/solutions/security/detect-and-alert/create-detection-rule#rule-ui-advanced-params).Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `kibana.alert.rule.created_at`                                                                              | The value of `created.at` from the rule that generated this alert.Type: date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `kibana.alert.rule.created_by`                                                                              | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.description`                                                                             | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.enabled`                                                                                 | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.false_positives`                                                                         | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.from`                                                                                    | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.uuid`                                                                                    | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.immutable`                                                                               | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.interval`                                                                                | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.license`                                                                                 | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.max_signals`                                                                             | Type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `kibana.alert.rule.name`                                                                                    | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.note`                                                                                    | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.references`                                                                              | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.risk_score`                                                                                   | Type: float                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `kibana.alert.rule.rule_id`                                                                                 | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.rule_name_override`                                                                      | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.severity`                                                                                     | Alert severity, populated by the `rule_type` at alert creation. Must have a value of `low`, `medium`, `high`, `critical`.Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `kibana.alert.rule.tags`                                                                                    | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.threat.*`                                                                                | Type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `kibana.alert.rule.timeline_id`                                                                             | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.timeline_title`                                                                          | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.timestamp_override`                                                                      | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.to`                                                                                      | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.type`                                                                                    | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.updated_at`                                                                              | Type: date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `kibana.alert.rule.updated_by`                                                                              | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.version`                                                                                 | A number that represents a rule’s version.Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `kibana.alert.rule.revision`                                                                                | A number that gets incremented each time you edit a rule.Type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `kibana.alert.workflow_status`                                                                              | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.workflow_status_updated_at`                                                                   | The timestamp of when the alert’s status was last updated.Type: date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `kibana.alert.threshold_result.*`                                                                           | Type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `kibana.alert.group.id`                                                                                     | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.group.index`                                                                                  | Type: integer                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.parameters.index`                                                                        | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.language`                                                                     | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.query`                                                                        | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.risk_score_mapping`                                                           | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.saved_id`                                                                     | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.severity_mapping`                                                             | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.threat_filters`                                                               | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.threat_index`                                                                 | Names of the indicator indices.Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `kibana.alert.rule.parameters.threat_indicator_path`                                                        | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.threat_language`                                                              | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.threat_mapping.*`                                                             | Controls which fields will be compared in the indicator and source documents.Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `kibana.alert.rule.parameters.threat_query`                                                                 | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.alert.rule.parameters.threshold.*`                                                                  | Type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `kibana.space_ids`                                                                                          | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.consumer`                                                                                | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.status`                                                                                       | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.category`                                                                                | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.execution.uuid`                                                                          | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.producer`                                                                                | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.rule.rule_type_id`                                                                            | Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.suppression.terms.field`                                                                      | The fields used to group alerts for suppression.Type:	keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `kibana.alert.suppression.terms.value`                                                                      | The values in the suppression fields.Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `kibana.alert.suppression.start`                                                                            | The timestamp of the first document in the suppression group.Type: date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `kibana.alert.suppression.end`                                                                              | The timestamp of the last document in the suppression group.Type: date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `kibana.alert.suppression.docs_count`                                                                       | The number of suppressed alerts.Type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `kibana.alert.url`                                                                                          | The shareable URL for the alert.**Note:** This field appears only if you’ve set the [`server.publicBaseUrl`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-publicbaseurl) configuration setting in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file.Type: long                                                                                                                                                                                                                                                                                                                                   |
| `kibana.alert.workflow_tags`                                                                                | List of tags added to an alert.This field can contain an array of values, for example: `["False Positive", "production"]`Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `kibana.alert.workflow_assignee_ids`                                                                        | List of users assigned to an alert.An array of unique identifiers (UIDs) for user profiles, for example: `["u_1-0CcWliOCQ9T2MrK5YDjhpxZ_AcxPKt3pwaICcnAUY_0, u_2-0CcWliOCQ9T2MrK5YDjhpxZ_AcxPKt3pwaICcnAUY_1"]`UIDs are linked to user profiles that are automatically created when users first log into a deployment. These profiles contain names, emails, profile avatars, and other user settings.Type: string[]                                                                                                                                                                                                                                                             |
| `kibana.alert.intended_timestamp`                                                                           | Shows the alert’s estimated timestamp, had the alert been created when the source event initially occurred. The value in this field is determined by the way the rule was run:- **Scheduled run**: Alerts created by scheduled runs have the same timestamp as the `@timestamp` field, which shows when the alert was created.- **Manual run**: Alerts created by manual runs have a timestamp that falls within the time range specified for the manual run. For example, if you set a rule to manually run on event data from `10/01/2024 05:00 PM` to `10/07/2024 05:00 PM`, the `kibana.alert.intended_timestamp` value will be a date and time within that range.Type: date |
| `kibana.alert.rule.execution.type`                                                                          | Shows if an alert was created by a manual run or a scheduled run. The value can be `manual` or `scheduled`.Type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |