﻿---
title: Endpoint command reference
description: This page lists the commands for managing and troubleshooting Elastic Endpoint, the installed component that performs Elastic Defend's threat monitoring...
url: https://www.elastic.co/docs/reference/security/endpoint-command-reference
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Endpoint command reference
This page lists the commands for managing and troubleshooting Elastic Endpoint, the installed component that performs Elastic Defend's threat monitoring and prevention.
<note>
  - Elastic Endpoint is not added to the `PATH` system variable, so you must prepend the commands with the full OS-dependent path:
    - On Windows: `"C:\Program Files\Elastic\Endpoint\elastic-endpoint.exe"`
  - On macOS: `/Library/Elastic/Endpoint/elastic-endpoint`
  - On Linux: `/opt/Elastic/Endpoint/elastic-endpoint`
  - You must run the commands with elevated privileges—using `sudo` to run as the root user on Linux and macOS, or running as Administrator on Windows.
</note>

The following Elastic Endpoint commands are available:
- [diagnostics](#elastic-endpoint-diagnostics-command)
- [help](#elastic-endpoint-help-command)
- [inspect](#elastic-endpoint-inspect-command)
- [install](#elastic-endpoint-install-command)
- [memorydump](#elastic-endpoint-memorydump-command)
- [run](#elastic-endpoint-run-command)
- [send](#elastic-endpoint-send-command)
- [status](#elastic-endpoint-status-command)
- [test](#elastic-endpoint-test-command)
- [top](#elastic-endpoint-top-command)
- [uninstall](#elastic-endpoint-uninstall-command)
- [version](#elastic-endpoint-version-command)

Each of the commands accepts the following logging options:
- `--log [stdout,stderr,debugview,file]`
- `--log-level [error,info,debug]`


## elastic-endpoint diagnostics

Gather diagnostics information from Elastic Endpoint. This command produces an archive that contains:
- `version.txt`: Version information
- `elastic-endpoint.yaml`: Current policy
- `metrics.json`: Metrics document
- `policy_response.json`: Last policy response
- `system_info.txt`: System information
- `analysis.txt`: Diagnostic analysis report
- `logs` directory: Copy of Elastic Endpoint log files


### Example

```shell
elastic-endpoint diagnostics
```


## elastic-endpoint help

Show help for the available commands.

### Example

```shell
elastic-endpoint help
```


## elastic-endpoint inspect

Show the current Elastic Endpoint configuration.

### Example

```shell
elastic-endpoint inspect
```


## elastic-endpoint install

Install Elastic Endpoint as a system service.
<note>
  We do not recommend installing Elastic Endpoint using this command. Elastic Endpoint is managed by Elastic Agent and cannot function as a standalone service. Therefore, there is no separate installation package for Elastic Endpoint, and it should not be installed independently.
</note>


### Options

<definitions>
  <definition term="--resources <string>">
    Specify a resources `.zip` file to be used during the installation. This option is required.
  </definition>
  <definition term="--upgrade">
    Upgrade the existing installation.
  </definition>
</definitions>


### Example

```shell
elastic-endpoint install --upgrade --resources endpoint-security-resources.zip
```


## elastic-endpoint memorydump

Save a memory dump of the Elastic Endpoint service.

### Options

<definitions>
  <definition term="--compress">
    Compress the saved memory dump.
  </definition>
  <definition term="--timeout <duration>">
    Specify the memory collection timeout, in seconds; the default is 60 seconds.
  </definition>
</definitions>


### Example

```shell
elastic-endpoint memorydump --timeout 120
```


## elastic-endpoint run

Run `elastic-endpoint` as a foreground process if no other instance is already running.

### Example

```shell
elastic-endpoint run
```


## elastic-endpoint send

Send the requested document to the Elastic Stack.

### Subcommands

<definitions>
  <definition term="metadata">
    Send an off-schedule metrics document to the Elastic Stack.
  </definition>
</definitions>


### Example

```shell
elastic-endpoint send metadata
```


## elastic-endpoint status

Retrieve the current status of the running Elastic Endpoint service. The command also returns the last known status of Elastic Agent.

### Options

<definitions>
  <definition term="--output">
    Control the level of detail and formatting of the information. Valid values are:
    - `human`: Returns limited information when Elastic Endpoint's status is `Healthy`. If any policy actions weren’t successfully applied, the relevant details are displayed.
    - `full`: Always returns the full status information.
    - `json`: Always returns the full status information.
  </definition>
</definitions>


### Example

```shell
elastic-endpoint status --output json
```


## elastic-endpoint test

Perform the requested test.

### Subcommands

<definitions>
  <definition term="output">
    Test whether Elastic Endpoint can connect to remote resources.
  </definition>
</definitions>


### Example

```shell
elastic-endpoint test output
```


### Example output

```txt
Testing output connections

Using proxy:

Elasticsearch server: https://example.elastic.co:443
        Status: Success

Global artifact server: https://artifacts.security.elastic.co
        Status: Success

Fleet server: https://fleet.example.elastic.co:443
        Status: Success
```


## elastic-endpoint top

Show a breakdown of the executables that triggered Elastic Endpoint CPU usage within the last interval. This displays which Elastic Endpoint features are resource-intensive for a particular executable.
<note>
  The meaning and output of this command are similar, but not identical, to the POSIX `top` command. The `elastic-endpoint top` command aggregates multiple processes by executable. The utilization values aren’t measured by the OS scheduler but by a wall clock in user mode. The output helps identify outliers causing excessive CPU utilization, allowing you to fine-tune the Elastic Defend policy and exception lists in your deployment.
</note>


### Options

<definitions>
  <definition term="--interval <duration>">
    Specify the data collection interval, in seconds; the default is 5 seconds.
  </definition>
  <definition term="--limit <number>">
    Specify the number of updates to collect; by default, data is collected until interrupted by **Ctrl+C**.
  </definition>
  <definition term="--normalized">
    Normalize CPU usage values to a total of 100% across all CPUs on multi-CPU systems.
  </definition>
</definitions>


### Example

```shell
elastic-endpoint top --interval 10 --limit 5
```


### Example output

```txt
| PROCESS                                            | OVERALL | API | BHVR | DIAG BHVR | DNS | FILE   | LIB | MEM SCAN | MLWR  | NET | PROC | RANSOM | REG |
=============================================================================================================================================================
| MSBuild.exe                                        |  3146.0 | 0.0 |  0.8 |       0.7 | 0.0 | 2330.9 | 0.0 |    226.2 | 586.9 | 0.0 |  0.0 |    0.4 | 0.0 |
| Microsoft.Management.Services.IntuneWindowsAgen... |    30.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.2 |     29.8 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| svchost.exe                                        |    27.3 | 0.0 |  0.1 |       0.1 | 0.0 |    0.4 | 0.2 |      0.0 |  26.6 | 0.0 |  0.0 |    0.0 | 0.0 |
| LenovoVantage-(LenovoServiceBridgeAddin).exe       |     0.1 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.1 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| Lenovo.Modern.ImController.PluginHost.Device.exe   |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| msedgewebview2.exe                                 |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| msedge.exe                                         |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| powershell.exe                                     |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| WmiPrvSE.exe                                       |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| Lenovo.Modern.ImController.PluginHost.Device.exe   |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| Slack.exe                                          |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| uhssvc.exe                                         |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| explorer.exe                                       |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| taskhostw.exe                                      |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| Widgets.exe                                        |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| elastic-endpoint.exe                               |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |
| sppsvc.exe                                         |     0.0 | 0.0 |  0.0 |       0.0 | 0.0 |    0.0 | 0.0 |      0.0 |   0.0 | 0.0 |  0.0 |    0.0 | 0.0 |

Endpoint service (16 CPU): 113.0% out of 1600%

Collecting data.  Press Ctrl-C to cancel
```


#### Column abbreviations

- `API`: Event Tracing for Windows (ETW) API events
- `AUTH`: Authentication events
- `BHVR`: Malicious behavior protection
- `CRED`: Credential access events
- `DIAG BHVR`: Diagnostic malicious behavior protection
- `DNS`: DNS events
- `FILE`: File events
- `LIB`: Library load events
- `MEM SCAN`: Memory scanning
- `MLWR`: Malware protection
- `NET`: Network events
- `PROC`: Process events
- `PROC INJ`: Process injection
- `RANSOM`: Ransomware protection
- `REG`: Registry events


## elastic-endpoint uninstall

Uninstall Elastic Endpoint.
<note>
  Elastic Endpoint is managed by Elastic Agent. To remove Elastic Endpoint from the target machine permanently, remove the Elastic Defend integration from the Fleet policy. The [elastic-agent uninstall](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/uninstall-elastic-agent) command also uninstalls Elastic Endpoint; therefore, in practice, the `elastic-endpoint uninstall` command is used only to troubleshoot broken installations.
</note>


### Options

<definitions>
  <definition term="--uninstall-token <string>">
    Provide the uninstall token. The token is required if [agent tamper protection](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/prevent-elastic-agent-uninstallation) is enabled.
  </definition>
</definitions>


### Example

```shell
elastic-endpoint uninstall --uninstall-token 12345678901234567890123456789012
```


## elastic-endpoint version

Show the version of Elastic Endpoint.

### Example

```shell
elastic-endpoint version
```