﻿---
title: Which connector to choose?
description: The first thing you want to consider before implementing your search is the backend you’re going to use for your data. (Recommended) Elasticsearch Connector...
url: https://www.elastic.co/docs/reference/search-ui/tutorials
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Which connector to choose?
The first thing you want to consider before implementing your search is the backend you’re going to use for your data.
- (Recommended) [Elasticsearch Connector](https://www.elastic.co/docs/reference/search-ui/api-connectors-elasticsearch) is the best option for working with [Elasticsearch](https://www.elastic.co/elasticsearch). It’s a flexible option that gives you full control over the request and response flow — but it can also work out of the box with minimal configuration.
- [Site Search](https://www.elastic.co/docs/reference/search-ui/api-connectors-site-search) if you are already using [Swiftype](https://swiftype.com/), these are basically a single product with two names.
- Use [Custom Connector Guide](https://www.elastic.co/docs/reference/search-ui/guides-building-custom-connector) if none of the built-in connectors fit your use case.


### ⚠️ Deprecated connectors

The following connectors are no longer recommended for use in new projects:
- [Elastic App Search](https://www.elastic.co/docs/reference/search-ui/api-connectors-app-search)
- [Elastic Workplace Search](https://www.elastic.co/docs/reference/search-ui/api-connectors-workplace-search)

These products are deprecated and not actively maintained. If you’re still using them, the connectors will technically work — but we suggest migrating to the [Elasticsearch Connector](https://www.elastic.co/docs/reference/search-ui/api-connectors-elasticsearch).