﻿---
title: Search UI with Elasticsearch
description: This section provides step-by-step guides and examples to help you build a modern search experience using Search UI and Elasticsearch. Whether you're...
url: https://www.elastic.co/docs/reference/search-ui/tutorials-elasticsearch
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Search UI with Elasticsearch
This section provides step-by-step guides and examples to help you build a modern search experience using Search UI and Elasticsearch.
Whether you're just starting out or preparing for production, you'll find the right guide here.

## Getting Started

Learn how to create a working search interface from scratch:
- [Setup Elasticsearch](https://www.elastic.co/docs/reference/search-ui/tutorials-elasticsearch-setup-cloud)
- [Create and map an index](https://www.elastic.co/docs/reference/search-ui/tutorials-elasticsearch-setup-index)
- [Install connector](https://www.elastic.co/docs/reference/search-ui/tutorials-elasticsearch-install-connector)
- [Configure and run Search UI](https://www.elastic.co/docs/reference/search-ui/tutorials-elasticsearch-configure-search-ui)
- [Customise Request](https://www.elastic.co/docs/reference/search-ui/tutorials-elasticsearch-customise-query)


## Production Usage

Best practices for deploying Search UI in production:
- [Using in Production](https://www.elastic.co/docs/reference/search-ui/tutorials-elasticsearch-production-usage)


## Sandbox Examples

Want to explore live code examples? Check out our [CodeSandbox](https://codesandbox.io/p/sandbox/github/elastic/search-ui/tree/main/examples/sandbox) with ready-to-run setups:
- Basic Elasticsearch connector
- Server-proxied setup for production
- Use cases & API examples


## Reference Docs

For advanced configuration and full API details, see:
- [Elasticsearch Connector API Reference](https://www.elastic.co/docs/reference/search-ui/api-connectors-elasticsearch)
- [Search UI Core Configuration](https://www.elastic.co/docs/reference/search-ui/api-core-configuration)