﻿---
title: Setup Elasticsearch
description: First we need to setup Elasticsearch. The easiest way to do this is to create an Elasticsearch instance via Elastic Cloud. Next we need to setup an API...
url: https://www.elastic.co/docs/reference/search-ui/tutorials-elasticsearch-setup-cloud
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Setup Elasticsearch
First we need to setup Elasticsearch. The easiest way to do this is to create an Elasticsearch instance via [Elastic Cloud](https://cloud.elastic.co/registration).

## Setting up a read-only API Key

Next we need to setup an API key to access the data from the index. We can do this via Kibana’s Stack Management API Keys page (`<your Kibana endpoint>/app/management/security/api_keys`). Note that security needs to be enabled for this option to be available.
Notice here we are only giving read privileges for this api key. You will need to setup an api key with write privileges to add and update data to the index.
```json
{
  "superuser": {
    "cluster": ["all"],
    "indices": [
      {
        "names": ["my-example-movies"],
        "privileges": ["read"],
        "allow_restricted_indices": false
      }
    ]
  }
}
```

![creating api key](https://www.elastic.co/docs/reference/search-ui/images/api-keys.jpeg)
Once saved, you are presented with the api-key. Copy this and keep it safe. We will need to use this further down in the tutorial.
![copy api key](https://www.elastic.co/docs/reference/search-ui/images/api-key-view.jpeg)

## Enabling CORS

If you’re going to be accessing Elasticsearch directly from a browser and the Elasticsearch host domain doesn’t match your site’s domain, you will need to enable CORS.
CORS is a browser mechanism which enables controlled access to resources located outside of the current domain. In order for the browser to make requests to Elasticsearch, CORS configuration headers need to specified in the Elasticsearch configuration.
![edit-deployment-settings](https://www.elastic.co/docs/reference/search-ui/images/edit-settings.png)
You can do this in cloud by going to the deployment settings for your Elasticsearch instance, click "Edit user settings and plugins" and under "user settings", add the CORS configuration below:
```yaml
http.cors.allow-origin: "*"
http.cors.enabled: true
http.cors.allow-credentials: true
http.cors.allow-methods: OPTIONS, HEAD, GET, POST, PUT, DELETE
http.cors.allow-headers: X-Requested-With, X-Auth-Token, Content-Type, Content-Length, Authorization, Access-Control-Allow-Headers, Accept, x-elastic-client-meta
```

![edit-deployment-settings](https://www.elastic.co/docs/reference/search-ui/images/cors-settings.png)
then save. Your Elasticsearch instance will be restarted and the CORS configuration will be active.