﻿---
title: Product Carousels
description: Carousels can be used to show groups of products into a row and are typically used to show products within a specific category or tag, like "most popular",...
url: https://www.elastic.co/docs/reference/search-ui/solutions-ecommerce-carousel
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Product Carousels
<warning>
  This example uses the App Search connector, which is now deprecated and will no longer be supported. Please use [Elasticsearch Connector](https://www.elastic.co/docs/reference/search-ui/api-connectors-elasticsearch).
</warning>

Carousels can be used to show groups of products into a row and are typically used to show products within a specific category or tag, like "most popular", "best rated" and "on sale".
In this example, we show a carousel of products within the "TVs" category using the `Results` component and overriding the `view`.
You can adjust the number of results returned via the `resultsPerPage` configuration.
![carousel](https://www.elastic.co/docs/reference/search-ui/images/carousel.png)
<tab-set>
  <tab-item title="Component">
    ```jsx
      import { Results, SearchProvider } from "@elastic/react-search-ui";
      import { config } from "./config";

      const CustomResultsView = ({ children }) => {
        return (
          <div className="relative overflow-x-auto">
            <ul className="flex snap-x">{children}</ul>
    ```
  </tab-item>

  <tab-item title="Search UI Config">
    ```js
    import AppSearchAPIConnector from "@elastic/search-ui-app-search-connector";

    const connector = new AppSearchAPIConnector({
    searchKey: "<search-key>",
    engineName: "<engine-name>",
    endpointBase: "<endpoint-base>",
    });

    export const config = () => ({
      alwaysSearchOnInitialLoad: true,
      trackUrlState: false,
      initialState: {
        resultsPerPage: 8
      },
      searchQuery: {
        filters: [{ field: "parent_category", values: ["TVs"] }],
        result_fields: {
          name: {
            raw: {}
          },
          image: { raw: {} },
          url: { raw: {} }
        }
      },
      apiConnector: connector
    });
    ```
  </tab-item>
</tab-set>

<tip>
  [Try the demo in CodeSandbox](https://codesandbox.io/embed/github/elastic/search-ui/tree/main/examples/sandbox?autoresize=1&fontsize=12&initialpath=%2Fecommerce&module=%2Fsrc%2Fpages%2Fecommerce%2Findex.jsx).
</tip>

- [Creating Components](https://www.elastic.co/docs/reference/search-ui/guides-creating-own-components): Build your own components for Search UI.
- [Results](https://www.elastic.co/docs/reference/search-ui/api-react-components-results): Search UI React Results Component.
- [Core API](https://www.elastic.co/docs/reference/search-ui/api-core-configuration): Search UI Configuration API.