﻿---
title: Debugging
description: There is a debug flag available on the configuration for SearchDriver and SearchProvider. Setting this to true will make the searchUI object available...
url: https://www.elastic.co/docs/reference/search-ui/guides-debugging
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Debugging
There is a `debug` flag available on the configuration for `SearchDriver` and `SearchProvider`.
```jsx
<SearchProvider config={
  debug: true
  //...
}>
```

Setting this to `true` will make the `searchUI` object available globally on window. This will allow you to programmatically execute actions in the browser console which can be helpful for debugging.
```js
window.searchUI.addFilter("states", "California", "all");
```

This will also log actions and state updates as they occur to the console in the following form:
```txt
Search UI: Action {Action Name} {Action Parameters}
Search UI: State Update {State to update} {Full State after update}
```