﻿---
title: Adding search bar to header
description: It’s a common pattern to have a search bar in the header of your website. Submitting a query in this search bar usually redirects user to a separate search...
url: https://www.elastic.co/docs/reference/search-ui/guides-adding-search-bar-to-header
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Adding search bar to header
It’s a common pattern to have a search bar in the header of your website. Submitting a query in this search bar usually redirects user to a separate search results page.
To implement this with Search UI use the `<SearchBar>` component and add `onSubmit` prop that redirects user to the search page:
```js
<SearchBox
  onSubmit={(searchTerm) => {
    window.location.href = `${PATH_TO_YOUR_SEARCH_PAGE}?q=${searchTerm}`;
  }}
/>
```

Once the redirect happens, Search UI will pick up the query from the URL and display the results.
<tip>
  View this implementation in our [CodeSandbox example](https://codesandbox.io/embed/github/elastic/search-ui/tree/main/examples/sandbox?autoresize=1&fontsize=12&initialpath=%2Fsearch-bar-in-header&module=%2Fsrc%2Fpages%2Fsearch-bar-in-header%2Findex.jsx).
</tip>

Related documentation:
- [SearchBox component](https://www.elastic.co/docs/reference/search-ui/api-react-components-search-box)