﻿---
title: Overview
description: In ecommerce, to build great search experiences for your customers, you need to focus on these major experiences: Global Search bar: to give customers...
url: https://www.elastic.co/docs/reference/search-ui/ecommerce
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Overview
In ecommerce, to build great search experiences for your customers, you need to focus on these major experiences:
- **Global Search bar**: to give customers the ability to perform a search on any page of your store.
- **Search Page**: to give your customers a place to see results relevant to their query and refine them using facets.
- **Category Page**: to show a list of products from a particular category to help users explore available products.
- **Product Carousel**: to show a list of products within pages like the Homepage or Checkout, or if a query returns no results.
- **Product Detail Page**: to describe the product and provide cross-sell recommendations, like similar products from the same category or "frequently bought with" items.

Below you can see a demo of an ecommerce store built with Search UI. We’re going to use it to demonstrate different concepts in the next several articles.
<tip>
  The full code for this demo is available in the [Search UI repo](https://github.com/elastic/search-ui/tree/main/examples/sandbox), using the code located under `examples/sandbox/src/pages/ecommerce`.You can also [try the ecommerce demo in CodeSandbox](https://codesandbox.io/embed/github/elastic/search-ui/tree/main/examples/sandbox?autoresize=1&fontsize=12&initialpath=%2Fecommerce&module=%2Fsrc%2Fpages%2Fecommerce%2Findex.jsx).
</tip>


## Related Articles

- [Autocomplete](https://www.elastic.co/docs/reference/search-ui/solutions-ecommerce-autocomplete): Provide suggestions to customers as they type in a search query.
- [Search Page](https://www.elastic.co/docs/reference/search-ui/solutions-ecommerce-search-page): Display products that match a customer’s search query.
- [Category Page](https://www.elastic.co/docs/reference/search-ui/solutions-ecommerce-category-page): Show a list of products in a particular category.