﻿---
title: useSearch hook
description: In addition, to using withSearch you can now use useSearch hook in your custom react functional component. In order to use this hook, you should wrap...
url: https://www.elastic.co/docs/reference/search-ui/api-react-use-search
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# useSearch hook
In addition, to using `withSearch` you can now use `useSearch` hook in your custom react functional component.

## Usage

In order to use this hook, you should wrap your functional component in `SearchProvider`. We will see an example on how to use useSearch hook to render "loading" indicator when the application is fetching data.
```
const Component = () => {
  const { isLoading } = useSearch();
  return (
    <div className="App">
      {isLoading && <div>I'm loading now</div>}
      {!isLoading && (
        <Layout
          header={<SearchBox />}
          bodyContent={<Results titleField="title" urlField="nps_link" />}
        />
      )}
    </div>
  );
};
export const App = () => {
  return (
    <SearchProvider config={config}>
      <Component />
    </SearchProvider>
  );
};
```