﻿---
title: ResultsPerPage
description: Shows a dropdown for selecting the number of results to show per page. Uses [20, 40, 60] as default options. You can use options prop to pass custom options...
url: https://www.elastic.co/docs/reference/search-ui/api-react-components-results-per-page
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ResultsPerPage
Shows a dropdown for selecting the number of results to show per page.
Uses [20, 40, 60] as default options. You can use `options` prop to pass custom options.
<note>
  When passing custom options make sure one of the option values match the current `resultsPerPageProp` value, which is 20 by default. To override `resultsPerPage` default value, use the [initial state](/docs/reference/search-ui/api-react-search-provider#api-react-search-provider-initial-state) property.
</note>


## Example

```jsx
import { ResultsPerPage } from "@elastic/react-search-ui";

...

<ResultsPerPage />
```


## Example using custom options

```jsx
import { SearchProvider, ResultsPerPage } from "@elastic/react-search-ui";

<SearchProvider
    config={
        ...
        initialState: {
            resultsPerPage: 5
        }
    }
>
    <ResultsPerPage options={[5, 10, 15]} />
</SearchProvider>
```


## Properties


| Name      | Description                                                                                                                                      |
|-----------|--------------------------------------------------------------------------------------------------------------------------------------------------|
| className |                                                                                                                                                  |
| options   | Type: `number[]`. Dropdown options to select the number of results to show per page.                                                             |
| view      | Used to override the default view for this Component. See [View customization](#api-react-components-results-per-page-view-customization) below. |
| *         | Any other property passed will be passed through and available to use in a Custom View.                                                          |


## View customization

A complete guide to view customization can be found in the [Customization: Component views and HTML](/docs/reference/search-ui/basic-usage#guides-customizing-styles-and-html-customizing-html) section.
The following properties are available in the view:

| Name      | Description                                                                                                          |
|-----------|----------------------------------------------------------------------------------------------------------------------|
| className | Passed through from main component.                                                                                  |
| onChange  | function(value: number) - Call this function with the select value from `options` after a user has made a selection. |
| options   | Passed through from main component.                                                                                  |
| value     | The currently selected option.                                                                                       |

See [ResultsPerPage.tsx](https://github.com/elastic/search-ui/blob/main/packages/react-search-ui-views/src/ResultsPerPage.tsx) for an example.