﻿---
title: Analytics Plugin
description: Use the Analytics Plugin to send analytics events to the Behavioral Analytics Product. Follow the instructions to set up the plugin. Add the Analytics...
url: https://www.elastic.co/docs/reference/search-ui/api-core-plugins-analytics-plugin
products:
  - Search UI
applies_to:
  - Elastic Stack: Generally available
---

# Analytics Plugin
<important>
  The Behavioral Analytics feature was discontinued in Elastic 9.0.0.
</important>

Use the Analytics Plugin to send analytics events to the Behavioral Analytics Product. Follow the instructions to set up the plugin.

## Installation

```bash
yarn add @elastic/search-ui-analytics-plugin
## OR
npm install @elastic/search-ui-analytics-plugin
```


## Basic Usage

Add the Analytics Plugin to your Search UI configuration like so:
```js
import AnalyticsPlugin from "@elastic/search-ui-analytics-plugin";

// search ui configuration
const config = {
  apiConnector: connector,
  searchQuery: { ... },
  plugins: [ AnalyticsPlugin() ]
}
```

By default, the Analytics Plugin will use the Behavioral Analytics client provided when using script tag integration.

### Passing in a custom analytics client

If you integrated Behavioral Analytics using the `@elastic/behavioral-analytics-javascript-tracker` NPM package, you can pass in a custom analytics client to the Analytics Plugin.
```js
import AnalyticsPlugin from "@elastic/search-ui-analytics-plugin";
import { createTracker, getTracker } from "@elastic/behavioral-analytics-javascript-tracker";

createTracker({
  // the DSN can be found in the Behavioral Analytics Collections view page
    dsn: "https://my-analytics-dsn.elastic.co"
})

// search ui configuration
const config = {
  apiConnector: connector,
  searchQuery: { ... },
  plugins: [
    AnalyticsPlugin({
      client: getTracker()
    })
  ]
}
```


## Options

The Analytics Plugin accepts the following parameters:

| Option   | Type               | Description                                                                                                                                       | Default                   |
|----------|--------------------|---------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------|
| `client` | `AnalyticsTracker` | The Behavioral Analytics client to use. Read more on [Behavioral Analytics Tracker repo](https://github.com/elastic/behavioral-analytics-tracker) | `window.elasticAnalytics` |