﻿---
title: Core API
description: Core API is the main set of interfaces and configurations used to set up and manage search functionality in Search UI. Core API consists of three main...
url: https://www.elastic.co/docs/reference/search-ui/api-core-index
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Core API
Core API is the main set of interfaces and configurations used to set up and manage search functionality in Search UI.

## Core Components

Core API consists of three main parts:
1. [Configuration](https://www.elastic.co/docs/reference/search-ui/api-core-configuration) - configuration of search queries, autocomplete, and event handlers
2. [State](https://www.elastic.co/docs/reference/search-ui/api-core-state) - application state management, including:
   - Request State
- Response State
- Application State
3. [Actions](https://www.elastic.co/docs/reference/search-ui/api-core-actions) - functions to update the Request State and perform API requests, including:
   - Search term management
- Filter operations
- Sorting
- Pagination
- Analytics tracking


## Key Features

- Search query configuration with support for filters and facets
- Autocomplete and suggestions configuration
- Application state management
- Integration with various search backends through connectors
- URL state and routing configuration


## Usage Example

```jsx
import { SearchProvider } from "@elastic/react-search-ui";

const config = {
  apiConnector: connector,
  searchQuery: {
    facets: {
      states: { type: "value", size: 30 }
    }
  },
  autocompleteQuery: {
    results: {
      resultsPerPage: 5
    }
  }
};

<SearchProvider config={config}>{/* Search UI components */}</SearchProvider>;
```