﻿---
title: Elastic Zoom connector reference
description: The Zoom connector is written in Python using the Elastic connector framework. View the source code for this connector (branch main, compatible with Elastic...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-zoom
products:
  - Elasticsearch
---

# Elastic Zoom connector reference
The Zoom connector is written in Python using the [Elastic connector framework](https://github.com/elastic/connectors/tree/main).
View the [**source code** for this connector](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/zoom) (branch *main*, compatible with Elastic *9.0*).

## **Self-managed connector reference**


### Availability and prerequisites

This connector is available as a self-managed connector. To use this connector, satisfy all [self-managed connector prerequisites](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors).
<note>
  This connector is in **technical preview** and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Technical preview features are not subject to the support SLA of official GA features.
</note>


### Create a Zoom connector


#### Use the UI

To create a new Zoom connector:
1. In the Kibana UI, search for "connectors" using the [global search field](https://www.elastic.co/docs/explore-analyze/query-filter/filtering#_finding_your_apps_and_objects) and choose the "Elasticsearch" connectors.
2. Follow the instructions to create a new  **Zoom** self-managed connector.


#### Use the API

You can use the Elasticsearch [Create connector API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) to create a new self-managed Zoom self-managed connector.
For example:
```json

{
  "index_name": "my-elasticsearch-index",
  "name": "Content synced from Zoom",
  "service_type": "zoom"
}
```

<dropdown title="You’ll also need to create an API key for the connector to use.">
  <note>
    The user needs the cluster privileges `manage_api_key`, `manage_connector` and `write_connector_secrets` to generate API keys programmatically.
  </note>
  To create an API key for the connector:
  1. Run the following command, replacing values where indicated. Note the `encoded` return values from the response:
     ```json

     {
       "name": "connector_name-connector-api-key",
       "role_descriptors": {
         "connector_name-connector-role": {
           "cluster": [
             "monitor",
             "manage_connector"
           ],
           "indices": [
             {
               "names": [
                 "index_name",
                 ".search-acl-filter-index_name",
                 ".elastic-connectors*"
               ],
               "privileges": [
                 "all"
               ],
               "allow_restricted_indices": false
             }
           ]
         }
       }
     }
     ```
  2. Update your `config.yml` file with the API key `encoded` value.
</dropdown>

Refer to the [Elasticsearch API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) for details of all available Connector APIs.

### Usage

To use this connector in the UI, select the **Teams** tile when creating a new connector under **Search → Connectors**.
If you’re already familiar with how connectors work, you can also use the [Connector APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector).
For additional operations, see [*Connectors UI in Kibana*](https://www.elastic.co/docs/reference/search-connectors/connectors-ui-in-kibana).

### Connecting to Zoom

To connect to Zoom you need to [create an Server-to-Server OAuth application](https://developers.zoom.us/docs/internal-apps/s2s-oauth/) that can access resources. Follow these steps:
1. Go to the [Zoom App Marketplace](https://marketplace.zoom.us/) and sign in with your Zoom account.
2. Navigate to the "Develop" service.
3. Select "Build App" from the dropdown menu.
4. Click on the "Server-to-Server OAuth" button to register a new application.
5. Provide a name for your app.
6. Click on the "Create" button to create the app registration.
7. After the registration is complete, you will be redirected to the app’s overview page. Take note of the "App Credentials" value, as you’ll need it later.
8. Navigate to the "Scopes" section and click on the "Add Scopes" button.
9. The following granular scopes need to be added to the app.
   ```bash
   user:read:list_users:admin
   meeting:read:list_meetings:admin
   meeting:read:list_past_participants:admin
   cloud_recording:read:list_user_recordings:admin
   team_chat:read:list_user_channels:admin
   team_chat:read:list_user_messages:admin
   ```

<admonition title="Admonition">
  The connector requires a minimum scope of `user:read:list_users:admin` to ingest data into Elasticsearch.
</admonition>

- 1. Click on the "Done" button to add the selected scopes to your app. 11. Navigate to the "Activation" section and input the necessary information to activate the app.

After completion, use the following configuration parameters to configure the connector.

### Configuration

The following configuration fields are required:
<definitions>
  <definition term="Zoom application Account ID">
    (required) "Account ID" is a unique identifier associated with a specific Zoom account within the Zoom platform, found on the app’s overview page. Example:
    - `KVx-aQssTOutOAGrDfgMaA`
  </definition>
  <definition term="Zoom application Client ID">
    (required) "Client ID" refers to a unique identifier associated with an application that integrates with the Zoom platform, found on the app’s overview page. Example:
    - `49Z69_rnRiaF4JYyfHusw`
  </definition>
  <definition term="Zoom application Client Secret">
    (required) The "Client Secret" refers to a confidential piece of information generated when developers register an application on the Zoom Developer Portal for integration with the Zoom platform, found on the app’s overview page. Example:
    - `eieiUJRsiH543P5NbYadavczjkqgdRTw`
  </definition>
  <definition term="Recording Age Limit (Months)">
    (required) How far back in time to request recordings from Zoom. Recordings older than this will not be indexed. This configuration parameter allows you to define a time limit, measured in months, for which recordings will be indexed.
  </definition>
  <definition term="Fetch past meeting details">
    Retrieve more information about previous meetings, including their details and participants. Default value is `False`. Enable this option to fetch past meeting details. This setting can increase sync time.
  </definition>
</definitions>


#### Deployment using Docker

You can deploy the Zoom connector as a self-managed connector using Docker. Follow these instructions.
<dropdown title="Step 1: Download sample configuration file">
  Download the sample configuration file. You can either download it manually or run the following command:
  ```sh
  curl https://raw.githubusercontent.com/elastic/connectors/main/app/connectors_service/config.yml.example --output ~/connectors-config/config.yml
  ```
  Remember to update the `--output` argument value if your directory name is different, or you want to use a different config file name.
</dropdown>

<dropdown title="Step 2: Update the configuration file for your self-managed connector">
  Update the configuration file with the following settings to match your environment:
  - `elasticsearch.host`
  - `elasticsearch.api_key`
  - `connectors`
  If you’re running the connector service against a Dockerized version of Elasticsearch and Kibana, your config file will look like this:
  ```yaml
  # When connecting to your cloud deployment you should edit the host value
  elasticsearch.host: http://host.docker.internal:9200
  elasticsearch.api_key: <ELASTICSEARCH_API_KEY>

  connectors:
    -
      connector_id: <CONNECTOR_ID_FROM_KIBANA>
      service_type: zoom
      api_key: <CONNECTOR_API_KEY_FROM_KIBANA>
  ```
  Using the `elasticsearch.api_key` is the recommended authentication method. However, you can also use `elasticsearch.username` and `elasticsearch.password` to authenticate with your Elasticsearch instance.Note: You can change other default configurations by simply uncommenting specific settings in the configuration file and modifying their values.
</dropdown>

<dropdown title="Step 3: Run the Docker image">
  Run the Docker image with the Connector Service using the following command:
  ```sh
  docker run \
  -v ~/connectors-config:/config \
  --network "elastic" \
  --tty \
  --rm \
  docker.elastic.co/integrations/elastic-connectors:9.3.0 \
  /app/bin/elastic-ingest \
  -c /config/config.yml
  ```
</dropdown>

Refer to [`DOCKER.md`](https://github.com/elastic/connectors/tree/main/docs/DOCKER.md) in the `elastic/connectors` repo for more details.
Find all available Docker images in the [official registry](https://www.docker.elastic.co/r/integrations/elastic-connectors).
<tip>
  We also have a quickstart self-managed option using Docker Compose, so you can spin up all required services at once: Elasticsearch, Kibana, and the connectors service. Refer to this [README](https://github.com/elastic/connectors/tree/main/scripts/stack#readme) in the `elastic/connectors` repo for more information.
</tip>


#### Content Extraction

Refer to [content extraction](https://www.elastic.co/docs/reference/search-connectors/es-connectors-content-extraction).

### Documents and syncs

The connector syncs the following objects and entities:
- **Users**
- **Live Meetings**
- **Upcoming Meetings**
- **Past Meetings**
- **Recordings**
- **Channels**
- **Chat Messages**
- **Chat Files**

<note>
  - Content from files bigger than 10 MB won’t be extracted by default. You can use the [self-managed local extraction service](/docs/reference/search-connectors/es-connectors-content-extraction#es-connectors-content-extraction-local) to handle larger binary files.
  - Permissions are not synced. **All documents** indexed to an Elastic deployment will be visible to **all users with access** to that Elastic Deployment.
</note>


#### Sync types

[Full syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-full) are supported by default for all connectors.
This connector also supports [incremental syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-incremental).

### Sync rules

[Basic sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-basic) are identical for all connectors and are available by default.

### Advanced Sync Rules

Advanced sync rules are not available for this connector in the present version.

### Connector Client operations


#### End-to-end Testing

The connector framework enables operators to run functional tests against a real data source. Refer to [Connector testing](/docs/reference/search-connectors/self-managed-connectors#es-build-connector-testing) for more details.
To perform E2E testing for the Zoom connector, run the following command:
```shell
$ make ftest NAME=zoom
```

For faster tests, add the `DATA_SIZE=small` flag:
```shell
make ftest NAME=zoom DATA_SIZE=small
```


### Known issues

- **Meetings**: Users can only index meetings that are less than a month old.
- **Chat Messages & Files**:Users can only index chats and files that are less than 6 months old.

Refer to [Known issues](https://www.elastic.co/docs/release-notes/elasticsearch/known-issues) for a list of known issues for *all* connectors.

### Troubleshooting

See [Troubleshooting](https://www.elastic.co/docs/reference/search-connectors/es-connectors-troubleshooting).

### Security

See [Security](https://www.elastic.co/docs/reference/search-connectors/es-connectors-security).