﻿---
title: Elastic SharePoint Server connector reference
description: The Elastic SharePoint Server connector is a connector for Microsoft SharePoint Server. This connector is written in Python using the open code Elastic...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint
products:
  - Elasticsearch
---

# Elastic SharePoint Server connector reference
The *Elastic SharePoint Server connector* is a [connector](https://www.elastic.co/docs/reference/search-connectors) for [Microsoft SharePoint Server](https://www.microsoft.com/en-ww/microsoft-365/sharepoint/).
This connector is written in Python using the open code [Elastic connector framework](https://github.com/elastic/connectors/tree/main). View the [source code for this connector](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/sharepoint/sharepoint_server).
<tip>
  Looking for the SharePoint **Online** connector? See the [SharePoint Online reference](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint-online).
</tip>


## **Self-managed connector reference**


### Availability and prerequisites

This connector is available as a self-managed connector. This self-managed connector is compatible with Elastic versions **8.9.0+**. To use this connector, satisfy all [self-managed connector requirements](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors).
<note>
  This connector is in **beta** and is subject to change. Beta features are subject to change and are not covered by the support SLA of generally available (GA) features.
</note>


### Create a SharePoint Server connector


#### Use the UI

To create a new SharePoint Server connector:
1. In the Kibana UI, search for "connectors" using the [global search field](https://www.elastic.co/docs/explore-analyze/query-filter/filtering#_finding_your_apps_and_objects) and choose the "Elasticsearch" connectors.
2. Follow the instructions to create a new  **SharePoint Server** self-managed connector.


#### Use the API

You can use the Elasticsearch [Create connector API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) to create a new self-managed SharePoint Server self-managed connector.
For example:
```json

{
  "index_name": "my-elasticsearch-index",
  "name": "Content synced from SharePoint Server",
  "service_type": "sharepoint_server"
}
```

<dropdown title="You’ll also need to create an API key for the connector to use.">
  <note>
    The user needs the cluster privileges `manage_api_key`, `manage_connector` and `write_connector_secrets` to generate API keys programmatically.
  </note>
  To create an API key for the connector:
  1. Run the following command, replacing values where indicated. Note the `encoded` return values from the response:
     ```json

     {
       "name": "connector_name-connector-api-key",
       "role_descriptors": {
         "connector_name-connector-role": {
           "cluster": [
             "monitor",
             "manage_connector"
           ],
           "indices": [
             {
               "names": [
                 "index_name",
                 ".search-acl-filter-index_name",
                 ".elastic-connectors*"
               ],
               "privileges": [
                 "all"
               ],
               "allow_restricted_indices": false
             }
           ]
         }
       }
     }
     ```
  2. Update your `config.yml` file with the API key `encoded` value.
</dropdown>

Refer to the [Elasticsearch API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) for details of all available Connector APIs.

### Usage

To use this connector as a **self-managed connector**, see [*Self-managed connectors*](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors).
For additional operations, see [*Connectors UI in Kibana*](https://www.elastic.co/docs/reference/search-connectors/connectors-ui-in-kibana).

### Compatibility

The following SharePoint Server versions are compatible with the Elastic connector framework:
- SharePoint 2013
- SharePoint 2016
- SharePoint 2019


### Configuration

The following configuration fields are required to set up the connector:
<definitions>
  <definition term="authentication">
    Authentication mode, either **Basic** or **NTLM**.
  </definition>
  <definition term="username">
    The username of the account for the SharePoint Server instance.
  </definition>
  <definition term="password">
    The password of the account.
  </definition>
  <definition term="host_url">
    The server host url where the SharePoint Server instance is hosted. Examples:
    - `https://192.158.1.38:8080`
    - `https://<tenant_name>.sharepoint.com`
  </definition>
  <definition term="site_collections">
    Comma-separated list of site collections to fetch from SharePoint Server. Examples:
    - `collection1`
    - `collection1, collection2`
  </definition>
</definitions>

To index from the root of all site collections, simply specify your SharePoint server URL in the `site_collections` field.
<definitions>
  <definition term="ssl_enabled">
    Whether SSL verification will be enabled. Default value is `False`.
  </definition>
  <definition term="ssl_ca">
    Content of SSL certificate needed for the SharePoint Server instance. Keep this field empty, if `ssl_enabled` is set to `False`.
    Example certificate:
    ```txt
    -----BEGIN CERTIFICATE-----
    MIID+jCCAuKgAwIBAgIGAJJMzlxLMA0GCSqGSIb3DQEBCwUAMHoxCzAJBgNVBAYT
    ...
    7RhLQyWn2u00L7/9Omw=
    -----END CERTIFICATE-----
    ```
  </definition>
  <definition term="retry_count">
    The number of retry attempts after failed request to the SharePoint Server instance. Default value is `3`.
  </definition>
  <definition term="use_document_level_security">
    Toggle to enable [Document level security (DLS)](https://www.elastic.co/docs/reference/search-connectors/document-level-security). When enabled, full syncs will fetch access control lists for each document and store them in the `_allow_access_control` field. Access control syncs fetch users' access control lists and store them in a separate index.
    Once enabled, the following granular permissions toggles will be available:
    - **Fetch unique list permissions**: Enable this option to fetch unique **list** permissions. If this setting is disabled a list will inherit permissions from its parent site.
    - **Fetch unique list item permissions**: Enable this option to fetch unique **list item** permissions. If this setting is disabled a list item will inherit permissions from its parent site.
    If left empty the default value `true` will be used for these granular permissions toggles. Note that these settings may increase sync times.
  </definition>
</definitions>


### Deployment using Docker

You can deploy the SharePoint Server connector as a self-managed connector using Docker. Follow these instructions.
<dropdown title="Step 1: Download sample configuration file">
  Download the sample configuration file. You can either download it manually or run the following command:
  ```sh
  curl https://raw.githubusercontent.com/elastic/connectors/main/app/connectors_service/config.yml.example --output ~/connectors-config/config.yml
  ```
  Remember to update the `--output` argument value if your directory name is different, or you want to use a different config file name.
</dropdown>

<dropdown title="Step 2: Update the configuration file for your self-managed connector">
  Update the configuration file with the following settings to match your environment:
  - `elasticsearch.host`
  - `elasticsearch.api_key`
  - `connectors`
  If you’re running the connector service against a Dockerized version of Elasticsearch and Kibana, your config file will look like this:
  ```yaml
  # When connecting to your cloud deployment you should edit the host value
  elasticsearch.host: http://host.docker.internal:9200
  elasticsearch.api_key: <ELASTICSEARCH_API_KEY>

  connectors:
    -
      connector_id: <CONNECTOR_ID_FROM_KIBANA>
      service_type: sharepoint_server
      api_key: <CONNECTOR_API_KEY_FROM_KIBANA>
  ```
  Using the `elasticsearch.api_key` is the recommended authentication method. However, you can also use `elasticsearch.username` and `elasticsearch.password` to authenticate with your Elasticsearch instance.Note: You can change other default configurations by simply uncommenting specific settings in the configuration file and modifying their values.
</dropdown>

<dropdown title="Step 3: Run the Docker image">
  Run the Docker image with the Connector Service using the following command:
  ```sh
  docker run \
  -v ~/connectors-config:/config \
  --network "elastic" \
  --tty \
  --rm \
  docker.elastic.co/integrations/elastic-connectors:9.3.0 \
  /app/bin/elastic-ingest \
  -c /config/config.yml
  ```
</dropdown>

Refer to [`DOCKER.md`](https://github.com/elastic/connectors/tree/main/docs/DOCKER.md) in the `elastic/connectors` repo for more details.
Find all available Docker images in the [official registry](https://www.docker.elastic.co/r/integrations/elastic-connectors).
<tip>
  We also have a quickstart self-managed option using Docker Compose, so you can spin up all required services at once: Elasticsearch, Kibana, and the connectors service. Refer to this [README](https://github.com/elastic/connectors/tree/main/scripts/stack#readme) in the `elastic/connectors` repo for more information.
</tip>


### Documents and syncs

The connector syncs the following SharePoint object types:
- Sites and Subsites
- Lists
- List Items and its attachment content
- Document Libraries and its attachment content(include Web Pages)

<note>
  - Content from files bigger than 10 MB won’t be extracted by default. Use the [self-managed local extraction service](/docs/reference/search-connectors/es-connectors-content-extraction#es-connectors-content-extraction-local) to handle larger binary files.
  - Permissions are not synced. **All documents** indexed to an Elastic deployment will be visible to **all users with access** to that Elasticsearch Index.
</note>


#### Sync types

[Full syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-full) are supported by default for all connectors.
This connector also supports [incremental syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-incremental), but this feature is currently disabled by default. Refer to the linked documentation for enabling incremental syncs.

### Document level security

Document level security (DLS) enables you to restrict access to documents based on a user’s permissions. Refer to [configuration](#es-connectors-sharepoint-client-configuration) on this page for how to enable DLS for this connector.
<note>
  Refer to [DLS in Search Applications](https://www.elastic.co/docs/reference/search-connectors/es-dls-e2e-guide) to learn how to ingest data from a connector with DLS enabled, when building a search application. The example uses SharePoint Online as the data source, but the same steps apply to every connector.
</note>


### Sync rules

[Basic sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-basic) are identical for all connectors and are available by default.
Advanced sync rules are not available for this connector in the present version. Currently filtering is controlled via ingest pipelines.

### Content Extraction

See [Content extraction](https://www.elastic.co/docs/reference/search-connectors/es-connectors-content-extraction).

### Self-managed connector operations


### End-to-end testing

The connector framework enables operators to run functional tests against a real data source. Refer to [Connector testing](/docs/reference/search-connectors/self-managed-connectors#es-build-connector-testing) for more details.
To perform E2E testing for the sharepoint connector, run the following command:
```shell
$ make ftest NAME=sharepoint_server
```

For faster tests, add the `DATA_SIZE=small` flag:
```shell
make ftest NAME=sharepoint_server DATA_SIZE=small
```


### Known issues

There are currently no known issues for this connector. Refer to [Known issues](https://www.elastic.co/docs/release-notes/elasticsearch/known-issues) for a list of known issues for all connectors.

### Troubleshooting

See [Troubleshooting](https://www.elastic.co/docs/reference/search-connectors/es-connectors-troubleshooting).

### Security

See [Security](https://www.elastic.co/docs/reference/search-connectors/es-connectors-security).

### Framework and source

This connector is written in Python using the [Elastic connector framework](https://github.com/elastic/connectors/tree/main).
View the [source code for this connector](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/sharepoint/sharepoint_server) (branch *main*, compatible with Elastic *9.0*).