﻿---
title: Elastic ServiceNow connector reference
description: The Elastic ServiceNow connector is a connector for ServiceNow. This connector is written in Python using the Elastic connector framework. View the source...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-servicenow
products:
  - Elasticsearch
---

# Elastic ServiceNow connector reference
The *Elastic ServiceNow connector* is a [connector](https://www.elastic.co/docs/reference/search-connectors) for [ServiceNow](https://www.servicenow.com).
This connector is written in Python using the [Elastic connector framework](https://github.com/elastic/connectors/tree/main).
View the [**source code** for this connector](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/servicenow) (branch *main*, compatible with Elastic *9.0*).

## **Self-managed connector**


### Availability and prerequisites

The ServiceNow connector was introduced in Elastic version 8.9.0. This connector is available as a self-managed connector. To use this connector as a self-managed connector, satisfy all [self-managed connector requirements](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors).

### Create a ServiceNow connector


#### Use the UI

To create a new ServiceNow connector:
1. In the Kibana UI, search for "connectors" using the [global search field](https://www.elastic.co/docs/explore-analyze/query-filter/filtering#_finding_your_apps_and_objects) and choose the "Elasticsearch" connectors.
2. Follow the instructions to create a new  **ServiceNow** self-managed connector.


#### Use the API

You can use the Elasticsearch [Create connector API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) to create a new self-managed ServiceNow self-managed connector.
For example:
```json

{
  "index_name": "my-elasticsearch-index",
  "name": "Content synced from ServiceNow",
  "service_type": "servicenow"
}
```

<dropdown title="You’ll also need to create an API key for the connector to use.">
  <note>
    The user needs the cluster privileges `manage_api_key`, `manage_connector` and `write_connector_secrets` to generate API keys programmatically.
  </note>
  To create an API key for the connector:
  1. Run the following command, replacing values where indicated. Note the `encoded` return values from the response:
     ```json

     {
       "name": "connector_name-connector-api-key",
       "role_descriptors": {
         "connector_name-connector-role": {
           "cluster": [
             "monitor",
             "manage_connector"
           ],
           "indices": [
             {
               "names": [
                 "index_name",
                 ".search-acl-filter-index_name",
                 ".elastic-connectors*"
               ],
               "privileges": [
                 "all"
               ],
               "allow_restricted_indices": false
             }
           ]
         }
       }
     }
     ```
  2. Update your `config.yml` file with the API key `encoded` value.
</dropdown>

Refer to the [Elasticsearch API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) for details of all available Connector APIs.

### Usage

To use this connector as a **self-managed connector**, use the **Customized connector** workflow.
For additional operations, see [Usage](https://www.elastic.co/docs/reference/search-connectors/connectors-ui-in-kibana).

### Compatibility

The ServiceNow connector is compatible with the following versions of ServiceNow:
- ServiceNow "Tokyo"
- ServiceNow "San Diego"
- ServiceNow "Rome"
- ServiceNow "Utah"
- ServiceNow "Vancouver"
- ServiceNow "Washington"
- ServiceNow "Xanadu"


### Configuration

The following configuration fields are required to set up the connector:
<definitions>
  <definition term="url">
    The host url of the ServiceNow instance.
  </definition>
  <definition term="username">
    The username of the account for ServiceNow.
  </definition>
  <definition term="password">
    The password of the account used for ServiceNow.
  </definition>
  <definition term="services">
    Comma-separated list of services to fetch data from ServiceNow. If the value is `*`, the connector will fetch data from the list of basic services provided by ServiceNow:
    - [User](https://www.servicenow.com/docs/bundle/vancouver-platform-administration/page/administer/roles/concept/user.html)
    - [Incident](https://www.servicenow.com/docs/bundle/vancouver-it-service-management/page/product/incident-management/concept/c_IncidentManagement.html)
    - [Requested Item](https://www.servicenow.com/docs/bundle/vancouver-servicenow-platform/page/use/service-catalog-requests/task/t_AddNewRequestItems.html)
    - [Knowledge](https://www.servicenow.com/docs/bundle/vancouver-servicenow-platform/page/product/knowledge-management/concept/c_KnowledgeHomepage.html)
    - [Change request](https://www.servicenow.com/docs/bundle/vancouver-it-service-management/page/product/change-management/task/t_CreateAChange.html)
    If you have configured a custom service, the `*` value will not fetch data from the basic services above by default. In this case you’ll need to mention these service names explicitly.
    Default value is `*`. Examples:
    - `User, Incident, Requested Item, Knowledge, Change request`
    - `*`
  </definition>
  <definition term="retry_count">
    The number of retry attempts after a failed request to ServiceNow. Default value is `3`.
  </definition>
  <definition term="concurrent_downloads">
    The number of concurrent downloads for fetching the attachment content. This speeds up the content extraction of attachments. Defaults to `10`.
  </definition>
  <definition term="use_text_extraction_service">
    Requires a separate deployment of the [Elastic Text Extraction Service](/docs/reference/search-connectors/es-connectors-content-extraction#es-connectors-content-extraction-local). Requires that ingest pipeline settings disable text extraction. Default value is `False`.
  </definition>
  <definition term="use_document_level_security">
    Restrict access to documents based on a user’s permissions. Refer to [Document level security](#es-connectors-servicenow-client-dls) for more details.
  </definition>
</definitions>


### Documents and syncs

All services and records the user has access to will be indexed according to the configurations provided. The connector syncs the following ServiceNow object types:
- Records
- Attachments

<note>
  - Content from files bigger than 10 MB won’t be extracted. Use the [self-managed local extraction service](/docs/reference/search-connectors/es-connectors-content-extraction#es-connectors-content-extraction-local) to handle larger binary files.
  - Permissions are not synced by default. You must enable [document level security](https://www.elastic.co/docs/reference/search-connectors/document-level-security). Otherwise, **all documents** indexed to an Elastic deployment will be visible to **all users with access** to that Elastic Deployment.
</note>


#### Sync types

[Full syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-full) are supported by default for all connectors.
This connector also supports [incremental syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-incremental).

### Document level security

[Document level security (DLS)](https://www.elastic.co/docs/reference/search-connectors/document-level-security) ensures identities and permissions set in ServiceNow are maintained in Elasticsearch. This enables you to restrict and personalize read-access users and groups have to documents in this index. Access control syncs ensure this metadata is kept up to date in your Elasticsearch documents.
The ServiceNow connector supports roles for access control lists (ACLs) to enable document level security in Elasticsearch. For default services, connectors use the following roles to find users who have access to documents.

| Service        | Roles                                                                      |
|----------------|----------------------------------------------------------------------------|
| User           | `admin`                                                                    |
| Incident       | `admin`, `sn_incident_read`, `ml_report_user`, `ml_admin`, `itil`          |
| Requested Item | `admin`, `sn_request_read`, `asset`, `atf_test_designer`, `atf_test_admin` |
| Knowledge      | `admin`, `knowledge`, `knowledge_manager`, `knowledge_admin`               |
| Change request | `admin`, `sn_change_read`, `itil`                                          |

For services other than these defaults, the connector iterates over access controls with `read` operations and finds the respective roles for those services.
<important>
  The ServiceNow connector applies access control at the service (table) level. This means documents within a given ServiceNow table share the same access control settings. Users with permission to a table can access all documents from that table in Elasticsearch.
</important>

<note>
  The ServiceNow connector does not support scripted and conditional permissions.
</note>


### Deployment using Docker

You can deploy the ServiceNow connector as a self-managed connector using Docker. Follow these instructions.
<dropdown title="Step 1: Download sample configuration file">
  Download the sample configuration file. You can either download it manually or run the following command:
  ```sh
  curl https://raw.githubusercontent.com/elastic/connectors/main/app/connectors_service/config.yml.example --output ~/connectors-config/config.yml
  ```
  Remember to update the `--output` argument value if your directory name is different, or you want to use a different config file name.
</dropdown>

<dropdown title="Step 2: Update the configuration file for your self-managed connector">
  Update the configuration file with the following settings to match your environment:
  - `elasticsearch.host`
  - `elasticsearch.api_key`
  - `connectors`
  If you’re running the connector service against a Dockerized version of Elasticsearch and Kibana, your config file will look like this:
  ```yaml
  # When connecting to your cloud deployment you should edit the host value
  elasticsearch.host: http://host.docker.internal:9200
  elasticsearch.api_key: <ELASTICSEARCH_API_KEY>

  connectors:
    -
      connector_id: <CONNECTOR_ID_FROM_KIBANA>
      service_type: servicenow
      api_key: <CONNECTOR_API_KEY_FROM_KIBANA>
  ```
  Using the `elasticsearch.api_key` is the recommended authentication method. However, you can also use `elasticsearch.username` and `elasticsearch.password` to authenticate with your Elasticsearch instance.Note: You can change other default configurations by simply uncommenting specific settings in the configuration file and modifying their values.
</dropdown>

<dropdown title="Step 3: Run the Docker image">
  Run the Docker image with the Connector Service using the following command:
  ```sh
  docker run \
  -v ~/connectors-config:/config \
  --network "elastic" \
  --tty \
  --rm \
  docker.elastic.co/integrations/elastic-connectors:9.3.0 \
  /app/bin/elastic-ingest \
  -c /config/config.yml
  ```
</dropdown>

Refer to [`DOCKER.md`](https://github.com/elastic/connectors/tree/main/docs/DOCKER.md) in the `elastic/connectors` repo for more details.
Find all available Docker images in the [official registry](https://www.docker.elastic.co/r/integrations/elastic-connectors).
<tip>
  We also have a quickstart self-managed option using Docker Compose, so you can spin up all required services at once: Elasticsearch, Kibana, and the connectors service. Refer to this [README](https://github.com/elastic/connectors/tree/main/scripts/stack#readme) in the `elastic/connectors` repo for more information.
</tip>


### Sync rules

[Basic sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-basic) are identical for all connectors and are available by default.

#### Advanced sync rules

<note>
  A [full sync](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-full) is required for advanced sync rules to take effect.
</note>

Advanced sync rules are defined through a source-specific DSL JSON snippet.
The following sections provide examples of advanced sync rules for this connector.

**Indexing document based on incident number for Incident service**
```js
[
  {
    "service": "Incident",
    "query": "numberSTARTSWITHINC001"
  }
]
```


**Indexing document based on user activity state for User service**
```js
[
  {
    "service": "User",
    "query": "active=False"
  }
]
```


**Indexing document based on author name for Knowledge service**
```js
[
  {
    "service": "Knowledge",
    "query": "author.nameSTARTSWITHSystem Administrator"
  }
]
```


### End-to-end Testing

The connector framework enables operators to run functional tests against a real data source. Refer to [Connector testing](/docs/reference/search-connectors/self-managed-connectors#es-build-connector-testing) for more details.
To perform E2E testing for the ServiceNow connector, run the following command:
```shell
$ make ftest NAME=servicenow
```

Generate performance reports using the following flag: `PERF8=yes`. Toggle test data set size between SMALL, MEDIUM and LARGE with the argument `DATA_SIZE=`. By default, it is set to `MEDIUM`.
Users do not need to have a running Elasticsearch instance or a ServiceNow source to run this test. Docker Compose manages the complete setup of the development environment.

### Known issues

There are no known issues for this connector. Refer to [Known issues](https://www.elastic.co/docs/release-notes/elasticsearch/known-issues) for a list of known issues that impact all connectors.

### Troubleshooting

See [Troubleshooting](https://www.elastic.co/docs/reference/search-connectors/es-connectors-troubleshooting).

### Security

See [Security](https://www.elastic.co/docs/reference/search-connectors/es-connectors-security).

### Content extraction

See [Content extraction](https://www.elastic.co/docs/reference/search-connectors/es-connectors-content-extraction).