﻿---
title: Connectors security
description: This document describes security considerations for connectors. Self-managed deployments require more upfront work to ensure strong security. Refer to...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-security
products:
  - Elasticsearch
---

# Connectors security
This document describes security considerations for connectors.
Self-managed deployments require more upfront work to ensure strong security. Refer to [Secure the Elastic Stack^](https://www.elastic.co/docs/deploy-manage/security) in the Elasticsearch documentation for more information.

## Access to credentials

Credentials for the data source — such as API keys or username/password pair— are stored in your deployment’s `.elastic-connectors` Elasticsearch index. Therefore, the credentials are visible to all Elastic users with the `read` [indices privilege^](https://www.elastic.co/docs/reference/elasticsearch/security-privileges) for that index. By default, the following Elastic users have this privilege: the `elastic` superuser and the `kibana_system` user. Enterprise Search service account tokens can also read the `.elastic-connectors` index.

### Document-level security

Document-level security is available for a subset of connectors. DLS is available by default for the following connectors:
- [Confluence](https://www.elastic.co/docs/reference/search-connectors/es-connectors-confluence)
- [Dropbox](https://www.elastic.co/docs/reference/search-connectors/es-connectors-dropbox)
- [Jira](https://www.elastic.co/docs/reference/search-connectors/es-connectors-jira) (including Jira Data Center)
- [GitHub](https://www.elastic.co/docs/reference/search-connectors/es-connectors-github)
- [Gmail](https://www.elastic.co/docs/reference/search-connectors/es-connectors-gmail)
- [Google Drive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-google-drive)
- [Network Drive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-network-drive)
- [OneDrive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-onedrive)
- [Outlook](https://www.elastic.co/docs/reference/search-connectors/es-connectors-outlook)
- [Salesforce](https://www.elastic.co/docs/reference/search-connectors/es-connectors-salesforce)
- [SharePoint Online](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint-online)
- [SharePoint Server](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint)
- [ServiceNow](https://www.elastic.co/docs/reference/search-connectors/es-connectors-servicenow)

Learn more about this feature in [*Document level security*](https://www.elastic.co/docs/reference/search-connectors/document-level-security), including availability and prerequisites.

## Access to documents

Data synced from your data source are stored as documents in the Elasticsearch index you created. This data is visible to all Elastic users with the `read` [indices privilege^](https://www.elastic.co/docs/reference/elasticsearch/security-privileges) for that index. Be careful to ensure that access to this index is *at least* as restrictive as access to the original data source.

## Encryption

Elastic Cloud automatically encrypts data at rest. Data in transit is automatically encrypted using `https`.
Self-managed deployments must implement encryption at rest. See [Configure security for the Elastic Stack](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch) in the Elasticsearch documentation for more information.