﻿---
title: Redis connector reference
description: The Redis connector is built with the Elastic connectors Python framework and is available as a self-managed self-managed connector. View the source code...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-redis
products:
  - Elasticsearch
---

# Redis connector reference
The Redis connector is built with the Elastic connectors Python framework and is available as a self-managed [self-managed connector](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors). View the [**source code** for this connector](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/redis) (branch *main*, compatible with Elastic *9.0*).

## Availability and prerequisites

This connector was introduced in Elastic **8.13.0**, available as a **self-managed** self-managed connector.
To use this connector, satisfy all [self-managed connector prerequisites](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors). Importantly, you must deploy the connectors service on your own infrastructure. You have two deployment options:
- [Run connectors service from source](https://www.elastic.co/docs/reference/search-connectors/es-connectors-run-from-source). Use this option if you’re comfortable working with Python and want to iterate quickly locally.
- [Run connectors service in Docker](https://www.elastic.co/docs/reference/search-connectors/es-connectors-run-from-docker). Use this option if you want to deploy the connectors to a server, or use a container orchestration platform.

<note>
  This connector is in **technical preview** and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Technical preview features are not subject to the support SLA of official GA features.
</note>


## Usage

To set up this connector in the UI, select the **Redis** tile when creating a new connector under **Search → Connectors**.
For additional operations, see [*Connectors UI in Kibana*](https://www.elastic.co/docs/reference/search-connectors/connectors-ui-in-kibana).

## Deploy with Docker

You can deploy the Redis connector as a self-managed connector using Docker. Follow these instructions.
<dropdown title="Step 1: Download sample configuration file">
  Download the sample configuration file. You can either download it manually or run the following command:
  ```sh
  curl https://raw.githubusercontent.com/elastic/connectors/main/app/connectors_service/config.yml.example --output ~/connectors-config/config.yml
  ```
  Remember to update the `--output` argument value if your directory name is different, or you want to use a different config file name.
</dropdown>

<dropdown title="Step 2: Update the configuration file for your self-managed connector">
  Update the configuration file with the following settings to match your environment:
  - `elasticsearch.host`
  - `elasticsearch.api_key`
  - `connectors`
  If you’re running the connector service against a Dockerized version of Elasticsearch and Kibana, your config file will look like this:
  ```yaml
  # When connecting to your cloud deployment you should edit the host value
  elasticsearch.host: http://host.docker.internal:9200
  elasticsearch.api_key: <ELASTICSEARCH_API_KEY>

  connectors:
    -
      connector_id: <CONNECTOR_ID_FROM_KIBANA>
      service_type: redis
      api_key: <CONNECTOR_API_KEY_FROM_KIBANA>
  ```
  Using the `elasticsearch.api_key` is the recommended authentication method. However, you can also use `elasticsearch.username` and `elasticsearch.password` to authenticate with your Elasticsearch instance.Note: You can change other default configurations by simply uncommenting specific settings in the configuration file and modifying their values.
</dropdown>

<dropdown title="Step 3: Run the Docker image">
  Run the Docker image with the Connector Service using the following command:
  ```sh
  docker run \
  -v ~/connectors-config:/config \
  --network "elastic" \
  --tty \
  --rm \
  docker.elastic.co/integrations/elastic-connectors:9.3.0 \
  /app/bin/elastic-ingest \
  -c /config/config.yml
  ```
</dropdown>

Refer to [`DOCKER.md`](https://github.com/elastic/connectors/tree/main/docs/DOCKER.md) in the `elastic/connectors` repo for more details.
Find all available Docker images in the [official registry](https://www.docker.elastic.co/r/integrations/elastic-connectors).
<tip>
  We also have a quickstart self-managed option using Docker Compose, so you can spin up all required services at once: Elasticsearch, Kibana, and the connectors service. Refer to this [README](https://github.com/elastic/connectors/tree/main/scripts/stack#readme) in the `elastic/connectors` repo for more information.
</tip>


## Configuration

<definitions>
  <definition term="host (required)">
    The IP of your Redis server/cloud. Example:
    - `127.0.0.1`
    - `redis-12345.us-east-1.ec2.cloud.redislabs.com`
  </definition>
  <definition term="port (required)">
    Port where the Redis server/cloud instance is hosted. Example:
    - `6379`
  </definition>
  <definition term="username (optional)">
    Username for your Redis server/cloud. Example:
    - `default`
  </definition>
  <definition term="password (optional)">
    Password for your Redis server/cloud instance. Example:
    - `changeme`
  </definition>
  <definition term="database  (required)">
    List of database index for your Redis server/cloud. * will fetch data from all databases. Example:
    - `0,1,2`
    - `*`
    This field is ignored when using advanced sync rules.
  </definition>
  <definition term="ssl_enabled">
    Toggle to use SSL/TLS. Disabled by default.
  </definition>
  <definition term="mutual_tls_enabled">
    Toggle to use secure mutual SSL/TLS. Ensure that your Redis deployment supports mutual SSL/TLS connections. Disabled by default. Depends on `ssl_enabled`.
  </definition>
  <definition term="tls_certfile">
    Specifies the certificate from the Certificate Authority. The value of the certificate is used to validate the certificate presented by the Redis instance. Depends on `mutual_tls_enabled`.
  </definition>
  <definition term="tls_keyfile">
    Specifies the client private key. The value of the key is used to validate the connection in the Redis instance. Depends on `mutual_tls_enabled`.
  </definition>
</definitions>


## Documents and syncs

The connector syncs the following objects and entities:
- KEYS and VALUES of every database index

<note>
  - Permissions are not synced. **All documents** indexed to an Elastic deployment will be visible to **all users with access** to the relevant Elasticsearch index.
</note>


## Sync rules

[Basic sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-basic) are identical for all connectors and are available by default.

## Advanced Sync Rules

[Advanced sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-advanced) are defined through a source-specific DSL JSON snippet.
Use advanced sync rules to filter data at the Redis source, without needing to index all data into Elasticsearch.
They take the following parameters:
1. `database`:  Specify the Redis database index as an integer value.
2. `key_pattern`: 2. `key_pattern`: Pattern for finding keys in Redis.
3. `type`: Key type for the Redis.
   Supported values:
   - `HASH`
- `LIST`
- `SET`
- `STREAM`
- `STRING`
- `ZSET`

<note>
  Provide at least one of the following: `key_pattern` or `type`, or both.
</note>


### Advanced sync rules examples


#### Example 1

**Fetch database records where keys start with `alpha`**:
```js
[
  {
    "database": 0,
    "key_pattern": "alpha*"
  }
]
```


#### Example 2

**Fetch database records with exact match by specifying the full key name:**
```js
[
  {
    "database": 0,
    "key_pattern": "alpha"
  }
]
```


#### Example 3

**Fetch database records where keys start with `test1`, `test2` or `test3`:**
```js
[
  {
    "database": 0,
    "key_pattern": "test[123]"
  }
```


#### Example 4

**Exclude database records where keys start with `test1`, `test2` or `test3`:**
```js
[
  {
    "database": 0,
    "key_pattern": "test[^123]"
  }
]
```


#### Example 5

**Fetch all database records:**
```js
[
  {
    "database": 0,
    "key_pattern": "*"
  }
]
```


#### Example 6

**Fetch all database records where type is `SET`:**
```js
[
  {
    "database": 0,
    "key_pattern": "*",
    "type": "SET"
  }
]
```


#### Example 7

**Fetch database records where type is `SET`**:
```js
[
  {
    "database": 0,
    "type": "SET"
  }
]
```


## Connector Client operations


### End-to-end Testing

The connector framework enables operators to run functional tests against a real data source, using Docker Compose. You don’t need a running Elasticsearch instance or Redis source to run this test.
Refer to [Connector testing](/docs/reference/search-connectors/self-managed-connectors#es-build-connector-testing) for more details.
To perform E2E testing for the Redis connector, run the following command:
```shell
$ make ftest NAME=redis
```

For faster tests, add the `DATA_SIZE=small` flag:
```shell
make ftest NAME=redis DATA_SIZE=small
```

By default, `DATA_SIZE=MEDIUM`.

## Known issues

- The last modified time is unavailable when retrieving keys/values from the Redis database. As a result, **all objects** are indexed each time an advanced sync rule query is executed.

Refer to [Known issues](https://www.elastic.co/docs/release-notes/elasticsearch/known-issues) for a list of known issues for all connectors.

## Troubleshooting

See [Troubleshooting](https://www.elastic.co/docs/reference/search-connectors/es-connectors-troubleshooting).

## Security

See [Security](https://www.elastic.co/docs/reference/search-connectors/es-connectors-security).