﻿---
title: Internal knowledge search architecture
description: The following section provides a high-level overview of common architecture approaches for the internal knowledge search use case (AKA workplace search)...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-overview-architecture
products:
  - Elasticsearch
---

# Internal knowledge search architecture
The following section provides a high-level overview of common architecture approaches for the internal knowledge search use case (AKA workplace search).


## Self-managed architecture

Data is synced to an Elastic deployment through self-managed connectors. A self-managed search application exposes the relevant data that your end users are authorized to see in a search experience.
Summary:
- Gives flexibility to build custom solutions tailored to specific business requirements and internal processes
- Allows enterprises to adhere to strict access policies when using firewalls that don’t allow incoming connections to data sources, while outgoing traffic is easier to control
- Provides additional functionality available for self-managed connectors such as the [Extraction Service](/docs/reference/search-connectors/es-connectors-content-extraction#es-connectors-content-extraction-local)
- Feasible for air-gapped environments
- Requires Platinum license for full spectrum of features and self-managed connectors

The following diagram provides a high-level overview of the self-managed internal knowledge search architecture.
![self managed architecture](https://www.elastic.co/docs/reference/search-connectors/images/self-managed-architecture.png)