﻿---
title: Elastic OpenText Documentum connector reference
description: The Elastic OpenText Documentum connector is written in Python using the Elastic connector framework. View the source code for this example connector...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-opentext
products:
  - Elasticsearch
---

# Elastic OpenText Documentum connector reference
<warning>
  This connector is an **example connector** that serves as a building block for customizations and is subject to change. Its source code currently lives on a [feature branch](https://github.com/elastic/connectors/blob/opentext-connector-backup/connectors/sources/opentext_documentum.py) and is yet not part of the main Elastic Connectors codebase. The design and code is less mature than supported features and is being provided as-is with no warranties. This connector is not subject to the support SLA of supported features.
</warning>

The Elastic OpenText Documentum connector is written in Python using the [Elastic connector framework](https://github.com/elastic/connectors/tree/main?tab=readme-ov-file#connector-framework). View the [source code](https://github.com/elastic/connectors/blob/opentext-connector-backup/connectors/sources/opentext_documentum.py) for this example connector.

## Availability and prerequisites

This **example connector** was introduced in Elastic **8.14.0**, available as a **self-managed** self-managed connector on a feature branch, for testing and development purposes only.
To use this connector, satisfy all [self-managed connector prerequisites](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors). Importantly, you must deploy the connectors service on your own infrastructure. You have two deployment options:
- [Run connectors service from source](https://www.elastic.co/docs/reference/search-connectors/es-connectors-run-from-source). Use this option if you’re comfortable working with Python and want to iterate quickly locally.
- [Run connectors service in Docker](https://www.elastic.co/docs/reference/search-connectors/es-connectors-run-from-docker). Use this option if you want to deploy the connectors to a server, or use a container orchestration platform.


## Usage

To set up this connector in the UI, select the **OpenText Documentum** tile when creating a new connector under **Search → Connectors**.
If you’re already familiar with how connectors work, you can also use the [Connector APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector).
For additional operations, see [*Connectors UI in Kibana*](https://www.elastic.co/docs/reference/search-connectors/connectors-ui-in-kibana).

## Connecting to OpenText Documentum

Basic authentication is used to connect with OpenText Documentum.

## Configuration


### Configure OpenText Documentum connector

Note the following configuration fields:
<definitions>
  <definition term="OpenText Documentum host url (required)">
    The domain where OpenText Documentum is hosted. Example: `https://192.158.1.38:2099/`
  </definition>
  <definition term="Username (required)">
    The username of the account to connect to OpenText Documentum.
  </definition>
  <definition term="Password (required)">
    The password of the account to connect to OpenText Documentum.
  </definition>
  <definition term="Repositories (optional)">
    Comma-separated list of repositories to fetch data from OpenText Documentum. If the value is `*` the connector will fetch data from all repositories present in the configured user’s account.
    Default value is `*`.
    Examples:
    - `elastic`, `kibana`
    - `*`
  </definition>
  <definition term="Enable SSL (optional)">
    Enable SSL for the OpenText Documentum instance.
  </definition>
  <definition term="SSL Certificate (Required if SSL is enabled)">
    SSL certificate for the OpenText Documentum instance. Example:
    ```
    -----BEGIN CERTIFICATE-----
    MIID+jCCAuKgAwIBAgIGAJJMzlxLMA0GCSqGSIb3DQEBCwUAMHoxCzAJBgNVBAYT
    ...
    7RhLQyWn2u00L7/9Omw=
    -----END CERTIFICATE-----
    ```
  </definition>
</definitions>


### Content Extraction

Refer to [content extraction](https://www.elastic.co/docs/reference/search-connectors/es-connectors-content-extraction).

## Documents and syncs

The connector syncs the following objects and entities:
- **Repositories**
- **Cabinets**
- **Files & Folders**

<note>
  - Files bigger than 10 MB won’t be extracted.
  - Permissions are not synced. **All documents** indexed to an Elastic deployment will be visible to **all users with access** to the destination Elasticsearch index.
</note>


### Sync types

[Full syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-full) are supported by default for all connectors.
[Incremental syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-incremental) are not available for this connector in the present version.

## Sync rules

[Basic sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-basic) are identical for all connectors and are available by default.
Advanced sync rules are not available for this connector in the present version.

## Connector Client operations


### End-to-end Testing

The connector framework enables operators to run functional tests against a real data source, using Docker Compose. You don’t need a running Elasticsearch instance or OpenText Documentum source to run this test.
Refer to [Connector testing](/docs/reference/search-connectors/self-managed-connectors#es-build-connector-testing) for more details.
To perform E2E testing for the OpenText Documentum connector, run the following command:
```shell
$ make ftest NAME=opentext_documentum
```

For faster tests, add the `DATA_SIZE=small` flag:
```shell
make ftest NAME=opentext_documentum DATA_SIZE=small
```

By default, `DATA_SIZE=MEDIUM`.

## Known issues

- There are no known issues for this connector. Refer to [Known issues](https://www.elastic.co/docs/release-notes/elasticsearch/known-issues) for a list of known issues for all connectors.


## Troubleshooting

See [Troubleshooting](https://www.elastic.co/docs/reference/search-connectors/es-connectors-troubleshooting).

## Security

See [Security](https://www.elastic.co/docs/reference/search-connectors/es-connectors-security).