﻿---
title: Elastic Notion Connector reference
description: The Notion connector is written in Python using the Elastic connector framework. View the source code for this connector (branch main, compatible with...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-notion
products:
  - Elasticsearch
---

# Elastic Notion Connector reference
The Notion connector is written in Python using the [Elastic connector framework](https://github.com/elastic/connectors/tree/main). View the [**source code** for this connector](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/notion) (branch *main*, compatible with Elastic *9.0*).

## **Self-managed connector reference**


### Availability and prerequisites

This connector was introduced in Elastic **8.13.0**, available as a **self-managed** self-managed connector.
To use this connector, satisfy all [self-managed connector prerequisites](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors). Importantly, you must deploy the connectors service on your own infrastructure. You have two deployment options:
- [Run connectors service from source](https://www.elastic.co/docs/reference/search-connectors/es-connectors-run-from-source). Use this option if you’re comfortable working with Python and want to iterate quickly locally.
- [Run connectors service in Docker](https://www.elastic.co/docs/reference/search-connectors/es-connectors-run-from-docker). Use this option if you want to deploy the connectors to a server, or use a container orchestration platform.

<note>
  This connector is in **beta** and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</note>


### Usage

To use this connector in the UI, select the **Notion** tile when creating a new connector under **Search → Connectors**.
For additional operations, see [*Connectors UI in Kibana*](https://www.elastic.co/docs/reference/search-connectors/connectors-ui-in-kibana).

### Create a Notion connector


#### Use the UI

To create a new Notion connector:
1. In the Kibana UI, search for "connectors" using the [global search field](https://www.elastic.co/docs/explore-analyze/query-filter/filtering#_finding_your_apps_and_objects) and choose the "Elasticsearch" connectors.
2. Follow the instructions to create a new  **Notion** self-managed connector.


#### Use the API

You can use the Elasticsearch [Create connector API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) to create a new self-managed Notion self-managed connector.
For example:
```json

{
  "index_name": "my-elasticsearch-index",
  "name": "Content synced from Notion",
  "service_type": "notion"
}
```

<dropdown title="You’ll also need to create an API key for the connector to use.">
  <note>
    The user needs the cluster privileges `manage_api_key`, `manage_connector` and `write_connector_secrets` to generate API keys programmatically.
  </note>
  To create an API key for the connector:
  1. Run the following command, replacing values where indicated. Note the `encoded` return values from the response:
     ```json

     {
       "name": "connector_name-connector-api-key",
       "role_descriptors": {
         "connector_name-connector-role": {
           "cluster": [
             "monitor",
             "manage_connector"
           ],
           "indices": [
             {
               "names": [
                 "index_name",
                 ".search-acl-filter-index_name",
                 ".elastic-connectors*"
               ],
               "privileges": [
                 "all"
               ],
               "allow_restricted_indices": false
             }
           ]
         }
       }
     }
     ```
  2. Update your `config.yml` file with the API key `encoded` value.
</dropdown>

Refer to the [Elasticsearch API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) for details of all available Connector APIs.

### Connecting to Notion

To connect to Notion, the user needs to [create an internal integration](https://www.notion.so/help/create-integrations-with-the-notion-api#create-an-internal-integration) for their Notion workspace, which can access resources using the Internal Integration Secret Token. Configure the Integration with following settings:
1. Users must grant `READ` permission for content, comment and user capabilities for that integration from the Capabilities tab.
2. Users must manually [add the integration as a connection](https://www.notion.so/help/add-and-manage-connections-with-the-api#add-connections-to-pages) to the top-level pages in a workspace. Sub-pages will inherit the connections of the parent page automatically.


### Deploy with Docker

You can deploy the Notion connector as a self-managed connector using Docker. Follow these instructions.
<dropdown title="Step 1: Download sample configuration file">
  Download the sample configuration file. You can either download it manually or run the following command:
  ```sh
  curl https://raw.githubusercontent.com/elastic/connectors/main/app/connectors_service/config.yml.example --output ~/connectors-config/config.yml
  ```
  Remember to update the `--output` argument value if your directory name is different, or you want to use a different config file name.
</dropdown>

<dropdown title="Step 2: Update the configuration file for your self-managed connector">
  Update the configuration file with the following settings to match your environment:
  - `elasticsearch.host`
  - `elasticsearch.api_key`
  - `connectors`
  If you’re running the connector service against a Dockerized version of Elasticsearch and Kibana, your config file will look like this:
  ```yaml
  # When connecting to your cloud deployment you should edit the host value
  elasticsearch.host: http://host.docker.internal:9200
  elasticsearch.api_key: <ELASTICSEARCH_API_KEY>

  connectors:
    -
      connector_id: <CONNECTOR_ID_FROM_KIBANA>
      service_type: notion
      api_key: <CONNECTOR_API_KEY_FROM_KIBANA>
  ```
  Using the `elasticsearch.api_key` is the recommended authentication method. However, you can also use `elasticsearch.username` and `elasticsearch.password` to authenticate with your Elasticsearch instance.Note: You can change other default configurations by simply uncommenting specific settings in the configuration file and modifying their values.
</dropdown>

<dropdown title="Step 3: Run the Docker image">
  Run the Docker image with the Connector Service using the following command:
  ```sh
  docker run \
  -v ~/connectors-config:/config \
  --network "elastic" \
  --tty \
  --rm \
  docker.elastic.co/integrations/elastic-connectors:9.3.0 \
  /app/bin/elastic-ingest \
  -c /config/config.yml
  ```
</dropdown>

Refer to [`DOCKER.md`](https://github.com/elastic/connectors/tree/main/docs/DOCKER.md) in the `elastic/connectors` repo for more details.
Find all available Docker images in the [official registry](https://www.docker.elastic.co/r/integrations/elastic-connectors).
<tip>
  We also have a quickstart self-managed option using Docker Compose, so you can spin up all required services at once: Elasticsearch, Kibana, and the connectors service. Refer to this [README](https://github.com/elastic/connectors/tree/main/scripts/stack#readme) in the `elastic/connectors` repo for more information.
</tip>


### Configuration

Note the following configuration fields:
<definitions>
  <definition term="Notion Secret Key(required)">
    Secret token assigned to your integration, for a particular workspace. Example:
    - `zyx-123453-12a2-100a-1123-93fd09d67394`
  </definition>
  <definition term="Databases(required)">
    Comma-separated list of database names to be fetched by the connector. If the value is `*`, connector will fetch all the databases available in the workspace. Example:
    - `database1, database2`
    - `*`
  </definition>
  <definition term="Pages(required)">
    Comma-separated list of page names to be fetched by the connector. If the value is `*`, connector will fetch all the pages available in the workspace. Examples:
    - `*`
    - `Page1, Page2`
  </definition>
  <definition term="Index Comments">
    Toggle to enable fetching and indexing of comments from the Notion workspace for the configured pages, databases and the corresponding child blocks. Default value is `False`.
  </definition>
</definitions>

<note>
  Enabling comment indexing could impact connector performance due to increased network calls. Therefore, by default this value is `False`.
</note>


#### Content Extraction

Refer to [content extraction](https://www.elastic.co/docs/reference/search-connectors/es-connectors-content-extraction).

### Documents and syncs

The connector syncs the following objects and entities:
- **Pages**
  - Includes metadata such as `page name`, `id`, `last updated time`, etc.
- **Blocks**
  - Includes metadata such as `title`, `type`, `id`, `content` (in case of file block), etc.
- **Databases**
  - Includes metadata such as `name`, `id`, `records`, `size`, etc.
- **Users**
  - Includes metadata such as `name`, `id`, `email address`, etc.
- **Comments**
  - Includes the content and metadata such as `id`, `last updated time`, `created by`, etc.
- **Note**: Comments are excluded by default.

<note>
  - Files bigger than 10 MB won’t be extracted.
  - Permissions are not synced. **All documents** indexed to an Elastic deployment will be visible to **all users with access** to the relevant Elasticsearch index.
</note>


### Sync rules

[Basic sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-basic) are identical for all connectors and are available by default.

### Advanced sync rules

<note>
  A [full sync](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-full) is required for advanced sync rules to take effect.
</note>

The following section describes **advanced sync rules** for this connector, to filter data in Notion *before* indexing into Elasticsearch. Advanced sync rules are defined through a source-specific DSL JSON snippet.
Advanced sync rules for Notion take the following parameters:
1. `searches`: Notion’s search filter to search by title.
2. `query`: Notion’s database query filter to fetch a specific database.


#### Examples

**Example 1**
Indexing every page where the title contains `Demo Page`:
```js
  {
    "searches": [
      {
        "filter": {
          "value": "page"
        },
        "query": "Demo Page"
      }
    ]
  }
```

**Example 2**
Indexing every database where the title contains `Demo Database`:
```js
{
  "searches": [
    {
      "filter": {
        "value": "database"
      },
      "query": "Demo Database"
    }
  ]
}
```

**Example 3**
Indexing every database where the title contains `Demo Database` and every page where the title contains `Demo Page`:
```js
{
  "searches": [
    {
      "filter": {
        "value": "database"
      },
      "query": "Demo Database"
    },
    {
      "filter": {
        "value": "page"
      },
      "query": "Demo Page"
    }
  ]
}
```

**Example 4**
Indexing all pages in the workspace:
```js
{
  "searches": [
    {
      "filter": {
        "value": "page"
      },
      "query": ""
    }
  ]
}
```

**Example 5**
Indexing all the pages and databases connected to the workspace:
```js
{
  "searches":[
    {
      "query":""
    }
  ]
}
```

**Example 6**
Indexing all the rows of a database where the record is `true` for the column `Task completed` and its property(datatype) is a checkbox:
```js
{
  "database_query_filters": [
    {
      "filter": {
          "property": "Task completed",
          "checkbox": {
            "equals": true
          }
      },
      "database_id": "database_id"
    }
  ]
}
```

**Example 7**
Indexing all rows of a specific database:
```js
{
  "database_query_filters": [
    {
      "database_id": "database_id"
    }
  ]
}
```

**Example 8**
Indexing all blocks defined in `searches` and `database_query_filters`:
```js
{
  "searches":[
    {
      "query":"External tasks",
      "filter":{
        "value":"database"
      }
    },
    {
      "query":"External tasks",
      "filter":{
        "value":"page"
      }
    }
  ],
  "database_query_filters":[
    {
      "database_id":"notion_database_id1",
      "filter":{
        "property":"Task completed",
        "checkbox":{
          "equals":true
        }
      }
    }
  ]
}
```

<note>
  In this example the `filter` object syntax for `database_query_filters` is defined per the [Notion documentation](https://developers.notion.com/reference/post-database-query-filter).
</note>


### Connector Client operations


#### End-to-end Testing

The connector framework enables operators to run functional tests against a real data source, using Docker Compose. You don’t need a running Elasticsearch instance or Notion source to run this test.
Refer to [Connector testing](/docs/reference/search-connectors/self-managed-connectors#es-build-connector-testing) for more details.
To perform E2E testing for the Notion connector, run the following command:
```shell
$ make ftest NAME=notion
```

For faster tests, add the `DATA_SIZE=small` flag:
```shell
make ftest NAME=notion DATA_SIZE=small
```

By default, `DATA_SIZE=MEDIUM`.

### Known issues

- **Updates to new pages may not be reflected immediately in the Notion API.**
  This could lead to these pages not being indexed by the connector, if a sync is initiated immediately after their addition. To ensure all pages are indexed, initiate syncs a few minutes after adding pages to Notion.
- **Notion’s Public API does not support linked databases.**
  Linked databases in Notion are copies of a database that can be filtered, sorted, and viewed differently. To fetch the information in a linked database, you need to target the original **source** database. For more details refer to the [Notion documentation](https://developers.notion.com/docs/working-with-databases#linked-databases).
- **Documents' `properties` objects are serialized as strings under `details`**.
  Notion’s schema for `properties` is not consistent, and can lead to `document_parsing_exceptions` if indexed to Elasticsearch as an object. For this reason, the `properties` object is instead serialized as a JSON string, and stored under the `details` field. If you need to search a sub-object from `properties`, you may need to post-process the `details` field in an ingest pipeline to extract your desired subfield(s).

Refer to [Known issues](https://www.elastic.co/docs/release-notes/elasticsearch/known-issues) for a list of known issues for all connectors.

### Troubleshooting

See [Troubleshooting](https://www.elastic.co/docs/reference/search-connectors/es-connectors-troubleshooting).

### Security

See [Security](https://www.elastic.co/docs/reference/search-connectors/es-connectors-security).