﻿---
title: Connector logs
description: This document describes logs for connectors. Note that self-managed deployments and self-managed connector logs are written to STDOUT. Self-managed connectors...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-logs
products:
  - Elasticsearch
---

# Connector logs
This document describes logs for connectors.

## Enable logs


### Self-managed connectors

Note that self-managed deployments and self-managed connector logs are written to `STDOUT`.
Self-managed connectors have the following logging options:
- Use the `service.log_level` setting in your connector service configuration file to specify the log level for the service.
  - Enable `elasticsearch.bulk.enable_operations_logging` to log the result of sending documents to Elasticsearch from connectors, for auditing and debugging. This setting depends on the `service.log_level` and will be logged at `DEBUG` level .
- Use the `elasticsearch.log_level` setting to specify the log level for the Elasticsearch *client* used by the connector service.


## View connector logs

You can view logs in Kibana.
You can filter by `service.type`:
- `enterprise-search`
- `connectors`


## Logs reference

Logs use Elastic Common Schema (ECS), without extensions. See [the ECS Reference^](https://www.elastic.co/docs/reference/ecs) for more information.
The fields logged are:
- `@timestamp`
- `log.level`
- `ecs.version`
- `labels.index_date`
- `tags`
- `log.logger`
- `service.type`
- `service.version`
- `process.name`
- `process.pid`
- `process.thread.id`

See [Logging^](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/update-elasticsearch-logging-levels) in the Elasticsearch documentation for more information.